/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.RequestedAuthnContext;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestedAuthnContextImpl
implements RequestedAuthnContext {
    public final String elementName = "RequestedAuthnContext";
    private boolean mutable = false;
    private List authnContextClassRef = null;
    private List authnContextDeclRef = null;
    private String comparison = null;

    public RequestedAuthnContextImpl() {
        this.mutable = true;
    }

    public RequestedAuthnContextImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
        this.makeImmutable();
    }

    public RequestedAuthnContextImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (doc == null) {
            SAML2SDKUtils.debug.message("RequestedAuthnContextImpl :Input is null.");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        this.parseElement(doc.getDocumentElement());
        this.makeImmutable();
    }

    private void parseElement(Element element) throws SAML2Exception {
        String eltName = element.getLocalName();
        if (eltName == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("parseElement(Element): local name missing");
            }
            throw new SAML2Exception("");
        }
        this.comparison = element.getAttribute("Comparison");
        if (!eltName.equals("RequestedAuthnContext")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("RequestedAuthnContextImpl: invalid element");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("AuthnContextClassRef")) {
                if (this.authnContextDeclRef != null) {
                    SAML2SDKUtils.debug.error("AuthnContext(Element): Shouldcontain either <AuthnContextClassRef> or <AuthnContextDeclRef>");
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
                }
                this.getAuthnContextClassRef().add(XMLUtils.getElementValue((Element)child));
                continue;
            }
            if (!childName.equals("AuthnContextDeclRef")) continue;
            if (this.authnContextClassRef != null) {
                SAML2SDKUtils.debug.error("AuthnContext(Element): Shouldcontain either <AuthnContextClassRef> or <AuthnContextDeclRef>");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
            }
            this.getAuthnContextDeclRef().add(XMLUtils.getElementValue((Element)child));
        }
    }

    public List getAuthnContextClassRef() {
        if (this.authnContextClassRef == null) {
            this.authnContextClassRef = new ArrayList();
        }
        return this.authnContextClassRef;
    }

    public void setAuthnContextClassRef(List value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        if (this.authnContextDeclRef != null && !this.authnContextDeclRef.isEmpty()) {
            SAML2SDKUtils.debug.error("setAuthnContextClassRef: Shouldcontain either <AuthnContextClassRef> or <AuthnContextDeclRef>");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        this.authnContextClassRef = value;
    }

    public List getAuthnContextDeclRef() {
        if (this.authnContextDeclRef == null) {
            this.authnContextDeclRef = new ArrayList();
        }
        return this.authnContextDeclRef;
    }

    public void setAuthnContextDeclRef(List value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        if (this.authnContextClassRef != null && !this.authnContextClassRef.isEmpty()) {
            SAML2SDKUtils.debug.error("setAuthnContextDeclRef: Shouldcontain either <AuthnContextClassRef> or <AuthnContextDeclRef>");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        this.authnContextDeclRef = value;
    }

    public String getComparison() {
        return this.comparison;
    }

    public void setComparison(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.comparison = value;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        String element;
        Iterator it;
        StringBuffer xml = new StringBuffer();
        String NS = "";
        String NSP = "";
        String assertNS = "";
        String assertNSP = "";
        if (declareNS) {
            NS = " xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"";
            assertNS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        if (includeNSPrefix) {
            NSP = "samlp:";
            assertNSP = "saml:";
        }
        xml.append("<").append(NSP).append("RequestedAuthnContext");
        xml.append(NS).append(" ");
        if (this.comparison == null) {
            this.comparison = "exact";
        }
        xml.append("Comparison=\"");
        xml.append(this.comparison);
        xml.append("\">");
        if (this.authnContextClassRef != null && this.authnContextDeclRef != null) {
            throw new SAML2Exception("");
        }
        if (this.authnContextClassRef != null && this.authnContextClassRef != Collections.EMPTY_LIST) {
            it = this.authnContextClassRef.iterator();
            while (it.hasNext()) {
                element = (String)it.next();
                xml.append("<").append(assertNSP);
                xml.append("AuthnContextClassRef").append(assertNS).append(">");
                xml.append(element);
                xml.append("</").append(assertNSP);
                xml.append("AuthnContextClassRef").append(">");
            }
        }
        if (this.authnContextDeclRef != null && this.authnContextDeclRef != Collections.EMPTY_LIST) {
            it = this.authnContextDeclRef.iterator();
            while (it.hasNext()) {
                element = (String)it.next();
                xml.append("<").append(assertNSP);
                xml.append("AuthnContextDeclRef").append(assertNS).append(">");
                xml.append(element);
                xml.append("</").append(assertNSP);
                xml.append("AuthnContextDeclRef").append(">");
            }
        }
        xml.append("</").append(NSP).append("RequestedAuthnContext").append(">");
        return xml.toString();
    }

    public void makeImmutable() {
        this.mutable = false;
        if (this.authnContextClassRef != null) {
            this.authnContextClassRef = Collections.unmodifiableList(this.authnContextClassRef);
        }
        if (this.authnContextDeclRef != null) {
            this.authnContextDeclRef = Collections.unmodifiableList(this.authnContextDeclRef);
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }
}

