/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.GetComplete;
import com.sun.identity.saml2.protocol.IDPEntry;
import com.sun.identity.saml2.protocol.IDPList;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IDPListImpl
implements IDPList {
    private List idpEntryList = null;
    private GetComplete getComplete;
    private boolean isMutable = false;

    public IDPListImpl() {
        this.isMutable = true;
    }

    public IDPListImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public IDPListImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public List getIDPEntries() {
        return this.idpEntryList;
    }

    public void setIDPEntries(List idpEntryList) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.idpEntryList = idpEntryList;
    }

    public GetComplete getGetComplete() {
        return this.getComplete;
    }

    public void setGetComplete(GetComplete getComplete) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.getComplete = getComplete;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        this.validateIDPEntryList(this.idpEntryList);
        StringBuffer xmlString = new StringBuffer(150);
        xmlString.append("<");
        if (includeNSPrefix) {
            xmlString.append("samlp:");
        }
        xmlString.append("IDPList").append(" ");
        if (declareNS) {
            xmlString.append(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"");
        }
        xmlString.append(">").append("\n");
        if (this.idpEntryList == null || this.idpEntryList.isEmpty()) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("noIDPEntry"));
        }
        Iterator i = this.idpEntryList.iterator();
        while (i.hasNext()) {
            IDPEntry idpEntry = (IDPEntry)i.next();
            if (idpEntry == null) continue;
            String idpEntryStr = idpEntry.toXMLString(includeNSPrefix, declareNS);
            xmlString.append(idpEntryStr).append("\n");
        }
        if (this.getComplete != null) {
            xmlString.append(this.getComplete.toXMLString(includeNSPrefix, declareNS)).append("\n");
        }
        xmlString.append("</samlp:").append("IDPList").append(">");
        return xmlString.toString();
    }

    public void makeImmutable() {
        if (this.isMutable) {
            if (this.idpEntryList != null && !this.idpEntryList.isEmpty()) {
                Iterator i = this.idpEntryList.iterator();
                while (i.hasNext()) {
                    IDPEntry idpEntry = (IDPEntry)i.next();
                    if (idpEntry == null || !idpEntry.isMutable()) continue;
                    idpEntry.makeImmutable();
                }
            }
            if (this.getComplete != null && this.getComplete.isMutable()) {
                this.getComplete.makeImmutable();
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    void parseElement(Element element) throws SAML2Exception {
        ProtocolFactory protoFactory = ProtocolFactory.getInstance();
        NodeList nList = element.getChildNodes();
        if (nList == null || nList.getLength() == 0) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("noIDPEntry"));
        }
        if (this.idpEntryList == null) {
            this.idpEntryList = new ArrayList();
        }
        for (int i = 0; i < nList.getLength(); ++i) {
            Node childNode = nList.item(i);
            String cName = childNode.getLocalName();
            if (cName == null) continue;
            if (cName.equals("IDPEntry")) {
                this.validateIDPEntry();
                this.idpEntryList.add(protoFactory.createIDPEntry(XMLUtils.print(childNode)));
                continue;
            }
            if (!cName.equals("GetComplete")) continue;
            this.validateGetComplete();
            Element getCompleteElement = (Element)childNode;
            this.getComplete = protoFactory.createGetComplete(getCompleteElement);
        }
        this.validateIDPEntryList(this.idpEntryList);
        this.idpEntryList = Collections.unmodifiableList(this.idpEntryList);
    }

    private void validateIDPEntryList(List idpEntryList) throws SAML2Exception {
        if (idpEntryList == null || idpEntryList.isEmpty()) {
            SAML2SDKUtils.debug.message("IDPEntry Object is required");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("noIDPEntry"));
        }
    }

    private void validateIDPEntry() throws SAML2Exception {
        if (this.getComplete != null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("IDPList Element should be the first element");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidProxyCount"));
        }
    }

    private void validateGetComplete() throws SAML2Exception {
        if (this.getComplete != null) {
            SAML2SDKUtils.debug.message("Too may GetComplete Elements");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
    }
}

