/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.xmlsig;

import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.apache.xml.internal.utils.URI;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;

public class OfflineResolver
extends ResourceResolverSpi {
    static Map _uriMap = null;
    static Map _mimeMap = null;

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        try {
            String URI2 = uri.getNodeValue();
            String newURI = (String)_uriMap.get(URI2);
            if (newURI != null) {
                FileInputStream is = new FileInputStream(newURI);
                XMLSignatureInput result = new XMLSignatureInput(is);
                result.setSourceURI(URI2);
                result.setMIMEType((String)_mimeMap.get(URI2));
                return result;
            }
            Object[] exArgs = new Object[]{"The URI " + URI2 + " is not configured for offline work"};
            throw new ResourceResolverException("generic.EmptyMessage", exArgs, uri, BaseURI);
        }
        catch (IOException ex) {
            throw new ResourceResolverException("generic.EmptyMessage", (Exception)ex, uri, BaseURI);
        }
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        String uriNodeValue = uri.getNodeValue();
        if (uriNodeValue.length() == 0 || uriNodeValue.startsWith("#")) {
            return false;
        }
        try {
            URI uriNew = new URI(new URI(BaseURI), uri.getNodeValue());
            if (uriNew.getScheme().equals("http")) {
                return true;
            }
        }
        catch (URI.MalformedURIException ex) {
            // empty catch block
        }
        return false;
    }

    private static void register(String URI2, String filename, String MIME) {
        _uriMap.put(URI2, filename);
        _mimeMap.put(URI2, MIME);
    }

    static {
        Init.init();
        _uriMap = new HashMap();
        _mimeMap = new HashMap();
        OfflineResolver.register("http://www.w3.org/TR/xml-stylesheet", "data/org/w3c/www/TR/xml-stylesheet.html", "text/html");
        OfflineResolver.register("http://www.w3.org/TR/2000/REC-xml-20001006", "data/org/w3c/www/TR/2000/REC-xml-20001006", "text/xml");
        OfflineResolver.register("http://www.nue.et-inf.uni-siegen.de/index.html", "data/org/apache/xml/security/temp/nuehomepage", "text/html");
        OfflineResolver.register("http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/id2.xml", "data/org/apache/xml/security/temp/id2.xml", "text/xml");
        OfflineResolver.register("http://xmldsig.pothole.com/xml-stylesheet.txt", "data/com/pothole/xmldsig/xml-stylesheet.txt", "text/xml");
    }
}

