/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.xmlsig;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.shared.encode.Base64;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;

public class JKSKeyProvider
implements KeyProvider {
    private KeyStore ks = null;
    private String privateKeyPass = null;
    private String keystorePass = "";
    private String keystoreFile = "";
    private String keystoreType = "JKS";
    private static final String DEFAULT_KEYSTORE_FILE_PROP = "com.sun.identity.saml.xmlsig.keystore";
    private static final String DEFAULT_KEYSTORE_PASS_FILE_PROP = "com.sun.identity.saml.xmlsig.storepass";
    private static final String DEFAULT_KEYSTORE_TYPE_PROP = "com.sun.identity.saml.xmlsig.storetype";
    private static final String DEFAULT_PRIVATE_KEY_PASS_FILE_PROP = "com.sun.identity.saml.xmlsig.keypass";
    HashMap keyTable = new HashMap();

    private void initialize(String keyStoreFilePropName, String keyStorePassFilePropName, String keyStoreTypePropName, String privateKeyPassFilePropName) {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        this.keystoreFile = SystemConfigurationUtil.getProperty(keyStoreFilePropName);
        if (this.keystoreFile == null || this.keystoreFile.length() == 0) {
            SAMLUtilsCommon.debug.error("JKSKeyProvider: keystore file does not exist");
        }
        String kspfile = SystemConfigurationUtil.getProperty(keyStorePassFilePropName);
        String tmp_ksType = SystemConfigurationUtil.getProperty(keyStoreTypePropName);
        if (null != tmp_ksType) {
            this.keystoreType = tmp_ksType.trim();
        }
        if (kspfile != null) {
            try {
                fis = new FileInputStream(kspfile);
                isr = new InputStreamReader(fis);
                br = new BufferedReader(isr);
                this.keystorePass = SAMLUtilsCommon.decodePassword(br.readLine());
                fis.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SAMLUtilsCommon.debug.error("JKSKeyProvider.initialize: Unable to read keystore password file " + kspfile);
            }
        } else {
            SAMLUtilsCommon.debug.error("JKSKeyProvider: keystore password is null");
        }
        String pkpfile = SystemConfigurationUtil.getProperty(privateKeyPassFilePropName);
        if (pkpfile != null) {
            try {
                fis = new FileInputStream(pkpfile);
                isr = new InputStreamReader(fis);
                br = new BufferedReader(isr);
                this.privateKeyPass = SAMLUtilsCommon.decodePassword(br.readLine());
                fis.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SAMLUtilsCommon.debug.error("JKSKeyProvider.initialize: Unable to read privatekey password file " + kspfile);
            }
        }
    }

    private void mapPk2Cert() {
        try {
            this.ks = KeyStore.getInstance(this.keystoreType);
            FileInputStream fis = new FileInputStream(this.keystoreFile);
            this.ks.load(fis, this.keystorePass.toCharArray());
            Enumeration<String> e = this.ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate cert = this.getCertificate(alias);
                PublicKey pk = this.getPublicKey(alias);
                String key = Base64.encode(pk.getEncoded());
                this.keyTable.put(key, cert);
            }
            SAMLUtilsCommon.debug.message("KeyTable size = " + this.keyTable.size());
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("mapPk2Cert.JKSKeyProvider:", e);
        }
    }

    public JKSKeyProvider() {
        this(DEFAULT_KEYSTORE_FILE_PROP, DEFAULT_KEYSTORE_PASS_FILE_PROP, DEFAULT_KEYSTORE_TYPE_PROP, DEFAULT_PRIVATE_KEY_PASS_FILE_PROP);
    }

    public JKSKeyProvider(String keyStoreFilePropName, String keyStorePassFilePropName, String keyStoreTypePropName, String privateKeyPassFilePropName) {
        this.initialize(keyStoreFilePropName, keyStorePassFilePropName, keyStoreTypePropName, privateKeyPassFilePropName);
        this.mapPk2Cert();
    }

    public void setKey(String storepass, String keypass) {
        this.keystorePass = storepass;
        this.privateKeyPass = keypass;
    }

    public X509Certificate getX509Certificate(String certAlias) {
        if (certAlias == null || certAlias.length() == 0) {
            return null;
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.ks.getCertificate(certAlias);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("Unable to get cert alias:" + certAlias, e);
        }
        return cert;
    }

    public PublicKey getPublicKey(String keyAlias) {
        if (keyAlias == null || keyAlias.length() == 0) {
            return null;
        }
        PublicKey pkey = null;
        try {
            X509Certificate cert = (X509Certificate)this.ks.getCertificate(keyAlias);
            pkey = cert.getPublicKey();
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("Unable to get public key:" + keyAlias, e);
        }
        return pkey;
    }

    public PrivateKey getPrivateKey(String certAlias) {
        PrivateKey key = null;
        try {
            key = (PrivateKey)this.ks.getKey(certAlias, this.privateKeyPass.toCharArray());
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error(e.getMessage());
        }
        return key;
    }

    public String getCertificateAlias(Certificate cert) {
        String certalias = null;
        try {
            if (this.ks != null) {
                certalias = this.ks.getCertificateAlias(cert);
            }
        }
        catch (KeyStoreException ke) {
            return null;
        }
        return certalias;
    }

    public String getPrivateKeyPass() {
        return this.privateKeyPass;
    }

    public KeyStore getKeyStore() {
        return this.ks;
    }

    public void setCertificateEntry(String certAlias, Certificate cert) throws SAMLException {
        try {
            this.ks.setCertificateEntry(certAlias, cert);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error(e.getMessage());
            throw new SAMLException(e.getMessage());
        }
    }

    public Certificate getCertificate(String certAlias) {
        try {
            return this.ks.getCertificate(certAlias);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error(e.getMessage());
            return null;
        }
    }

    public void store() throws SAMLException {
        try {
            FileOutputStream keyStoreOStream = new FileOutputStream(this.keystoreFile);
            this.ks.store(keyStoreOStream, this.keystorePass.toCharArray());
            keyStoreOStream.close();
            keyStoreOStream = null;
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Keystore saved in " + this.keystoreFile);
            }
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error(e.getMessage());
            throw new SAMLException(e.getMessage());
        }
    }

    public Certificate getCertificate(PublicKey publicKey) {
        String key = Base64.encode(publicKey.getEncoded());
        return (Certificate)this.keyTable.get(key);
    }
}

