/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import java.util.Date;
import org.w3c.dom.Element;

public abstract class AbstractResponse {
    protected String responseID = null;
    protected String inResponseTo = null;
    protected int majorVersion = 1;
    protected int minorVersion = SAMLConstants.PROTOCOL_MINOR_VERSION;
    protected Element signature = null;
    protected Date issueInstant = null;
    protected String recipient = null;
    protected boolean signed = false;
    protected boolean valid = true;
    protected boolean validationDone = false;

    protected AbstractResponse() {
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isSignatureValid() {
        return this.valid;
    }

    public abstract void signXML() throws SAMLException;

    public String getResponseID() {
        return this.responseID;
    }

    public boolean setResponseID(String responseID) {
        if (this.signed) {
            return false;
        }
        if (responseID == null || responseID.length() == 0) {
            return false;
        }
        this.responseID = responseID;
        return true;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public boolean setInResponseTo(String inResponseTo) {
        if (this.signed) {
            return false;
        }
        if (inResponseTo == null || inResponseTo.length() == 0) {
            return false;
        }
        this.inResponseTo = inResponseTo;
        return true;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public Element getSignature() {
        return this.signature;
    }

    public boolean setSignature(Element elem) {
        if (this.signed) {
            return false;
        }
        if (elem == null) {
            return false;
        }
        this.signature = elem;
        this.signed = true;
        return true;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public boolean setIssueInstant(Date issueInstant) {
        if (this.signed) {
            return false;
        }
        if (issueInstant == null) {
            return false;
        }
        this.issueInstant = issueInstant;
        return true;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public boolean setRecipient(String recipient) {
        if (this.signed) {
            return false;
        }
        if (recipient == null || recipient.length() == 0) {
            return false;
        }
        this.recipient = recipient;
        return true;
    }
}

