/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.plugins;

import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.AssertionManagerClient;
import com.sun.identity.saml.assertion.Action;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.Evidence;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.plugins.ActionMapper;
import com.sun.identity.saml.protocol.AuthorizationDecisionQuery;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class DefaultActionMapper
implements ActionMapper {
    public String getSSOTokenID(AuthorizationDecisionQuery query) {
        if (query == null) {
            return null;
        }
        SubjectConfirmation sc = query.getSubject().getSubjectConfirmation();
        if (sc == null) {
            return null;
        }
        if (!SAMLUtils.isCorrectConfirmationMethod(sc)) {
            return null;
        }
        Element scData = sc.getSubjectConfirmationData();
        return XMLUtils.getElementString(scData);
    }

    public Assertion getSSOAssertion(AuthorizationDecisionQuery query, String sourceID) {
        block13: {
            if (query == null) {
                return null;
            }
            Assertion assertion = null;
            Evidence evi = query.getEvidence();
            if (evi != null) {
                Set idRefs;
                Set assertions = evi.getAssertion();
                if (assertions != null) {
                    Iterator iter = assertions.iterator();
                    while (iter.hasNext()) {
                        assertion = (Assertion)iter.next();
                        if (!SAMLUtils.isAuthNAssertion(assertion)) continue;
                        return assertion;
                    }
                }
                if ((idRefs = evi.getAssertionIDReference()) != null) {
                    Iterator iter = idRefs.iterator();
                    try {
                        AssertionManager am = AssertionManager.getInstance();
                        AssertionIDReference idRef = null;
                        while (iter.hasNext()) {
                            idRef = (AssertionIDReference)iter.next();
                            try {
                                String remoteUrl = SAMLUtils.getServerURL(idRef.getAssertionIDReference());
                                if (remoteUrl != null) {
                                    if (SAMLUtils.debug.messageEnabled()) {
                                        SAMLUtils.debug.message("DefaultActionMapper: calling another in lb site:" + remoteUrl);
                                    }
                                    AssertionManagerClient amc = new AssertionManagerClient(SAMLUtils.getFullServiceURL(remoteUrl));
                                    assertion = amc.getAssertion(idRef, sourceID);
                                } else {
                                    assertion = am.getAssertion(idRef, sourceID);
                                }
                            }
                            catch (Exception e) {
                                if (!SAMLUtils.debug.messageEnabled()) continue;
                                SAMLUtils.debug.message("DefaultActionMapper.getSSOAssertion: exception when retrieving Assertion from IDRef:" + e);
                                continue;
                            }
                            if (!SAMLUtils.isAuthNAssertion(assertion)) continue;
                            return assertion;
                        }
                    }
                    catch (Exception e) {
                        if (!SAMLUtils.debug.messageEnabled()) break block13;
                        SAMLUtils.debug.message("DefaultActionMapper: Couldn't obtain AssertionManager instance:" + e);
                    }
                }
            }
        }
        return null;
    }

    public Map getAuthorizationDecisions(AuthorizationDecisionQuery query, Object token, String sourceID) throws SAMLException {
        if (query == null || token == null) {
            SAMLUtils.debug.message("DefaultActionMapper: null input.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        Evidence evidence = query.getEvidence();
        Subject querySubject = query.getSubject();
        Map envParameters = this.convertEvidence(evidence, querySubject, sourceID);
        ArrayList<Action> permitActions = new ArrayList<Action>();
        ArrayList<Action> denyActions = new ArrayList<Action>();
        List actions = query.getAction();
        Iterator iterator = actions.iterator();
        PolicyEvaluator pe = null;
        String resource = query.getResource();
        Action action = null;
        String actionNamespace = null;
        while (iterator.hasNext()) {
            action = (Action)iterator.next();
            actionNamespace = action.getNameSpace();
            if (actionNamespace == null || !actionNamespace.equals("urn:oasis:names:tc:SAML:1.0:ghpp")) continue;
            try {
                boolean result;
                if (pe == null) {
                    pe = new PolicyEvaluator("iPlanetAMWebAgentService");
                }
                if (result = pe.isAllowed((SSOToken)token, resource, action.getAction(), envParameters)) {
                    permitActions.add(action);
                    continue;
                }
                denyActions.add(action);
            }
            catch (Exception e) {
                if (!SAMLUtils.debug.messageEnabled()) continue;
                SAMLUtils.debug.message("DefaultActionMapper: Exception from policy:" + e);
            }
        }
        HashMap<String, List> resultMap = new HashMap<String, List>();
        if (!permitActions.isEmpty()) {
            resultMap.put("Permit", permitActions);
        } else if (!denyActions.isEmpty()) {
            resultMap.put("Deny", denyActions);
        } else {
            resultMap.put("Indeterminate", actions);
        }
        return resultMap;
    }

    private Map convertEvidence(Evidence evidence, Subject subject, String sourceID) {
        Set assertions;
        String issuer;
        String siteName;
        Assertion assertion;
        Iterator iterator;
        HashMap envParams;
        block12: {
            envParams = new HashMap();
            if (evidence == null) {
                return envParams;
            }
            iterator = null;
            assertion = null;
            siteName = (String)SAMLServiceManager.getAttribute("mysitename");
            issuer = null;
            Set idRefs = evidence.getAssertionIDReference();
            if (idRefs != null) {
                iterator = idRefs.iterator();
                try {
                    AssertionManager am = AssertionManager.getInstance();
                    AssertionIDReference idRef = null;
                    while (iterator.hasNext()) {
                        idRef = (AssertionIDReference)iterator.next();
                        try {
                            String remoteUrl = SAMLUtils.getServerURL(idRef.getAssertionIDReference());
                            if (remoteUrl != null) {
                                if (SAMLUtils.debug.messageEnabled()) {
                                    SAMLUtils.debug.message("DefaultActionMapper:calling another server in lb site:" + remoteUrl);
                                }
                                AssertionManagerClient amc = new AssertionManagerClient(SAMLUtils.getFullServiceURL(remoteUrl));
                                assertion = amc.getAssertion(idRef, sourceID);
                            } else {
                                assertion = am.getAssertion(idRef, sourceID);
                            }
                        }
                        catch (Exception e) {
                            if (!SAMLUtils.debug.messageEnabled()) continue;
                            SAMLUtils.debug.message("DefaultActionMapper: couldn't retrieve assertion from idRef:" + e);
                            continue;
                        }
                        SAMLUtils.addEnvParamsFromAssertion(envParams, assertion, subject);
                    }
                }
                catch (Exception e) {
                    if (!SAMLUtils.debug.messageEnabled()) break block12;
                    SAMLUtils.debug.message("DefaultActionMapper: Couldn't obtain AssertionManager instance:" + e);
                }
            }
        }
        if ((assertions = evidence.getAssertion()) != null) {
            iterator = assertions.iterator();
            while (iterator.hasNext()) {
                SAMLServiceManager.SOAPEntry sourceSite;
                assertion = (Assertion)iterator.next();
                if (!assertion.isSignatureValid() || !assertion.isTimeValid()) continue;
                issuer = assertion.getIssuer();
                if ((siteName == null || !siteName.equals(issuer)) && (sourceSite = SAMLUtils.getSourceSite(issuer)) == null) continue;
                SAMLUtils.addEnvParamsFromAssertion(envParams, assertion, subject);
            }
        }
        return envParams;
    }
}

