/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class ResourceResultRequest {
    static final String GET_RESOURCE_RESULTS = "GetResourceResults";
    static final String USER_SSOTOKEN = "userSSOToken";
    static final String SERVICE_NAME = "serviceName";
    static final String RESOURCE_NAME = "resourceName";
    static final String RESOURCE_SCOPE = "resourceScope";
    static final String ENV_PARAMETERS = "EnvParameters";
    static final String GET_RESPONSE_DECISIONS = "GetResponseDecisions";
    static final String RESOURCE_SCOPE_SELF = "self";
    static final String RESOURCE_SCOPE_STRICT_SUBTREE = "strict-subtree";
    static final String RESOURCE_SCOPE_SUBTREE = "subtree";
    static final String RESPONSE_ATTRIBUTES_ONLY = "response-attributes-only";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    private String userSSOToken = null;
    private String serviceName = null;
    private String resourceName = null;
    private String resourceScope = null;
    private Map envParms = null;
    private Set respAttributes = null;

    public String getUserSSOToken() {
        return this.userSSOToken;
    }

    public void setUserSSOToken(String ssoToken) {
        this.userSSOToken = ssoToken;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String name) {
        this.resourceName = name;
    }

    public String getResourceScope() {
        return this.resourceScope;
    }

    public void setResourceScope(String scope) {
        this.resourceScope = scope;
    }

    public Map getEnvParms() {
        return this.envParms;
    }

    public void setEnvParms(Map envs) {
        this.envParms = envs;
    }

    public Set getResponseAttributes() {
        return this.respAttributes;
    }

    public void setResponseAttributes(Set attrs) {
        this.respAttributes = attrs;
    }

    public static ResourceResultRequest parseXML(Node pNode) throws PolicyEvaluationException {
        ResourceResultRequest resResultReq = new ResourceResultRequest();
        String attr = null;
        attr = XMLUtils.getNodeAttributeValue(pNode, USER_SSOTOKEN);
        if (attr == null || attr.trim().equals("")) {
            if (debug.messageEnabled()) {
                debug.error("ResourceResultRequest: user sso toekn is null");
            }
            attr = "";
        }
        resResultReq.setUserSSOToken(attr);
        attr = XMLUtils.getNodeAttributeValue(pNode, SERVICE_NAME);
        if (attr == null) {
            debug.error("ResourceResultRequest: missing attribute serviceName");
            Object[] objs = new String[]{SERVICE_NAME};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objs, null);
        }
        resResultReq.setServiceName(attr);
        attr = XMLUtils.getNodeAttributeValue(pNode, RESOURCE_NAME);
        if (attr == null) {
            debug.error("ResourceResultRequest: missing attribute resourceName");
            Object[] objs = new String[]{RESOURCE_NAME};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objs, null);
        }
        resResultReq.setResourceName(attr);
        attr = XMLUtils.getNodeAttributeValue(pNode, RESOURCE_SCOPE);
        if (attr == null) {
            resResultReq.setResourceScope(RESOURCE_SCOPE_STRICT_SUBTREE);
        } else if (attr.equals(RESOURCE_SCOPE_SUBTREE) || attr.equals(RESOURCE_SCOPE_STRICT_SUBTREE) || attr.equals(RESOURCE_SCOPE_SELF) || attr.equals(RESPONSE_ATTRIBUTES_ONLY)) {
            resResultReq.setResourceScope(attr);
        } else {
            debug.error("ResourceResultRequest: invalid value " + attr + " set for attribute " + RESOURCE_SCOPE);
            Object[] objs = new String[]{attr, RESOURCE_SCOPE};
            throw new PolicyEvaluationException("amPolicy", "invalid_value_for_attribute", objs, null);
        }
        Node node = XMLUtils.getChildNode(pNode, ENV_PARAMETERS);
        if (node != null) {
            try {
                resResultReq.setEnvParms(PolicyUtils.parseEnvParameters(node));
            }
            catch (PolicyException pe) {
                throw new PolicyEvaluationException(pe);
            }
        }
        if ((node = XMLUtils.getChildNode(pNode, GET_RESPONSE_DECISIONS)) != null) {
            try {
                resResultReq.setResponseAttributes(PolicyUtils.parseResponseAttributes(node));
            }
            catch (PolicyException pe) {
                throw new PolicyEvaluationException(pe);
            }
        }
        return resResultReq;
    }

    public String toXMLString() {
        StringBuffer xmlsb = new StringBuffer(1000);
        xmlsb.append("<").append(GET_RESOURCE_RESULTS);
        xmlsb.append(" ").append(USER_SSOTOKEN).append("=\"").append(this.userSSOToken != null ? this.userSSOToken : "").append("\"");
        xmlsb.append(" ").append(SERVICE_NAME).append("=\"").append(this.serviceName).append("\"");
        xmlsb.append(" ").append(RESOURCE_NAME).append("=\"").append(XMLUtils.escapeSpecialCharacters(this.resourceName)).append("\"");
        xmlsb.append(" ").append(RESOURCE_SCOPE).append("=\"").append(this.resourceScope).append("\">").append(CRLF);
        if (this.envParms != null) {
            xmlsb.append(PolicyUtils.envParametersToXMLString(this.envParms));
        }
        if (this.respAttributes != null) {
            xmlsb.append(PolicyUtils.responseAttributesToXMLString(this.respAttributes));
        }
        xmlsb.append("</").append(GET_RESOURCE_RESULTS).append(">").append(CRLF);
        return xmlsb.toString();
    }
}

