/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.client.AlreadyRegisteredException;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.client.SendRequestException;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ResourceResult;
import com.sun.identity.policy.client.InvalidAppSSOTokenException;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.client.PolicyNotificationHandler;
import com.sun.identity.policy.client.PolicyProperties;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.policy.remote.AdvicesHandleableByAMRequest;
import com.sun.identity.policy.remote.AdvicesHandleableByAMResponse;
import com.sun.identity.policy.remote.PolicyChangeNotification;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyListenerRequest;
import com.sun.identity.policy.remote.PolicyNotification;
import com.sun.identity.policy.remote.PolicyRequest;
import com.sun.identity.policy.remote.PolicyResponse;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.policy.remote.RemoveListenerRequest;
import com.sun.identity.policy.remote.ResourceResultRequest;
import com.sun.identity.shared.debug.Debug;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class ResourceResultCache
implements SSOTokenListener {
    private static ResourceResultCache resourceResultCache;
    private PolicyProperties policyProperties;
    private Set remotePolicyListeners = Collections.synchronizedSet(new HashSet(10));
    private Map resultCache = new HashMap(10);
    private PolicyNotificationHandler notificationHandler;
    private Set tokenRegistry = Collections.synchronizedSet(new HashSet(10000));
    private int cacheTtl;
    private Set advicesHandleableByAM;
    private static Debug debug;
    private static final String POLICY_SERVICE_ID_FOR_NAMING = "policy";
    private static final String GET_RESPONSE_ATTRIBUTES = "Get_Response_Attributes";
    private static long requestID;
    private static String REQUEST_ID_LOCK;
    private static String SECRET_MASK;

    private ResourceResultCache(PolicyProperties policyProperties) throws PolicyException {
        this.policyProperties = policyProperties;
        this.notificationHandler = new PolicyNotificationHandler(this);
        this.cacheTtl = policyProperties.getCacheTtl();
        if (policyProperties.notificationEnabled()) {
            this.registerHandlerWithPLLClient(this.notificationHandler);
            if (debug.messageEnabled()) {
                debug.message("RsourceResultCache():added policyNotificationHandler with PLLClient");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("RsourceResultCache():Singleton Instance Created");
        }
    }

    static synchronized ResourceResultCache getInstance(PolicyProperties policyProperties) throws PolicyException {
        if (resourceResultCache == null) {
            resourceResultCache = new ResourceResultCache(policyProperties);
        } else {
            ResourceResultCache.resourceResultCache.policyProperties = policyProperties;
            ResourceResultCache.resourceResultCache.cacheTtl = policyProperties.getCacheTtl();
        }
        return resourceResultCache;
    }

    private static synchronized ResourceResultCache getInstance() {
        if (resourceResultCache == null && debug.warningEnabled()) {
            debug.warning("ResourceResultCache.getInstance():ResourceResultCache has not been created:returning null");
        }
        return resourceResultCache;
    }

    PolicyDecision getPolicyDecision(SSOToken appToken, String serviceName, SSOToken token, String resourceName, Set actionNames, Map env, int retryCount) throws InvalidAppSSOTokenException, PolicyException, SSOException {
        int count = 0;
        boolean validTtl = false;
        PolicyDecision pd = this.getPolicyDecision(appToken, serviceName, token, resourceName, actionNames, env, true);
        if (pd.getTimeToLive() > System.currentTimeMillis()) {
            validTtl = true;
        }
        while (!validTtl && count < retryCount) {
            ++count;
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getPolicyDecision():Received expired decision, Getting decision again, repeat attempt=" + count);
            }
            if ((pd = this.getPolicyDecision(appToken, serviceName, token, resourceName, actionNames, env, false)).getTimeToLive() <= System.currentTimeMillis()) continue;
            validTtl = true;
            break;
        }
        if (!validTtl) {
            if (debug.warningEnabled()) {
                debug.warning("ResourceResultCache.getPolicyDecision():Received expired decision from server");
            }
            Object[] args = new Object[]{resourceName};
            throw new PolicyEvaluationException("amPolicy", "received_expired_decision", args, null);
        }
        if (actionNames != null) {
            PolicyDecision pd1 = new PolicyDecision();
            Iterator nameIter = actionNames.iterator();
            while (nameIter.hasNext()) {
                String actionName = (String)nameIter.next();
                Map actionDecisions = pd.getActionDecisions();
                ActionDecision ad = (ActionDecision)actionDecisions.get(actionName);
                if (ad == null) continue;
                pd1.addActionDecision(ad);
            }
            HashMap mergedReponseAttrsMap = new HashMap();
            PolicyUtils.appendMapToMap(pd.getResponseAttributes(), mergedReponseAttrsMap);
            pd1.setResponseAttributes(mergedReponseAttrsMap);
            pd = pd1;
        } else {
            pd = (PolicyDecision)pd.clone();
        }
        return pd;
    }

    private PolicyDecision getPolicyDecision(SSOToken appToken, String serviceName, SSOToken token, String resourceName, Set actionNames, Map env, boolean useCache) throws InvalidAppSSOTokenException, PolicyException, SSOException {
        String cacheMode = this.policyProperties.getCacheMode();
        String rootResourceName = resourceName;
        if ("subtree".equals(cacheMode)) {
            rootResourceName = this.getRootResourceName(resourceName, serviceName);
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getPolicyDecision():resourceName=" + resourceName + ":cacheMode=" + cacheMode + ":would get resource results for root resource=" + rootResourceName);
            }
        }
        Set resourceResults = this.getResourceResults(appToken, serviceName, token, rootResourceName, actionNames, env, cacheMode, useCache);
        ResourceName resourceComparator = this.policyProperties.getResourceComparator(serviceName);
        PolicyDecision pd = this.getPolicyDecisionFromResourceResults(resourceResults, resourceName, resourceComparator, serviceName);
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getPolicyDecision()::serviceName=" + serviceName + ":token=" + token.getPrincipal().getName() + ":resourceName=" + resourceName + ":actionNames=" + actionNames + ":env" + ":cacehMode=" + cacheMode + ":useCache=" + useCache + ":returning policyDecision:" + pd);
        }
        return pd;
    }

    private Set getResourceResults(SSOToken appToken, String serviceName, SSOToken token, String resourceName, Set actionNames, Map env, String scope) throws InvalidAppSSOTokenException, PolicyException, SSOException {
        return this.getResourceResults(appToken, serviceName, token, resourceName, actionNames, env, scope, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getResourceResults(SSOToken appToken, String serviceName, SSOToken token, String resourceName, Set actionNames, Map env, String scope, boolean useCache) throws InvalidAppSSOTokenException, PolicyException, SSOException {
        SSOTokenManager.getInstance().validateToken(token);
        String cacheMode = this.policyProperties.getCacheMode();
        Set resourceResults = null;
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getResourceResults()::serviceName=" + serviceName + ":token=" + token.getPrincipal().getName() + ":resourceName=" + resourceName + ":actionNames=" + actionNames + ":env" + ":useCache=" + useCache + ":entering ");
        }
        HashMap resourceTokenIDsMap = null;
        Map map = this.resultCache;
        synchronized (map) {
            resourceTokenIDsMap = (HashMap)this.resultCache.get(serviceName);
            if (resourceTokenIDsMap == null) {
                resourceTokenIDsMap = new HashMap();
                this.resultCache.put(serviceName, resourceTokenIDsMap);
            }
        }
        HashMap tokenIDScopesMap = null;
        HashMap hashMap = resourceTokenIDsMap;
        synchronized (hashMap) {
            tokenIDScopesMap = (HashMap)resourceTokenIDsMap.get(resourceName);
            if (tokenIDScopesMap == null) {
                tokenIDScopesMap = new HashMap();
                resourceTokenIDsMap.put(resourceName, tokenIDScopesMap);
            }
        }
        HashMap<String, Object[]> scopeResultsMap = null;
        String tokenID = ((Object)token.getTokenID()).toString();
        HashMap hashMap2 = tokenIDScopesMap;
        synchronized (hashMap2) {
            scopeResultsMap = (HashMap<String, Object[]>)tokenIDScopesMap.get(tokenID);
            if (scopeResultsMap == null) {
                scopeResultsMap = new HashMap<String, Object[]>();
                tokenIDScopesMap.put(tokenID, scopeResultsMap);
                if (!this.tokenRegistry.contains(tokenID)) {
                    token.addSSOTokenListener(this);
                    this.tokenRegistry.add(tokenID);
                }
            }
        }
        Object[] results = null;
        HashMap<String, Object[]> hashMap3 = scopeResultsMap;
        synchronized (hashMap3) {
            results = (Object[])scopeResultsMap.get(scope);
            if (results == null) {
                results = new Object[4];
                scopeResultsMap.put(scope, results);
            }
            boolean fetchResultsFromServer = false;
            if (!useCache) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since useCache is false");
                }
                fetchResultsFromServer = true;
            } else if (results[0] == null) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server  since results not in cache");
                }
                fetchResultsFromServer = true;
            } else if (env == null && results[1] != null) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since env does not match");
                }
                fetchResultsFromServer = true;
            } else if (env != null && !((Object)env).equals(results[1])) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since env does not Match");
                }
                fetchResultsFromServer = true;
            } else if ((Long)results[2] < System.currentTimeMillis()) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since results ttl has  expired");
                }
                fetchResultsFromServer = true;
            } else if (actionNames == null && results[3] != null) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since action names do not  match");
                }
                fetchResultsFromServer = true;
            } else if (actionNames != null && results[3] == null) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since action names do not  Match");
                }
                fetchResultsFromServer = true;
            } else if (results[3] != null && !((Set)results[3]).containsAll(actionNames)) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since cached action names  do not cover request action names");
                }
                fetchResultsFromServer = true;
            } else if (this.resourceResultsHasAdvices((Set)results[0]) && "self".equals(cacheMode)) {
                fetchResultsFromServer = true;
            }
            if (fetchResultsFromServer) {
                resourceResults = this.getResultsFromServer(appToken, serviceName, token, resourceName, scope, actionNames, env);
                results[0] = resourceResults;
                if (env != null) {
                    env = PolicyUtils.cloneMap(env);
                }
                results[1] = env;
                results[2] = new Long(System.currentTimeMillis() + (long)this.cacheTtl);
                if (actionNames != null) {
                    HashSet actionNames1 = actionNames;
                    actionNames = new HashSet();
                    actionNames.addAll(actionNames1);
                }
                results[3] = actionNames;
            } else if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getResourceResults():would not contact server,  would use results from  cache ");
            }
        }
        resourceResults = (Set)results[0];
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getResourceResults(" + serviceName + "," + token.getPrincipal().getName() + "," + resourceName + "," + actionNames + ",env)" + ": returning resourceResults");
        }
        return resourceResults;
    }

    private Set getResultsFromServer(SSOToken appToken, String serviceName, SSOToken token, String resourceName, String scope, Set actionNames, Map env) throws InvalidAppSSOTokenException, SSOException, PolicyException {
        Set resourceResults = null;
        Object response = null;
        try {
            URL policyServiceUrl = ResourceResultCache.getPolicyServiceURL(token);
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getResultsFromServer()::serviceName=" + serviceName + ":token=" + token.getPrincipal().getName() + ":resourceName=" + resourceName + ":scope=" + scope + ":actionNames=" + actionNames + ":env" + ":policyServiceURL=" + policyServiceUrl + ":entering");
            }
            ResourceResultRequest rrRequest = new ResourceResultRequest();
            rrRequest.setServiceName(serviceName);
            rrRequest.setResourceName(resourceName);
            rrRequest.setResourceScope(scope);
            rrRequest.setUserSSOToken(((Object)token.getTokenID()).toString());
            Set responseAttributes = null;
            if (env != null) {
                rrRequest.setEnvParms(env);
                responseAttributes = this.getResponseAttributes(env);
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResultsFromServer():responseAttributes to get=" + responseAttributes);
                }
                if (responseAttributes != null) {
                    rrRequest.setResponseAttributes(responseAttributes);
                }
            }
            PolicyRequest policyRequest = new PolicyRequest();
            policyRequest.setAppSSOToken(((Object)appToken.getTokenID()).toString());
            policyRequest.setMethodID(1);
            policyRequest.setRequestId(this.newRequestID());
            policyRequest.setResourceResultRequest(rrRequest);
            PolicyService ps = ResourceResultCache.sendPLLRequest(policyServiceUrl, policyRequest);
            if (ps != null) {
                PolicyResponse pr = ps.getPolicyResponse();
                String exceptionMessage = pr.getExceptionMsg();
                if (exceptionMessage != null) {
                    if (exceptionMessage.indexOf(ResBundleUtils.getString("app_sso_token_invalid")) >= 0) {
                        if (debug.warningEnabled()) {
                            debug.warning("ResourceResultCache.getResultsFromServer(): response exception " + exceptionMessage);
                            debug.warning("ResourceResultCache.getResultsFromServer(): appSSOToken is invalid");
                            debug.warning("ResourceResultCache.throwing InvalidAppSSOTokenException");
                        }
                        Object[] args = new String[]{exceptionMessage};
                        throw new InvalidAppSSOTokenException("amPolicy", "server_reported_invalid_app_sso_token", args, null);
                    }
                    debug.warning("ResourceResultCache.getResultsFromServer():response exception message=" + exceptionMessage);
                    Object[] args = new String[]{exceptionMessage};
                    throw new PolicyEvaluationException("amPolicy", "server_reported_exception", args, null);
                }
                resourceResults = pr.getResourceResults();
            }
        }
        catch (SendRequestException sre) {
            Object[] args = new String[]{sre.getMessage()};
            throw new PolicyEvaluationException("amPolicy", "pll_send_request_exception", args, sre);
        }
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getResultsFromServer():returning");
        }
        return resourceResults;
    }

    private PolicyDecision getPolicyDecisionFromResourceResults(Set resourceResults, String resourceName, ResourceName resourceComparator, String serviceName) throws PolicyException {
        PolicyDecision pd = new PolicyDecision();
        resourceName = resourceComparator.canonicalize(resourceName);
        Iterator resultsIter = resourceResults.iterator();
        boolean processed = false;
        while (!processed && resultsIter.hasNext()) {
            ResourceResult resourceResult = (ResourceResult)resultsIter.next();
            processed = this.mergePolicyDecisions(pd, resourceResult, resourceName, resourceComparator, serviceName);
        }
        return pd;
    }

    private boolean mergePolicyDecisions(PolicyDecision pd, ResourceResult resourceResult, String resourceName, ResourceName resourceComparator, String serviceName) throws PolicyException {
        boolean processed;
        block6: {
            ResourceMatch result;
            block7: {
                block5: {
                    processed = false;
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.mergePolicyDecisions():resourceName=" + resourceName + ":resourceResultResourceName=" + resourceResult.getResourceName());
                    }
                    if (!(result = resourceComparator.compare(resourceName, resourceResult.getResourceName(), true)).equals(ResourceMatch.EXACT_MATCH)) break block5;
                    this.resetPolicyDecision(resourceResult.getPolicyDecision(), pd, serviceName);
                    processed = true;
                    break block6;
                }
                if (!result.equals(ResourceMatch.WILDCARD_MATCH)) break block7;
                this.mergePolicyDecisions(resourceResult.getPolicyDecision(), pd, serviceName);
                if (pd.getTimeToLive() < System.currentTimeMillis()) {
                    processed = true;
                }
                if (processed) break block6;
                Set resourceResults = resourceResult.getResourceResults();
                Iterator resultsIter = resourceResults.iterator();
                while (!processed && resultsIter.hasNext()) {
                    ResourceResult subResult = (ResourceResult)resultsIter.next();
                    processed = this.mergePolicyDecisions(pd, subResult, resourceName, resourceComparator, serviceName);
                }
                break block6;
            }
            if (result.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) {
                Set resourceResults = resourceResult.getResourceResults();
                Iterator resultsIter = resourceResults.iterator();
                while (!processed && resultsIter.hasNext()) {
                    ResourceResult subResult = (ResourceResult)resultsIter.next();
                    processed = this.mergePolicyDecisions(pd, subResult, resourceName, resourceComparator, serviceName);
                }
            }
        }
        return processed;
    }

    private PolicyDecision mergePolicyDecisions(PolicyDecision pd1, PolicyDecision pd2, String serviceName) {
        Map actionDecisions1 = pd1.getActionDecisions();
        HashSet actions = new HashSet();
        actions.addAll(actionDecisions1.keySet());
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            String action = (String)iter.next();
            ActionDecision ad1 = (ActionDecision)actionDecisions1.get(action);
            pd2.addActionDecision(ad1, this.policyProperties.getTrueValue(serviceName, action), this.policyProperties.getFalseValue(serviceName, action));
        }
        HashMap mergedReponseAttrsMap = new HashMap();
        PolicyUtils.appendMapToMap(pd1.getResponseAttributes(), mergedReponseAttrsMap);
        PolicyUtils.appendMapToMap(pd2.getResponseAttributes(), mergedReponseAttrsMap);
        pd2.setResponseAttributes(mergedReponseAttrsMap);
        return pd2;
    }

    private PolicyDecision resetPolicyDecision(PolicyDecision pd1, PolicyDecision pd2, String serviceName) {
        Map actionDecisions1 = pd1.getActionDecisions();
        Map actionDecisions2 = pd2.getActionDecisions();
        actionDecisions2.clear();
        HashSet actions = new HashSet();
        actions.addAll(actionDecisions1.keySet());
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            String action = (String)iter.next();
            ActionDecision ad1 = (ActionDecision)actionDecisions1.get(action);
            pd2.addActionDecision(ad1, this.policyProperties.getTrueValue(serviceName, action), this.policyProperties.getFalseValue(serviceName, action));
        }
        HashMap mergedReponseAttrsMap = new HashMap();
        PolicyUtils.appendMapToMap(pd1.getResponseAttributes(), mergedReponseAttrsMap);
        PolicyUtils.appendMapToMap(pd2.getResponseAttributes(), mergedReponseAttrsMap);
        pd2.setResponseAttributes(mergedReponseAttrsMap);
        return pd2;
    }

    void addRemotePolicyListener(SSOToken appToken, String serviceName, String notificationURL) {
        this.addRemotePolicyListener(appToken, serviceName, notificationURL, false);
    }

    boolean addRemotePolicyListener(SSOToken appToken, String serviceName, String notificationURL, boolean reRegister) {
        boolean status = false;
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.addRemotePolicyListener():serviceName=" + serviceName + ":notificationURL=" + notificationURL);
        }
        if (this.remotePolicyListeners.contains(serviceName) && !reRegister) {
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.addRemotePolicyListener():serviceName=" + serviceName + ":notificationURL=" + notificationURL + ":is already registered");
            }
            return status;
        }
        URL policyServiceURL = null;
        if (appToken != null) {
            try {
                policyServiceURL = ResourceResultCache.getPolicyServiceURL(appToken);
            }
            catch (PolicyException pe) {
                debug.error("ResourceResultCache.addRemotePolicyListener():Can not add policy listner", pe);
            }
        }
        if (appToken != null && policyServiceURL != null) {
            PolicyListenerRequest listenerReq = new PolicyListenerRequest();
            listenerReq.setServiceName(serviceName);
            listenerReq.setNotificationURL(notificationURL);
            PolicyRequest policyReq = new PolicyRequest();
            policyReq.setAppSSOToken(((Object)appToken.getTokenID()).toString());
            policyReq.setMethodID(2);
            policyReq.setPolicyListenerRequest(listenerReq);
            try {
                PolicyService ps = ResourceResultCache.sendPLLRequest(policyServiceURL, policyReq);
                if (ps != null) {
                    PolicyResponse psres;
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.addRemotePolicyListener():result=" + ps.toXMLString());
                    }
                    if ((psres = ps.getPolicyResponse()).getMethodID() == 2) {
                        status = true;
                        this.remotePolicyListeners.add(serviceName);
                        if (debug.messageEnabled()) {
                            debug.message("ResourceResultCache.addRemotePolicyListener():serviceName=" + serviceName + ":notificationURL=" + notificationURL + ":policyServiceURL=" + policyServiceURL + ":add succeeded");
                        }
                    }
                } else {
                    debug.error("ResourceResultCache.addRemotePolicyListener(): no result");
                }
            }
            catch (Exception e) {
                debug.error("ResourceResultCache.addRemotePolicyListener():", e);
            }
        }
        return status;
    }

    public boolean removeRemotePolicyListener(SSOToken appToken, String serviceName, String notificationURL) {
        boolean status = false;
        URL policyServiceURL = null;
        this.remotePolicyListeners.remove(notificationURL);
        if (appToken != null) {
            try {
                policyServiceURL = ResourceResultCache.getPolicyServiceURL(appToken);
            }
            catch (PolicyException pe) {
                debug.error("ResourceResultCache.removeRemotePolicyListener():Can not remove policy listner:", pe);
            }
        }
        if (appToken != null && policyServiceURL != null) {
            RemoveListenerRequest rmReq = new RemoveListenerRequest();
            rmReq.setServiceName(serviceName);
            rmReq.setNotificationURL(notificationURL);
            PolicyRequest policyReq = new PolicyRequest();
            policyReq.setAppSSOToken(((Object)appToken.getTokenID()).toString());
            policyReq.setMethodID(3);
            policyReq.setRemoveListenerRequest(rmReq);
            try {
                PolicyService ps = ResourceResultCache.sendPLLRequest(policyServiceURL, policyReq);
                if (ps != null) {
                    PolicyResponse psres;
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.removeRemotePolicyListener():result=" + ps.toXMLString());
                    }
                    if ((psres = ps.getPolicyResponse()).getMethodID() == 3) {
                        status = true;
                    }
                } else {
                    debug.message("ResourceResultCache.removeRemotePolicyListener():no result");
                }
            }
            catch (Exception e) {
                debug.error("ResourceResultCache.removeRemotePolicyListener():", e);
            }
        }
        return status;
    }

    static void processPolicyNotification(PolicyNotification pn) throws PolicyEvaluationException {
        if (pn != null) {
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache:processPolicyNotification():" + pn);
            }
            ResourceResultCache cache = ResourceResultCache.getInstance();
            PolicyChangeNotification pcn = pn.getPolicyChangeNotification();
            String serviceName = pcn.getServiceName();
            if (serviceName != null) {
                if (cache.remotePolicyListeners.contains(serviceName)) {
                    Set affectedResourceNames = pcn.getResourceNames();
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache:processPolicyNotification():serviceName=" + serviceName + ":affectedResourceNames=" + affectedResourceNames + ":clearing cache for affected " + "resource names");
                    }
                    ResourceResultCache.clearCacheForResourceNames(serviceName, affectedResourceNames);
                } else if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache:processPolicyNotification():serviceName not registered:no resource names cleared from cache");
                }
            } else if (debug.messageEnabled()) {
                debug.message("ResourceResultCache:processPolicyNotification():serviceName is null:no resource names cleared from cache");
            }
        } else {
            debug.error("ResourceResultCache.processPolicyNotification()PolicyNotification is null");
        }
    }

    private void registerHandlerWithPLLClient(PolicyNotificationHandler handler) {
        block3: {
            try {
                PLLClient.addNotificationHandler(POLICY_SERVICE_ID_FOR_NAMING, handler);
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.registerHandlerWithPLLClient():registered notification handler");
                }
            }
            catch (AlreadyRegisteredException ae) {
                if (!debug.warningEnabled()) break block3;
                debug.message("ResourceResultCache.registerHandlerWithPLLClient():AlreadyRegisteredException", ae);
            }
        }
    }

    static URL getPolicyServiceURL(SSOToken token) throws PolicyException {
        URL policyServiceURL = null;
        try {
            String ssoTokenID = ((Object)token.getTokenID()).toString();
            SessionID sid = new SessionID(ssoTokenID);
            Session session = Session.getSession(sid);
            URL sessionServiceURL = session.getSessionServiceURL();
            String protocol = sessionServiceURL.getProtocol();
            String host = sessionServiceURL.getHost();
            int port = sessionServiceURL.getPort();
            String uri = sessionServiceURL.getPath();
            String portString = null;
            portString = port == -1 ? "" : Integer.toString(port);
            policyServiceURL = WebtopNaming.getServiceURL(POLICY_SERVICE_ID_FOR_NAMING, protocol, host, portString, uri);
        }
        catch (SessionException se) {
            debug.error("ResourceResultCache.getPolicyServiceURL():Can not find policy service URL", se);
            throw new PolicyEvaluationException("amPolicy", "policy_service_url_not_found", null, se);
        }
        catch (URLNotFoundException ue) {
            debug.error("ResourceResultCache.getPolicyServiceURL():Can not find policy service URL", ue);
            throw new PolicyEvaluationException("amPolicy", "policy_service_url_not_found", null, ue);
        }
        return policyServiceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ssoTokenChanged(SSOTokenEvent tokenEvent) {
        block12: {
            String tokenID = ((Object)tokenEvent.getToken().getTokenID()).toString();
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.ssoTokenChanged():for tokenID=" + SECRET_MASK);
            }
            try {
                Map map = this.resultCache;
                synchronized (map) {
                    Set services = this.resultCache.keySet();
                    Iterator serviceIter = services.iterator();
                    while (serviceIter.hasNext()) {
                        Map resourceTokenIDsMap;
                        String serviceName = (String)serviceIter.next();
                        Map map2 = resourceTokenIDsMap = (Map)this.resultCache.get(serviceName);
                        synchronized (map2) {
                            Set resources = resourceTokenIDsMap.keySet();
                            Iterator resourceIter = resources.iterator();
                            while (resourceIter.hasNext()) {
                                String resource = (String)resourceIter.next();
                                Map tokenIDScopesMap = (Map)resourceTokenIDsMap.get(resource);
                                if (tokenIDScopesMap != null) {
                                    tokenIDScopesMap.remove(tokenID);
                                }
                                if (!debug.messageEnabled()) continue;
                                debug.message("ResourceResultCache.ssoTokenChanged():removing cache results for tokenID=" + SECRET_MASK + ":serviceName=" + serviceName + ":resource=" + resource);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (!debug.warningEnabled()) break block12;
                debug.warning("ResourceResultCache.ssoTokenChanged():Exception caught", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearCacheForResourceNames(String serviceName, Set affectedResourceNames) {
        if (affectedResourceNames == null || affectedResourceNames.isEmpty()) {
            return;
        }
        Map resourceTokenIDsMap = (Map)ResourceResultCache.resourceResultCache.resultCache.get(serviceName);
        if (resourceTokenIDsMap == null || resourceTokenIDsMap.isEmpty()) {
            return;
        }
        ResourceName resourceComparator = ResourceResultCache.resourceResultCache.policyProperties.getResourceComparator(serviceName);
        Iterator arIter = affectedResourceNames.iterator();
        while (arIter.hasNext()) {
            String affectedRN = (String)arIter.next();
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.clearCacheForResourceNames():affectedResourceName=" + affectedRN);
            }
            Map map = resourceTokenIDsMap;
            synchronized (map) {
                Set cachedResourceNames = resourceTokenIDsMap.keySet();
                Iterator crIter = cachedResourceNames.iterator();
                while (crIter.hasNext()) {
                    String cachedRN = (String)crIter.next();
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.clearCacheForResourceNames():affectedResourceName=" + affectedRN + ":cachedResourceName=" + cachedRN);
                    }
                    if (affectedRN.equals(cachedRN)) {
                        crIter.remove();
                        if (!debug.messageEnabled()) continue;
                        debug.message("ResourceResultCache.clearCacheForResourceNames():cleared cached results for resourceName=" + cachedRN + ":affectedResourceName=" + affectedRN + ":match=SAME RESOURCE NAME");
                        continue;
                    }
                    ResourceMatch rm = resourceComparator.compare(cachedRN, affectedRN, true);
                    if (rm.equals(ResourceMatch.EXACT_MATCH)) {
                        crIter.remove();
                        if (!debug.messageEnabled()) continue;
                        debug.message("ResourceResultCache.clearCacheForResourceNames():cleared cached results for resourceName=" + cachedRN + ":affectedResourceName=" + affectedRN + ":match=EXACT_MATCH");
                        continue;
                    }
                    if (rm.equals(ResourceMatch.WILDCARD_MATCH)) {
                        crIter.remove();
                        if (!debug.messageEnabled()) continue;
                        debug.message("ResourceResultCache.clearCacheForResourceNames():cleared cached results for resourceName=" + cachedRN + ":affectedResourceName=" + affectedRN + ":match=WILD_CARD_MATCH");
                        continue;
                    }
                    if (!rm.equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
                    crIter.remove();
                    if (!debug.messageEnabled()) continue;
                    debug.message("ResourceResultCache.clearCacheForResourceNames():cleared cached results for resourceName=" + cachedRN + ":affectedResourceName=" + affectedRN + ":match=SUB_RESOURCE_MACTH");
                }
            }
        }
    }

    private Set getResponseAttributes(Map env) {
        Set responseAttributes = null;
        if (env != null) {
            responseAttributes = (Set)env.get(GET_RESPONSE_ATTRIBUTES);
        }
        return responseAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newRequestID() {
        String requestIDString = null;
        String string = REQUEST_ID_LOCK;
        synchronized (string) {
            requestIDString = String.valueOf(requestID++);
        }
        return requestIDString;
    }

    private String getRootResourceName(String resource, String serviceName) {
        String[] resources;
        int index;
        ResourceName resourceComparator = this.policyProperties.getResourceComparator(serviceName);
        String rootResource = "";
        if (resource != null && resource.length() != 0 && (index = resource.indexOf(rootResource = (resources = resourceComparator.split(resource))[0])) > 0) {
            rootResource = resource.substring(0, index) + rootResource;
        }
        return rootResource;
    }

    Set getAdvicesHandleableByAM(SSOToken appToken, boolean refetchFromServer) throws InvalidAppSSOTokenException, PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getAdvicesHandleableByAM()::entering");
        }
        if (this.advicesHandleableByAM != null && !refetchFromServer) {
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getAdvicesHandleableByAM()::returning cached advices" + this.advicesHandleableByAM);
            }
            return this.advicesHandleableByAM;
        }
        URL policyServiceURL = null;
        if (appToken != null) {
            try {
                policyServiceURL = ResourceResultCache.getPolicyServiceURL(appToken);
            }
            catch (PolicyException pe) {
                debug.error("ResourceResultCache.getAdvicesHandleableByAM():", pe);
                throw pe;
            }
        }
        if (appToken != null && policyServiceURL != null) {
            PolicyRequest policyReq = new PolicyRequest();
            policyReq.setAppSSOToken(((Object)appToken.getTokenID()).toString());
            policyReq.setAdvicesHandleableByAMRequest(new AdvicesHandleableByAMRequest());
            policyReq.setMethodID(4);
            try {
                PolicyService ps = ResourceResultCache.sendPLLRequest(policyServiceURL, policyReq);
                if (ps != null) {
                    PolicyResponse psres;
                    String exceptionMessage;
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.getAdvicesHandleableByAM():result=" + ps.toXMLString());
                    }
                    if ((exceptionMessage = (psres = ps.getPolicyResponse()).getExceptionMsg()) != null) {
                        if (exceptionMessage.indexOf(ResBundleUtils.getString("app_sso_token_invalid")) >= 0) {
                            if (debug.warningEnabled()) {
                                debug.warning("ResourceResultCache.getAdvicesHandleableByAM(): response exception " + exceptionMessage);
                                debug.warning("ResourceResultCache.AdvicesHandleableByAM(): appSSOToken is invalid");
                                debug.warning("ResourceResultCache.throwing InvalidAppSSOTokenException");
                            }
                            Object[] args = new String[]{exceptionMessage};
                            throw new InvalidAppSSOTokenException("amPolicy", "server_reported_invalid_app_sso_token", args, null);
                        }
                        if (debug.warningEnabled()) {
                            debug.warning("ResourceResultCache.AdvicesHandleableByAM():response exception message=" + exceptionMessage);
                        }
                        Object[] args = new String[]{exceptionMessage};
                        throw new PolicyEvaluationException("amPolicy", "server_reported_exception", args, null);
                    }
                    if (psres.getMethodID() == 5) {
                        AdvicesHandleableByAMResponse advicesHandleableByAMResponse = psres.getAdvicesHandleableByAMResponse();
                        if (debug.messageEnabled()) {
                            debug.message("ResourceResultCache.getAdvicesHandleableByAM():" + advicesHandleableByAMResponse);
                        }
                        if (advicesHandleableByAMResponse != null) {
                            this.advicesHandleableByAM = advicesHandleableByAMResponse.getAdvicesHandleableByAM();
                        }
                    }
                } else {
                    debug.error("ResourceResultCache.getAdvicesHandleableByAM():no result");
                }
            }
            catch (SendRequestException e) {
                debug.error("ResourceResultCache.getAdvicesHandleableByAM():", e);
                throw new PolicyException(e);
            }
        }
        if (this.advicesHandleableByAM == null) {
            this.advicesHandleableByAM = Collections.EMPTY_SET;
        }
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getAdvicesHandleableByAM()::returning advicesHandleableByAM" + this.advicesHandleableByAM);
        }
        return this.advicesHandleableByAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCachedDecisionsForService(String serviceName) {
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.clearCachedDecisionsForService():serviceName=" + serviceName);
        }
        Map map = this.resultCache;
        synchronized (map) {
            this.resultCache.remove(serviceName);
        }
    }

    public static PolicyService sendPLLRequest(URL policyServiceUrl, PolicyRequest preq) throws SendRequestException, PolicyException {
        String lbcookie = null;
        try {
            lbcookie = ResourceResultCache.getLBCookie(preq);
        }
        catch (Exception e) {
            throw new SendRequestException(e);
        }
        PolicyService policyService = new PolicyService();
        policyService.setMethodID(1);
        policyService.setPolicyRequest(preq);
        String xmlString = policyService.toXMLString();
        Request request = new Request(xmlString);
        RequestSet requestSet = new RequestSet(POLICY_SERVICE_ID_FOR_NAMING);
        requestSet.addRequest(request);
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.sendPLLRequest:sending PLL request to URL=" + policyServiceUrl + ":\nPLL message=" + xmlString);
        }
        Vector responses = PLLClient.send(policyServiceUrl, lbcookie, requestSet);
        Response response = (Response)responses.elementAt(0);
        PolicyService ps = PolicyService.parseXML(response.getContent());
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.sendPLLRequest:result=" + ps.toXMLString());
        }
        return ps;
    }

    public static String getLBCookie(PolicyRequest preq) throws Exception {
        String lbcookie = null;
        ResourceResultRequest rrReq = preq.getResourceResultRequest();
        lbcookie = rrReq != null ? Session.getLBCookie(rrReq.getUserSSOToken()) : Session.getLBCookie(preq.getAppSSOToken());
        return lbcookie;
    }

    private boolean resourceResultsHasAdvices(Set resourceResults) {
        boolean hasAdvices = false;
        if (resourceResults != null) {
            Iterator rrIter = resourceResults.iterator();
            while (rrIter.hasNext()) {
                ResourceResult rr = (ResourceResult)rrIter.next();
                if (!rr.hasAdvices()) continue;
                hasAdvices = true;
                break;
            }
        }
        return hasAdvices;
    }

    static {
        debug = PolicyEvaluator.debug;
        requestID = 0L;
        REQUEST_ID_LOCK = "REQUEST_ID_LOCK";
        SECRET_MASK = "*********";
    }
}

