/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.ObjectInUseException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SharedSubject;
import com.sun.identity.policy.Subjects;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.PluginSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import netscape.ldap.util.DN;

public class SubjectTypeManager {
    private static String SUBJECT = "Subject";
    private SSOToken token;
    private PolicyManager pm;
    private ResourceBundle rb;
    private Subjects realmSubjects = null;
    private Map sharedSubjects = Collections.synchronizedMap(new HashMap());
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private String pmRealmName;
    static Debug debug = PolicyManager.debug;

    protected SubjectTypeManager() throws SSOException {
        this.token = ServiceTypeManager.getSSOToken();
        String lstr = this.token.getProperty("Locale");
        java.util.Locale loc = Locale.getLocale(lstr);
        this.rb = amCache.getResBundle("amPolicy", loc);
    }

    protected SubjectTypeManager(PolicyManager pm) {
        java.util.Locale loc;
        this.pm = pm;
        this.pmRealmName = new DN(pm.getOrganizationDN()).toRFCString().toLowerCase();
        this.token = pm.token;
        try {
            String lstr = this.token.getProperty("Locale");
            loc = Locale.getLocale(lstr);
        }
        catch (SSOException ex) {
            debug.error("SubjectTypeManager:Unable to retreive locale from SSOToken", ex);
            loc = Locale.getDefaultLocale();
        }
        if (debug.messageEnabled()) {
            debug.message("SubjectManager locale=" + loc + "\tI18nFileName = " + "amPolicy");
        }
        this.rb = amCache.getResBundle("amPolicy", loc);
    }

    public Set getSubjectTypeNames() throws SSOException, PolicyException {
        return PolicyManager.getPluginSchemaNames(SUBJECT);
    }

    public Set getSelectedSubjectTypeNames() throws SSOException, PolicyException {
        Map policyConfig = this.pm.getPolicyConfig();
        Set selectedSubjects = null;
        if (policyConfig != null) {
            selectedSubjects = (Set)policyConfig.get("iplanet-am-policy-selected-subjects");
        }
        if (selectedSubjects == null) {
            selectedSubjects = Collections.EMPTY_SET;
        }
        return selectedSubjects;
    }

    public String getSubjectTypeName(Subject subject) {
        return SubjectTypeManager.subjectTypeName(subject);
    }

    protected String getI18NPropertiesFileName(String subjectType) {
        return null;
    }

    public String getI18NKey(String subjectType) {
        PluginSchema ps = PolicyManager.getPluginSchema(SUBJECT, subjectType);
        if (ps != null) {
            return ps.getI18NKey();
        }
        return null;
    }

    public String getDisplayName(String subjectType) {
        String displayName = null;
        String i18nKey = this.getI18NKey(subjectType);
        displayName = i18nKey == null || i18nKey.length() == 0 ? subjectType : Locale.getString(this.rb, i18nKey, debug);
        return displayName;
    }

    public Subject getSubject(String subjectType) throws NameNotFoundException, PolicyException {
        PluginSchema ps = PolicyManager.getPluginSchema(SUBJECT, subjectType);
        if (ps == null) {
            throw new NameNotFoundException("amPolicy", "invalid_subject", null, subjectType, 5);
        }
        Subject answer = null;
        try {
            String className = ps.getClassName();
            answer = (Subject)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
        answer.initialize(this.pm.getPolicyConfig());
        return answer;
    }

    public void addSubject(String subjectName, Subject subject) throws NameAlreadyExistsException, InvalidNameException, PolicyException, SSOException {
        this.addSubject(subjectName, subject, false);
    }

    private void addSubject(String subjectName, Subject subject, boolean exclusive) throws NameAlreadyExistsException, InvalidNameException, PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("Adding realm subject : " + subjectName + ", in realm:" + this.pmRealmName);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        this.realmSubjects.addSubject(subjectName, subject, exclusive);
        this.saveSubjects();
        if (debug.messageEnabled()) {
            debug.message("Added realm subject : " + subjectName + ", in realm:" + this.pmRealmName);
        }
    }

    public Subject removeSubject(String subjectName) throws ObjectInUseException, PolicyException, SSOException {
        return this.removeSubject(subjectName, false);
    }

    public Subject removeSubject(String subjectName, boolean forcedRemove) throws ObjectInUseException, PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("Removing realm subject : " + subjectName + ", in realm:" + this.pmRealmName);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        if (forcedRemove) {
            Set userPolicies = this.pm.getPoliciesUsingRealmSubject(subjectName);
            Iterator policyIter = userPolicies.iterator();
            while (policyIter.hasNext()) {
                Policy policy = (Policy)policyIter.next();
                policy.removeSubject(subjectName);
            }
        } else {
            Policy p = this.pm.getPolicyUsingRealmSubject(subjectName);
            if (p != null) {
                throw new ObjectInUseException(null, null, null, null, null);
            }
        }
        Subject subject = this.realmSubjects.removeSubject(subjectName);
        this.saveSubjects();
        if (debug.messageEnabled()) {
            debug.message("Removed realm subject : " + subjectName + ", in realm:" + this.pmRealmName);
        }
        return subject;
    }

    public void replaceSubject(String subjectName, Subject subject) throws NameNotFoundException, PolicyException, SSOException {
        this.replaceSubject(subjectName, subject, false);
    }

    private void replaceSubject(String subjectName, Subject subject, boolean exclusive) throws NameNotFoundException, PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("Replacing realm subject : " + subjectName + ", in realm:" + this.pmRealmName);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        this.realmSubjects.replaceSubject(subjectName, subject, exclusive);
        this.saveSubjects();
        if (debug.messageEnabled()) {
            debug.message("Replaced realm subject : " + subjectName + ", in realm:" + this.pmRealmName);
        }
    }

    public Set getSubjectNames() throws PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("Getting subject names from realm: " + this.pmRealmName);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        Set subjectNames = this.realmSubjects.getSubjectNames();
        if (debug.messageEnabled()) {
            debug.message("Returning subject names from realm: " + this.pmRealmName + ",subjectNames=" + subjectNames);
        }
        return subjectNames;
    }

    public Subject getSubjectByName(String subjectName) throws NameNotFoundException, PolicyException {
        if (debug.messageEnabled()) {
            debug.message("Getting subject by name from realm: " + this.pmRealmName + ", subjectName=" + subjectName);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        if (debug.messageEnabled()) {
            debug.message("Returning subject by name from realm: " + this.pmRealmName + ", subjectName=" + subjectName);
        }
        return (Subject)this.realmSubjects.getSubject(subjectName).clone();
    }

    synchronized Subject getCachedSubjectByName(String subjectName) throws PolicyException {
        if (debug.messageEnabled()) {
            debug.message("Getting cached subject by name from realm: " + this.pmRealmName + ", subjectName=" + subjectName);
        }
        if (this.realmSubjects == null) {
            this.initRealmSubjects();
        }
        if (debug.messageEnabled()) {
            debug.message("Returning cached subject by name from realm: " + this.pmRealmName + ", subjectName=" + subjectName);
        }
        return this.realmSubjects.fetchSubject(subjectName);
    }

    Subject getSharedSubject(String subjectName) throws PolicyException {
        Subject subject;
        if (debug.messageEnabled()) {
            debug.message("Getting shared subject from realm: " + this.pmRealmName + ", subjectName=" + subjectName);
        }
        if ((subject = (Subject)this.sharedSubjects.get(subjectName)) == null) {
            subject = new SharedSubject(subjectName, this);
            this.sharedSubjects.put(subjectName, subject);
        }
        if (debug.messageEnabled()) {
            debug.message("Returning shared subject from realm: " + this.pmRealmName + ", subjectName=" + subjectName);
        }
        return subject;
    }

    static String subjectTypeName(Subject subject) {
        if (subject == null) {
            return null;
        }
        String answer = null;
        String className = subject.getClass().getName();
        Iterator items = PolicyManager.getPluginSchemaNames(SUBJECT).iterator();
        while (items.hasNext()) {
            String pluginName = (String)items.next();
            PluginSchema ps = PolicyManager.getPluginSchema(SUBJECT, pluginName);
            if (!className.equals(ps.getClassName())) continue;
            answer = pluginName;
            break;
        }
        return answer;
    }

    public String getViewBeanURL(Subject subject) {
        return PolicyManager.getViewBeanURL(SUBJECT, subject.getClass().getName());
    }

    PolicyManager getPolicyManager() {
        return this.pm;
    }

    private void saveSubjects() throws PolicyException, SSOException {
        if (this.realmSubjects != null) {
            this.pm.saveRealmSubjects(this.realmSubjects);
        }
    }

    private void initRealmSubjects() throws PolicyException {
        if (debug.messageEnabled()) {
            debug.message("Initializing realm subjects in realm : " + this.pmRealmName);
        }
        try {
            this.realmSubjects = this.pm.readRealmSubjects();
        }
        catch (SSOException ssoe) {
            throw new PolicyException("amPolicy", "could_not_initialize_realm_subjects", null, ssoe);
        }
        if (debug.messageEnabled()) {
            debug.message("Initialized realm subjects in realm : " + this.pmRealmName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetRealmSubjects() {
        if (debug.messageEnabled()) {
            debug.message("Resetting realm subjects in realm : " + this.pmRealmName);
        }
        SubjectTypeManager subjectTypeManager = this;
        synchronized (subjectTypeManager) {
            this.realmSubjects = null;
        }
        if (debug.messageEnabled()) {
            debug.message("Reset realm subjects in realm : " + this.pmRealmName);
        }
    }
}

