/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class ResourceResult {
    public static final String SUBTREE_SCOPE = "subtree";
    public static final String STRICT_SUBTREE_SCOPE = "strict-subtree";
    public static final String SELF_SCOPE = "self";
    static final String VIRTUAL_ROOT = "-__viRTuAl-rOot--_";
    static final String RESOURCE_RESULT = "ResourceResult";
    static final String RESOURCE_NAME = "name";
    static final String POLICY_DEBUG_NAME = "amPolicy";
    static final Debug DEBUG = Debug.getInstance("amPolicy");
    private String resourceName = null;
    private PolicyDecision policyDecision = null;
    private Set resourceResults = new HashSet();
    private long timeToLive = Long.MAX_VALUE;
    private boolean advicesAreSet = false;
    private String stringForm = null;
    private String xmlForm = null;
    private Map envMap = null;
    private boolean stale = false;

    ResourceResult() {
    }

    public ResourceResult(String resourceName, PolicyDecision policyDecision) {
        this.resourceName = resourceName;
        this.setPolicyDecision(policyDecision);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    void setResourceName(String resourceName) {
        this.resourceName = resourceName;
        this.stringForm = null;
        this.xmlForm = null;
    }

    public PolicyDecision getPolicyDecision() {
        return this.policyDecision;
    }

    public void setPolicyDecision(PolicyDecision policyDecision) {
        this.policyDecision = policyDecision;
        long pdTtl = policyDecision.getTimeToLive();
        if (pdTtl < this.timeToLive) {
            this.timeToLive = pdTtl;
        }
        this.advicesAreSet = this.advicesAreSet || policyDecision.hasAdvices();
        this.stringForm = null;
        this.xmlForm = null;
    }

    public Set getResourceResults() {
        return this.resourceResults;
    }

    void setResourceResults(Set resourceResults) {
        if (resourceResults == null) {
            this.resourceResults.clear();
        } else {
            this.resourceResults = resourceResults;
            if (this.policyDecision != null) {
                this.timeToLive = this.policyDecision.getTimeToLive();
            }
            Iterator iter = resourceResults.iterator();
            while (iter.hasNext()) {
                ResourceResult rr = (ResourceResult)iter.next();
                long ttl = rr.getTimeToLive();
                if (ttl < this.timeToLive) {
                    this.timeToLive = ttl;
                }
                this.advicesAreSet = this.advicesAreSet || rr.hasAdvices();
            }
        }
        this.stringForm = null;
        this.xmlForm = null;
    }

    public static ResourceResult parseResourceResult(Node resourceResultNode) throws PolicyException {
        ResourceResult resourceResult = new ResourceResult();
        String resourceName = XMLUtils.getNodeAttributeValue(resourceResultNode, RESOURCE_NAME);
        if (resourceName == null) {
            DEBUG.error("ResourceResult: missing attribute name");
            Object[] objs = new Object[]{RESOURCE_NAME};
            throw new PolicyException(POLICY_DEBUG_NAME, "missing_attribute_in_resourceresult", objs, null);
        }
        resourceResult.setResourceName(resourceName);
        Node node = XMLUtils.getChildNode(resourceResultNode, "PolicyDecision");
        if (node == null) {
            DEBUG.error("ResourceResult: missing element PolicyDecision");
            Object[] objs = new Object[]{"PolicyDecision"};
            throw new PolicyException(POLICY_DEBUG_NAME, "missing_attribute_in_resourceresult", objs, null);
        }
        resourceResult.setPolicyDecision(PolicyDecision.parsePolicyDecision(node));
        Set nodeSet = XMLUtils.getChildNodes(resourceResultNode, RESOURCE_RESULT);
        if (nodeSet != null) {
            Iterator nodes = nodeSet.iterator();
            while (nodes.hasNext()) {
                node = (Node)nodes.next();
                ResourceResult rRes = ResourceResult.parseResourceResult(node);
                resourceResult.resourceResults.add(rRes);
            }
        }
        return resourceResult;
    }

    public String toString() {
        if (this.stringForm == null) {
            StringBuffer sb = new StringBuffer(200);
            sb.append("Resource Result for resourceName : ").append(this.resourceName).append("\r\n").append("PolicyDecision : ").append(this.policyDecision).append("Nested ResourceResults : ").append(this.resourceResults);
            this.stringForm = sb.toString();
        }
        return this.stringForm;
    }

    public String toXML() {
        if (this.xmlForm == null) {
            StringBuffer xmlsb = new StringBuffer(1000);
            xmlsb.append("<").append(RESOURCE_RESULT).append(" ").append(RESOURCE_NAME).append("=\"").append(XMLUtils.escapeSpecialCharacters(this.resourceName)).append("\">").append("\r\n");
            if (this.policyDecision != null) {
                xmlsb.append(this.policyDecision.toXML());
            }
            Iterator rrIter = this.resourceResults.iterator();
            while (rrIter.hasNext()) {
                ResourceResult rr = (ResourceResult)rrIter.next();
                xmlsb.append(rr.toXML());
            }
            xmlsb.append("</").append(RESOURCE_RESULT).append(">").append("\r\n");
            this.xmlForm = xmlsb.toString();
        }
        return this.xmlForm;
    }

    public void addResourceResult(ResourceResult resourceResult, ServiceType serviceType) throws PolicyException {
        this.addResourceResult(resourceResult, serviceType.getResourceNameComparator());
    }

    public void addResourceResult(ResourceResult resourceResult, ResourceName resourceComparator) throws PolicyException {
        long rrTtl;
        if (!this.isSuperResourceResultOf(resourceResult, resourceComparator)) {
            Object[] objs = new String[]{this.resourceName, resourceResult.resourceName};
            throw new PolicyException(POLICY_DEBUG_NAME, "invalid_sub_resourceresult", objs, null);
        }
        Iterator resourceResultIter = this.resourceResults.iterator();
        boolean directChild = true;
        while (resourceResultIter.hasNext()) {
            ResourceResult rResult = (ResourceResult)resourceResultIter.next();
            if (!rResult.isSuperResourceResultOf(resourceResult, resourceComparator)) continue;
            rResult.addResourceResult(resourceResult, resourceComparator);
            directChild = false;
            break;
        }
        if (directChild) {
            HashSet<ResourceResult> childrenToBeMoved = new HashSet<ResourceResult>();
            Iterator rrIter = this.resourceResults.iterator();
            while (rrIter.hasNext()) {
                ResourceResult rResult = (ResourceResult)rrIter.next();
                if (!resourceResult.isSuperResourceResultOf(rResult, resourceComparator)) continue;
                childrenToBeMoved.add(rResult);
            }
            this.resourceResults.removeAll(childrenToBeMoved);
            resourceResult.resourceResults.addAll(childrenToBeMoved);
            this.resourceResults.add(resourceResult);
        }
        if ((rrTtl = resourceResult.getTimeToLive()) < this.timeToLive) {
            this.timeToLive = rrTtl;
        }
        this.advicesAreSet = this.advicesAreSet || resourceResult.hasAdvices();
        this.stringForm = null;
        this.xmlForm = null;
    }

    public void markStale() {
        this.stale = true;
    }

    public boolean isStale() {
        return this.stale;
    }

    private boolean isSuperResourceResultOf(ResourceResult resourceResult, ResourceName resourceComparator) throws PolicyException {
        boolean isSuperResource = false;
        if (VIRTUAL_ROOT.equals(this.resourceName)) {
            isSuperResource = true;
        } else if (resourceComparator != null) {
            boolean interpretWildCard = false;
            ResourceMatch resourceMatch = resourceComparator.compare(this.resourceName, resourceResult.resourceName, interpretWildCard);
            if (resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH)) {
                isSuperResource = true;
            }
        } else {
            isSuperResource = resourceResult.resourceName.startsWith(this.resourceName);
        }
        return isSuperResource;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean hasAdvices() {
        return this.advicesAreSet;
    }

    void setEnvMap(Map envMap) {
        this.envMap = envMap;
    }

    Map getEnvMap() {
        return this.envMap;
    }
}

