/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.ReaderWriterLock;
import com.sun.identity.log.AMLogException;
import com.sun.identity.log.LogConstants;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Authorizer;
import com.sun.identity.log.spi.Debug;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;

public class Logger
extends java.util.logging.Logger {
    private String currentFileName = new String();
    private static LogManager lm;
    private String logName;
    protected static boolean resolveHostName;
    public static ReaderWriterLock rwLock;

    protected Logger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    private static void processNewLoggerObject(Logger result) {
        Formatter formatter = null;
        String handlerClass = LogManager.HANDLER;
        String formatterClass = LogManager.FORMATTER;
        String levelProp = "iplanet-am-logging." + result.logName + ".level";
        String levelString = lm.getProperty(levelProp);
        if (!(levelString != null && levelString.length() > 0 || (levelString = SystemProperties.get(levelProp)) != null && levelString.length() > 0 || (levelString = lm.getProperty("sun-am-log-level")) != null && levelString.length() > 0)) {
            levelString = "INFO";
        }
        Level logLevel = null;
        try {
            logLevel = Level.parse(levelString);
        }
        catch (IllegalArgumentException iaex) {
            logLevel = LogConstants.DEFAULT_LOGGING_LEVEL;
        }
        result.setLevel(logLevel);
        String logStatus = lm.getProperty("logstatus");
        if (logStatus != null && logStatus.startsWith("INACTIVE")) {
            logLevel = Level.OFF;
        }
        result.setLevel(logLevel);
        Class<?> clz = null;
        Class[] parameters = new Class[]{String.class};
        Object[] parameterObjects = new Object[]{new String(result.logName)};
        Constructor<?> cons = null;
        Handler handler = null;
        if (handlerClass == null) {
            Debug.error("Logger:processNewLoggerObject:HandlerClass not in classpath ");
            return;
        }
        try {
            clz = Class.forName(handlerClass);
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:HandlerClass not in classpath: " + handlerClass, e);
            return;
        }
        try {
            if (clz != null) {
                cons = clz.getDeclaredConstructor(parameters);
            }
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:constructor parameter mismatch ", e);
            return;
        }
        try {
            if (cons != null) {
                handler = (Handler)cons.newInstance(parameterObjects);
            }
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:Could not instantiate handler: " + handlerClass, e);
            return;
        }
        if (formatterClass == null) {
            Debug.error("Logger:processNewLoggerObject:formatterClass not in classpath ");
            return;
        }
        try {
            clz = Thread.currentThread().getContextClassLoader().loadClass(formatterClass);
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:Could not load Formatter Class: " + formatterClass, e);
            return;
        }
        try {
            if (clz != null) {
                formatter = (Formatter)clz.newInstance();
            }
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:Could not get Formatter instance " + formatterClass, e);
            return;
        }
        try {
            handler.setFormatter(formatter);
            result.addHandler(handler);
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:Unable to add Handler", e);
            return;
        }
        String filterClassName = lm.getProperty("iplanet-am-logging-filter-class-name");
        try {
            if (filterClassName != null) {
                Filter filter = (Filter)Class.forName(filterClassName).newInstance();
                result.setFilter(filter);
            }
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:Could not set Filter: " + filterClassName, e);
        }
        result.setUseParentHandlers(false);
        resolveHostName = Boolean.valueOf(lm.getProperty("resolveHostName"));
    }

    public void log(java.util.logging.LogRecord record) {
        this.log(record, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(java.util.logging.LogRecord record, Object cred) {
        block18: {
            String existModuleName;
            String logName = this.getName();
            if (!LogManager.isLocal) {
                if (cred == null) {
                    Debug.error("Logger:log:" + logName + ": remote logging, ssoToken is null; Will not log");
                    return;
                }
            } else if (!Authorizer.isAuthorized((String)logName, (String)"MODIFY", (Object)cred)) {
                Debug.error("Logger:log:" + logName + ": authorization failed; Will not log");
                throw new AMLogException(logName + ":" + "Log write authorization failure");
            }
            SSOToken ssoToken = null;
            LogRecord ourRecord = (LogRecord)record;
            if (cred instanceof SSOToken) {
                ssoToken = (SSOToken)cred;
                String loggedBySID = ((Object)ssoToken.getTokenID()).toString();
                ourRecord.addLogInfo("LoggedBySid", loggedBySID);
                String clientID = null;
                try {
                    clientID = ssoToken.getPrincipal().getName();
                }
                catch (SSOException ssoe) {
                    Debug.error("Logger:log:" + logName + ": could not get clientID from ssoToken:", ssoe);
                }
                ourRecord.addLogInfo("LoggedBy", clientID);
            }
            if ((existModuleName = (String)ourRecord.getLogInfoMap().get("ModuleName")) == null || existModuleName.length() <= 0) {
                ourRecord.addLogInfo("ModuleName", this.getName());
            }
            ourRecord.setLoggerName(this.getName());
            String rbName = this.getResourceBundleName();
            ResourceBundle bundle = null;
            if (rbName != null) {
                bundle = ResourceBundle.getBundle(rbName);
                ourRecord.setResourceBundle(bundle);
            }
            try {
                rwLock.readRequest();
                if (lm.isSecure()) {
                    Logger logger = this;
                    synchronized (logger) {
                        super.log(ourRecord);
                        break block18;
                    }
                }
                super.log(ourRecord);
            }
            catch (Exception ex) {
                Debug.error("Logger.log:" + logName + ":" + ex.getMessage());
                throw new AMLogException(logName + ":" + ex.getMessage());
            }
            finally {
                rwLock.readDone();
            }
        }
    }

    public void flush() {
        Logger logger = this;
        Handler[] targets = logger.getHandlers();
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                targets[i].flush();
            }
        }
    }

    public static synchronized java.util.logging.Logger getLogger(String name) {
        if (name == null || name.length() == 0 || name.indexOf("..") >= 0) {
            return null;
        }
        boolean loggerExists = false;
        Enumeration<String> e = lm.getLoggerNames();
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(name)) continue;
            loggerExists = true;
        }
        if (loggerExists) {
            Logger result = (Logger)lm.getLogger(name);
            return result;
        }
        java.util.logging.Logger newLog = java.util.logging.Logger.getLogger(name);
        lm.addLogger(newLog);
        Logger result = (Logger)lm.getLogger(name);
        result.logName = name;
        Logger.processNewLoggerObject(result);
        return result;
    }

    public static synchronized java.util.logging.Logger getLogger(String name, String rbName) {
        if (name == null || name.length() == 0 || name.indexOf("..") >= 0) {
            return null;
        }
        boolean loggerExists = false;
        Enumeration<String> e = lm.getLoggerNames();
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(name)) continue;
            loggerExists = true;
        }
        Logger result = (Logger)java.util.logging.Logger.getLogger(name, rbName);
        result.logName = name;
        if (loggerExists) {
            return result;
        }
        Logger.processNewLoggerObject(result);
        return result;
    }

    public String getCurrentFile() {
        return this.currentFileName;
    }

    public void setCurrentFile(String fileName) {
        this.currentFileName = fileName;
    }

    public static boolean resolveHostNameEnabled() {
        return resolveHostName;
    }

    static {
        File dir;
        rwLock = new ReaderWriterLock();
        lm = (LogManager)LogManagerUtil.getLogManager();
        try {
            lm.readConfiguration();
        }
        catch (Exception ex) {
            // empty catch block
        }
        String location = lm.getProperty("iplanet-am-logging-location");
        String type = lm.getProperty("iplanet-am-logging-type");
        if (location != null && type.equals("File") && !(dir = new File(location)).exists() && !dir.mkdirs()) {
            Debug.error("Logger:Creation of Log Directory failed: " + location);
        }
        resolveHostName = Boolean.valueOf(lm.getProperty("resolveHostName"));
    }
}

