/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SessionSubject
extends FSSubject {
    public SessionSubject(NameIdentifier nameIdentifier, SubjectConfirmation subjectConfirmation, IDPProvidedNameIdentifier idpNameIdentifier) throws FSMsgException, SAMLException {
        super(nameIdentifier, subjectConfirmation, idpNameIdentifier);
    }

    public SessionSubject(NameIdentifier nameIdentifier, IDPProvidedNameIdentifier idpNameIdentifier) throws FSMsgException, SAMLException {
        super(nameIdentifier, idpNameIdentifier);
    }

    public SessionSubject(Element subjectElement) throws FSMsgException, SAMLException {
        SecurityTokenManager.debug.message("SessionSubject(Element): Called");
        int elementCount = 0;
        Element elt = subjectElement;
        String rootTagName = elt.getLocalName();
        String rootTagNS = elt.getNamespaceURI();
        if (rootTagName == null) {
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: local name missing");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!rootTagName.equals("SessionSubject")) {
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: invalid root element");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("invalidElement"));
        }
        NodeList nl = subjectElement.getChildNodes();
        int length = nl.getLength();
        if (length == 0) {
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: No sub elements found");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("emptyElement"));
        }
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("NameIdentifier")) {
                this.setNameIdentifier(new NameIdentifier((Element)child));
                ++elementCount;
                continue;
            }
            if (childName.equals("SubjectConfirmation")) {
                super.setSubjectConfirmation(new SubjectConfirmation((Element)child));
                ++elementCount;
                continue;
            }
            if (childName.equals("IDPProvidedNameIdentifier")) {
                this._idpNameIdentifier = new IDPProvidedNameIdentifier((Element)child);
                ++elementCount;
                continue;
            }
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: Invalid element encountered.");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("invalidElement"));
        }
        if (elementCount > 3) {
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: more than allowed elements passed");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("moreElement"));
        }
        if (this._idpNameIdentifier == null) {
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: mandatory IDPProvidedNameIdentifier missing");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("missingElement"));
        }
        SecurityTokenManager.debug.message("SessionSubject(Element): leaving");
    }

    public SessionSubject(SubjectConfirmation subjectConfirmation) throws SAMLException {
        super(subjectConfirmation);
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        StringBuffer xml = new StringBuffer(3000);
        String libprefix = "";
        String secprefix = "";
        String liburi = "";
        String secNS = "";
        String secNSString = "";
        if (includeNS) {
            libprefix = "lib:";
            secprefix = "sec:";
        }
        if (declareNS) {
            liburi = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            secNS = "urn:liberty:sec:2003-08";
            secNSString = " xmlns:sec=\"" + secNS + "\"";
        }
        xml.append("<").append(secprefix).append("SessionSubject").append(secNSString).append(">");
        if (this.getNameIdentifier() != null) {
            xml.append(this.getNameIdentifier().toString(includeNS, declareNS));
        }
        if (this.getSubjectConfirmation() != null) {
            xml.append(this.getSubjectConfirmation().toString(includeNS, declareNS));
        }
        if (this._idpNameIdentifier != null) {
            xml.append(this._idpNameIdentifier.toXMLString(includeNS, declareNS));
        }
        xml.append("</").append(secprefix).append("SessionSubject").append(">");
        return xml.toString();
    }
}

