/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.security.ProxySubject;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceAccessStatement
extends SubjectStatement {
    public static final int RESOURCEACCESS_STATEMENT = 4;
    private ResourceID _resourceID = null;
    private EncryptedResourceID _encryptedResourceID = null;
    protected ProxySubject _proxySubject = null;
    protected SessionContext _sessionContext = null;

    public ResourceAccessStatement(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("ResourceAccessStatement: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean valid = SAMLUtils.checkStatement(element, "ResourceAccessStatement");
        if (!valid) {
            SAMLUtils.debug.message("ResourceAccessStatement: Wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (int i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String tagName = currentNode.getLocalName();
                String tagNS = currentNode.getNamespaceURI();
                if (tagName == null || tagName.length() == 0 || tagNS == null || tagNS.length() == 0) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("ResourceAccessStatement:The tag name or tag namespace of child element is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                }
                if (tagName.equals("Subject") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    if (this._subject != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("ResourceAccessStatement:should only contain one subject");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    this._subject = new Subject((Element)currentNode);
                    continue;
                }
                if (tagName.equals("ResourceID") && tagNS.equals("urn:liberty:disco:2003-08")) {
                    if (this._resourceID != null || this._encryptedResourceID != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("ResourceAccessStatement: should at most contain one ResourceIDGroup.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    try {
                        this._resourceID = new ResourceID((Element)currentNode);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new SAMLRequesterException(ex.getMessage());
                    }
                }
                if (tagName.equals("EncryptedResourceID") && tagNS.equals("urn:liberty:disco:2003-08")) {
                    if (this._resourceID != null || this._encryptedResourceID != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("ResourceAccessStatement: should at most contain one ResourceIDGroup.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    try {
                        this._encryptedResourceID = new EncryptedResourceID((Element)currentNode);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new SAMLRequesterException(ex.getMessage());
                    }
                }
                if (tagName.equals("ProxySubject") && tagNS.equals("urn:liberty:sec:2003-08")) {
                    if (this._proxySubject != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("ResourceAccessStatement: should at most contain one ProxySubject.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    this._proxySubject = new ProxySubject((Element)currentNode);
                    continue;
                }
                if (tagName.equals("SessionContext") && tagNS.equals("urn:liberty:sec:2003-08")) {
                    if (this._sessionContext != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("ResourceAccessStatement: should at most contain one SessionContext.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    this._sessionContext = new SessionContext((Element)currentNode);
                    continue;
                }
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("ResourceAccessStatement:Wrong element " + tagName + "included.");
                }
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
            }
        }
        if (this._subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public ResourceAccessStatement(String resourceID, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = new ResourceID(resourceID);
    }

    public ResourceAccessStatement(String resourceID, ProxySubject proxySubject, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = new ResourceID(resourceID);
        this._proxySubject = proxySubject;
    }

    public ResourceAccessStatement(String resourceID, ProxySubject proxySubject, SessionContext sessionContext, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = new ResourceID(resourceID);
        this._proxySubject = proxySubject;
        this._sessionContext = sessionContext;
    }

    public ResourceAccessStatement(ResourceID resourceID, ProxySubject proxySubject, SessionContext sessionContext, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = resourceID;
        this._proxySubject = proxySubject;
        this._sessionContext = sessionContext;
    }

    public ResourceAccessStatement(EncryptedResourceID encryptedResourceID, ProxySubject proxySubject, SessionContext sessionContext, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._encryptedResourceID = encryptedResourceID;
        this._proxySubject = proxySubject;
        this._sessionContext = sessionContext;
    }

    public String getResourceID() {
        return this._resourceID == null ? null : this._resourceID.getResourceID();
    }

    public ResourceID getResourceIDObject() {
        return this._resourceID;
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this._encryptedResourceID;
    }

    public boolean setResourceID(String resourceID) {
        if (resourceID == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: setResourceID:Input is null.");
            }
            return false;
        }
        this._resourceID = new ResourceID(resourceID);
        return true;
    }

    public void setResourceID(ResourceID resourceID) {
        this._resourceID = resourceID;
    }

    public void setEncryptedResourceID(EncryptedResourceID resourceID) {
        this._encryptedResourceID = resourceID;
    }

    public int getStatementType() {
        return 4;
    }

    public boolean setSessionContext(SessionContext sessionContext) {
        if (sessionContext == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: setSessionContext: Input is null.");
            }
            return false;
        }
        this._sessionContext = sessionContext;
        return true;
    }

    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    public ProxySubject getProxySubject() {
        return this._proxySubject;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer result = new StringBuffer(1000);
        result.append("<").append("sec:").append("ResourceAccessStatement").append(" ").append("xmlns:sec").append("=").append("\"").append("urn:liberty:sec:2003-08").append("\"");
        result.append(">\n").append(this._subject.toString(includeNS, true));
        if (this._resourceID != null) {
            result.append(this._resourceID);
        } else if (this._encryptedResourceID != null) {
            result.append(this._encryptedResourceID);
        }
        if (this._proxySubject != null) {
            result.append(this._proxySubject.toString(includeNS, true));
            if (this._sessionContext != null) {
                try {
                    result.append(this._sessionContext.toXMLString(includeNS, true));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        result.append("</").append("sec:").append("ResourceAccessStatement").append(">\n");
        return result.toString();
    }
}

