/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Element;

public class ResourceID {
    private String resourceID = null;
    private String id = null;

    public ResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public ResourceID(Element elem) throws DiscoveryException {
        if (elem == null) {
            DiscoUtils.debug.message("ResourceID(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        String nameSpaceURI = null;
        tag = elem.getLocalName();
        if (tag == null || !tag.equals("ResourceID") || (nameSpaceURI = elem.getNamespaceURI()) == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("ResourceID(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.id = elem.getAttribute("id");
        this.resourceID = XMLUtils.getElementValue(elem);
        if (this.resourceID == null || this.resourceID.length() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ResourceID(Element): missing ResourceID element value.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingResourceIDValue"));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(300);
        sb.append("<ResourceID xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.resourceID != null) {
            sb.append(this.resourceID);
        }
        sb.append("</ResourceID>");
        return sb.toString();
    }
}

