/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.protocol;

import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.protocol.Parameter;
import com.sun.identity.liberty.ws.authnsvc.protocol.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class SelectTransform
extends Transform {
    public SelectTransform() {
        this.name = "urn:liberty:sa:pw:select";
    }

    public SelectTransform(String allowed) {
        this.name = "urn:liberty:sa:pw:select";
        Parameter parameter = new Parameter("allowed", allowed);
        this.parameters = new ArrayList();
        this.parameters.add(parameter);
    }

    public String transform(String password) {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("SelectTransform.transform");
        }
        if (this.parameters == null || this.parameters.isEmpty()) {
            if (AuthnSvcUtils.debug.warningEnabled()) {
                AuthnSvcUtils.debug.warning("SelectTransform.transform: no parameter found");
            }
            return password;
        }
        Iterator iter = this.parameters.iterator();
        while (iter.hasNext()) {
            Parameter parameter = (Parameter)iter.next();
            if (!parameter.getName().equals("allowed")) continue;
            String allowed = parameter.getValue();
            if (AuthnSvcUtils.debug.messageEnabled()) {
                AuthnSvcUtils.debug.message("SelectTransform.transform: allowed = " + allowed);
            }
            if (allowed == null || allowed.length() == 0) {
                return "";
            }
            int pLen = password.length();
            StringBuffer resultSB = new StringBuffer(pLen);
            for (int i = 0; i < pLen; ++i) {
                char c = password.charAt(i);
                if (allowed.indexOf(c) == -1) continue;
                resultSB.append(c);
            }
            return resultSB.toString();
        }
        if (AuthnSvcUtils.debug.warningEnabled()) {
            AuthnSvcUtils.debug.warning("SelectTransform.transform: parameter 'allowed' not found");
        }
        return password;
    }
}

