/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.admin;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class DisplayOptionsUtils {
    private static final String CONSOLE_SERVICE_NAME = "iplanetamadminconsoleservice";
    private static final String ATTR_CONSOLE_ROLE_DISPLAY_OPTION = "iplanet-am-admin-console-role-display-options";

    private DisplayOptionsUtils() {
    }

    public static Set getDefaultDisplayOptions(SSOToken ssoToken, String roleDefn) throws SMSException, SSOException {
        Set allDisplayOptions;
        Set displayOptions = Collections.EMPTY_SET;
        Map mapSvcConf = DisplayOptionsUtils.getServiceConfiguration(ssoToken, CONSOLE_SERVICE_NAME, SchemaType.GLOBAL);
        if (!mapSvcConf.isEmpty() && (allDisplayOptions = (Set)mapSvcConf.get(ATTR_CONSOLE_ROLE_DISPLAY_OPTION)) != null && !allDisplayOptions.isEmpty()) {
            displayOptions = DisplayOptionsUtils.getDefaultDisplayOptions(allDisplayOptions, roleDefn);
        }
        return displayOptions;
    }

    private static Set getDefaultDisplayOptions(Set allDisplayOptions, String roleDefn) {
        HashSet<String> displayOptions = null;
        String prefix = roleDefn + "|";
        Iterator iter = allDisplayOptions.iterator();
        while (iter.hasNext() && displayOptions == null) {
            StringTokenizer st;
            String options = (String)iter.next();
            if (!options.startsWith(prefix) || (st = new StringTokenizer(options, "|")).countTokens() != 3) continue;
            st.nextToken();
            st.nextToken();
            StringTokenizer stz = new StringTokenizer(st.nextToken(), " ");
            displayOptions = new HashSet<String>(stz.countTokens());
            while (stz.hasMoreElements()) {
                displayOptions.add(stz.nextToken());
            }
        }
        return displayOptions != null ? displayOptions : Collections.EMPTY_SET;
    }

    private static Map getServiceConfiguration(SSOToken ssoToken, String serviceName, SchemaType type) throws SMSException, SSOException {
        Map attrMap = Collections.EMPTY_MAP;
        if (type != SchemaType.POLICY) {
            ServiceSchemaManager scm = new ServiceSchemaManager(serviceName, ssoToken);
            attrMap = scm.getSchema(type).getAttributeDefaults();
        }
        return attrMap;
    }
}

