/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import netscape.ldap.LDAPException;

public class LDAPServiceException
extends Exception {
    public static final int SERVER_DOWN = 4;
    public static final int INVALID_OPERATION = 5;
    public static final int INCORRECT_SERVER_PARAMS = 6;
    public static final int INCORRECT_LDAP_PARAMS = 7;
    public static final int INCORRECT_CP_PARAMS = 8;
    public static final int INCORRECT_LDAP_REBIND_PARAMS = 9;
    public static final int MUST_HAVE_SERVICE_NAME = 10;
    public static final int FILTER_IS_REQD = 11;
    public static final int INVALID_SEARCH_CONSTRAINTS = 12;
    public static final int SERVICE_NOT_PRESENT = 13;
    public static final int NO_COMMON_SERVICE_SPECIFIED = 14;
    public static final int SERVER_NOT_PRESENT = 15;
    public static final int INVALID_ENTRY_ID = 16;
    public static final int INCOMPATIBLE_DB_TYPE = 17;
    public static final int CACHE_OP_NOT_SUPPORTED = 18;
    public static final int FILE_NOT_FOUND = 19;
    public static final int UNKNOWN_ERROR = 20;
    int exceptionCode = -1;
    Throwable rootCause;

    public LDAPServiceException(int code) {
        this.exceptionCode = code;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.rootCause != null) {
            buf.append(this.rootCause.toString());
        }
        buf.append('\n');
        buf.append(this.getMessage());
        return buf.toString();
    }

    public String getMessage() {
        String str = "Got LDAPServiceException code=" + this.exceptionCode;
        return str;
    }

    public LDAPServiceException(int code, String errormsg) {
        super(errormsg);
        this.exceptionCode = code;
    }

    public LDAPServiceException(String errormsg) {
        super(errormsg);
    }

    public LDAPServiceException(String errormsg, Throwable t) {
        super(errormsg);
        this.rootCause = t;
    }

    public int getLDAPExceptionErrorCode() {
        if (this.rootCause == null) {
            return -1;
        }
        if (this.rootCause instanceof LDAPException) {
            return ((LDAPException)this.rootCause).getLDAPResultCode();
        }
        if (this.rootCause instanceof LDAPServiceException) {
            return ((LDAPServiceException)this.rootCause).getLDAPExceptionErrorCode();
        }
        return -1;
    }
}

