/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.AVAValueConverter;
import com.iplanet.security.x509.DirStrConverter;
import com.iplanet.security.x509.IA5StringConverter;
import com.iplanet.security.x509.PrintableConverter;
import java.util.Enumeration;
import java.util.Hashtable;

public class X500NameAttrMap {
    Hashtable name2OID = new Hashtable();
    Hashtable oid2Name = new Hashtable();
    Hashtable oid2ValueConverter = new Hashtable();
    private static X500NameAttrMap defMap = new X500NameAttrMap();

    public String getName(ObjectIdentifier oid) {
        return (String)this.oid2Name.get(oid);
    }

    public ObjectIdentifier getOid(String name) {
        return (ObjectIdentifier)this.name2OID.get(name.toUpperCase());
    }

    public AVAValueConverter getValueConverter(String name) {
        ObjectIdentifier oid = (ObjectIdentifier)this.name2OID.get(name.toUpperCase());
        if (oid == null) {
            return null;
        }
        return (AVAValueConverter)this.oid2ValueConverter.get(oid);
    }

    public AVAValueConverter getValueConverter(ObjectIdentifier oid) {
        return (AVAValueConverter)this.oid2ValueConverter.get(oid);
    }

    public Enumeration getAllNames() {
        return this.name2OID.keys();
    }

    public Enumeration getAllOIDs() {
        return this.oid2Name.keys();
    }

    public ObjectIdentifier getOid(ObjectIdentifier oid) {
        String name = (String)this.oid2Name.get(oid);
        if (name == null) {
            return null;
        }
        return (ObjectIdentifier)this.name2OID.get(name);
    }

    public void addNameOID(String name, ObjectIdentifier oid, AVAValueConverter valueConverter) {
        ObjectIdentifier theOid = (ObjectIdentifier)this.name2OID.get(name);
        if (theOid != null) {
            Class<?> expValueConverter = this.oid2ValueConverter.get(theOid).getClass();
            if (!theOid.equals(oid) || expValueConverter != valueConverter.getClass()) {
                throw new IllegalArgumentException("Another keyword-oid-valueConverter triple already exists in the X500NameAttrMap ");
            }
            return;
        }
        this.name2OID.put(name.toUpperCase(), oid);
        this.oid2Name.put(oid, name.toUpperCase());
        this.oid2ValueConverter.put(oid, valueConverter);
    }

    public static X500NameAttrMap getDefault() {
        return defMap;
    }

    public static void setDefault(X500NameAttrMap newDefault) {
        defMap = newDefault;
    }

    static {
        DirStrConverter directoryStr = new DirStrConverter();
        IA5StringConverter ia5Str = new IA5StringConverter();
        defMap.addNameOID("CN", new ObjectIdentifier("2.5.4.3"), directoryStr);
        defMap.addNameOID("OU", new ObjectIdentifier("2.5.4.11"), directoryStr);
        defMap.addNameOID("O", new ObjectIdentifier("2.5.4.10"), directoryStr);
        defMap.addNameOID("SERIALNUMBER", new ObjectIdentifier("2.5.4.5"), new PrintableConverter());
        defMap.addNameOID("C", new ObjectIdentifier("2.5.4.6"), new PrintableConverter());
        defMap.addNameOID("L", new ObjectIdentifier("2.5.4.7"), directoryStr);
        defMap.addNameOID("ST", new ObjectIdentifier("2.5.4.8"), directoryStr);
        defMap.addNameOID("STREET", new ObjectIdentifier("2.5.4.9"), directoryStr);
        defMap.addNameOID("TITLE", new ObjectIdentifier("2.5.4.12"), directoryStr);
        defMap.addNameOID("UID", new ObjectIdentifier("0.9.2342.19200300.100.1.1"), directoryStr);
        defMap.addNameOID("MAIL", new ObjectIdentifier("0.9.2342.19200300.100.1.3"), ia5Str);
        defMap.addNameOID("E", new ObjectIdentifier("1.2.840.113549.1.9.1"), ia5Str);
        defMap.addNameOID("DC", new ObjectIdentifier("0.9.2342.19200300.100.1.25"), ia5Str);
        defMap.addNameOID("SN", new ObjectIdentifier("2.5.4.4"), directoryStr);
        defMap.addNameOID("GIVENNAME", new ObjectIdentifier("2.5.4.42"), directoryStr);
        defMap.addNameOID("INITIALS", new ObjectIdentifier("2.5.4.43"), directoryStr);
        defMap.addNameOID("GENERATIONQUALIFIER", new ObjectIdentifier("2.5.4.44"), directoryStr);
        defMap.addNameOID("DNQUALIFIER", new ObjectIdentifier("2.5.4.46"), directoryStr);
        defMap.addNameOID("UNSTRUCTUREDNAME", new ObjectIdentifier("1.2.840.113549.1.9.2"), ia5Str);
        defMap.addNameOID("UNSTRUCTUREDADDRESS", new ObjectIdentifier("1.2.840.113549.1.9.8"), new PrintableConverter());
    }
}

