/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.JSSPasswordCallback;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.Provider;
import java.security.Security;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.util.PasswordCallback;

public class JSSInit {
    public static final String defaultDBdir = System.getProperty("java.io.tmpdir");
    private static Debug debug = Debug.getInstance("amJSS");
    private static boolean initialized = false;
    private static CryptoManager cm = null;
    private static CryptoToken token = null;

    public static synchronized boolean initialize() {
        String password;
        String responderNickName;
        String responderURL;
        boolean ocspCheck;
        String fipsMode;
        boolean donotInstallJSSProviderAt0;
        String certdbPrefix;
        String certdbDir;
        block33: {
            if (initialized) {
                return true;
            }
            String method = "JSSInit.initialize";
            certdbDir = SystemPropertiesManager.get("com.iplanet.am.admin.cli.certdb.dir");
            if (certdbDir == null) {
                certdbDir = defaultDBdir;
            }
            if ((certdbPrefix = SystemPropertiesManager.get("com.iplanet.am.admin.cli.certdb.prefix")) == null) {
                certdbPrefix = "";
            }
            donotInstallJSSProviderAt0 = Boolean.valueOf(SystemPropertiesManager.get("com.sun.identity.jss.donotInstallAtHighestPriority", "false"));
            String passfile = SystemPropertiesManager.get("com.iplanet.am.admin.cli.certdb.passfile");
            String ocspCheckValue = SystemPropertiesManager.get("com.sun.identity.authentication.ocspCheck");
            fipsMode = SystemPropertiesManager.get("com.sun.identity.security.fipsmode", null);
            if (ocspCheckValue != null && ocspCheckValue.trim().length() == 0) {
                ocspCheckValue = null;
            }
            ocspCheck = ocspCheckValue != null && ocspCheckValue.equalsIgnoreCase("true");
            responderURL = SystemPropertiesManager.get("com.sun.identity.authentication.ocsp.responder.url");
            if (responderURL != null && responderURL.trim().length() == 0) {
                responderURL = null;
            }
            if ((responderNickName = SystemPropertiesManager.get("com.sun.identity.authentication.ocsp.responder.nickname")) != null && responderNickName.trim().length() == 0) {
                responderNickName = null;
            }
            if (debug.messageEnabled()) {
                debug.message("JSSInit.initializecertdbDir = " + certdbDir);
                debug.message("JSSInit.initializecertdbPrefix = " + certdbPrefix);
                debug.message("JSSInit.initializecertdbPassfile = " + passfile);
                debug.message("JSSInit.initializeresponderURL = " + responderURL);
                debug.message("JSSInit.initializeresponderNickName = " + responderNickName);
                debug.message("JSSInit.initializefipsMode = " + fipsMode);
            }
            password = null;
            if (passfile != null) {
                try {
                    FileInputStream fis = new FileInputStream(passfile);
                    InputStreamReader isr = new InputStreamReader(fis);
                    BufferedReader br = new BufferedReader(isr);
                    password = br.readLine();
                }
                catch (Exception ex) {
                    if (!debug.messageEnabled()) break block33;
                    debug.message("JSSInit.initializeUnable to read JSS password file " + passfile);
                }
            }
        }
        String keydbPrefix = certdbPrefix;
        String moddb = "secmod.db";
        try {
            cm = CryptoManager.getInstance();
        }
        catch (CryptoManager.NotInitializedException exp) {
            try {
                CryptoManager.InitializationValues iv = null;
                iv = certdbPrefix.length() == 0 ? new CryptoManager.InitializationValues(certdbDir) : new CryptoManager.InitializationValues(certdbDir, certdbPrefix, keydbPrefix, moddb);
                if (debug.messageEnabled()) {
                    debug.message("JSSInit.initializeoutput of Initilization values ");
                    debug.message("JSSInit.initializeManufacturer ID: " + iv.getManufacturerID());
                    debug.message("JSSInit.initializeLibrary: " + iv.getLibraryDescription());
                    debug.message("JSSInit.initializeInternal Slot: " + iv.getInternalSlotDescription());
                    debug.message("JSSInit.initializeInternal Token: " + iv.getInternalTokenDescription());
                    debug.message("JSSInit.initializeKey Storage Slot: " + iv.getFIPSKeyStorageSlotDescription());
                    debug.message("JSSInit.initializeKey Storage Token: " + iv.getInternalKeyStorageTokenDescription());
                    debug.message("JSSInit.initializeFIPS Slot: " + iv.getFIPSSlotDescription());
                    debug.message("JSSInit.initializeFIPS Key Storage: " + iv.getFIPSKeyStorageSlotDescription());
                }
                if (fipsMode == null) {
                    iv.fipsMode = CryptoManager.InitializationValues.FIPSMode.UNCHANGED;
                } else if (fipsMode.equalsIgnoreCase("true")) {
                    iv.fipsMode = CryptoManager.InitializationValues.FIPSMode.ENABLED;
                } else if (fipsMode.equalsIgnoreCase("false")) {
                    iv.fipsMode = CryptoManager.InitializationValues.FIPSMode.DISABLED;
                }
                iv.removeSunProvider = false;
                if (donotInstallJSSProviderAt0) {
                    iv.installJSSProvider = false;
                }
                iv.readOnly = true;
                iv.ocspCheckingEnabled = ocspCheck;
                if (ocspCheck && responderURL != null && responderNickName != null) {
                    iv.ocspResponderCertNickname = responderNickName;
                    iv.ocspResponderURL = responderURL;
                }
                CryptoManager.initialize((CryptoManager.InitializationValues)iv);
                if (donotInstallJSSProviderAt0) {
                    Provider provider = null;
                    try {
                        provider = (Provider)Class.forName("org.mozilla.jss.JSSProvider").newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        provider = (Provider)Class.forName("org.mozilla.jss.provider.Provider").newInstance();
                    }
                    Security.addProvider(provider);
                }
                cm = CryptoManager.getInstance();
                if (password != null) {
                    cm.setPasswordCallback((PasswordCallback)new JSSPasswordCallback(password));
                }
                token = cm.getInternalKeyStorageToken();
                if (cm.FIPSEnabled()) {
                    token.login(cm.getPasswordCallback());
                }
                cm.setThreadToken(token);
                if (debug.messageEnabled()) {
                    if (cm.FIPSEnabled()) {
                        debug.message("JSSInit.initializeFIPS enabled.");
                    } else {
                        debug.message("JSSInit.initializeFIPS not enabled.");
                    }
                }
                initialized = true;
            }
            catch (KeyDatabaseException kdbe) {
                debug.error("JSSInit.initializeCouldn't open the key database.", kdbe);
            }
            catch (CertDatabaseException cdbe) {
                debug.error("JSSInit.initializeCouldn't open the certificate database.", cdbe);
            }
            catch (AlreadyInitializedException aie) {
                debug.error("JSSInit.initializeCryptoManager already initialized.", aie);
            }
            catch (Exception e) {
                debug.error("JSSInit.initializeException occurred: ", e);
            }
        }
        return initialized;
    }

    public static CryptoManager getCryptoManager() {
        if (cm == null) {
            JSSInit.initialize();
        }
        return cm;
    }

    public static CryptoToken getCryptoToken() {
        if (cm == null) {
            JSSInit.initialize();
        }
        return token;
    }
}

