/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.common;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.common.MiscUtils;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import java.util.Map;
import java.util.Set;

public class CallBackHelperBase
implements AMConstants {
    protected static Debug debug = MiscUtils.getDebugInstance();
    protected static final String PRE_POST_PROCESSING_MODULES_ATTR = "iplanet-am-admin-console-pre-post-processing-modules";
    protected static final String EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR = "iplanet-am-admin-console-external-attribute-fetch-enabled";
    protected SSOToken internalToken = MiscUtils.getInternalToken();

    protected Set getOrgConfigAttribute(String orgDN, String attrName) {
        try {
            ServiceConfig sc = AMServiceUtils.getOrgConfig(this.internalToken, orgDN, "iPlanetAMAdminConsoleService");
            if (sc != null) {
                Map attributes = sc.getAttributes();
                return (Set)attributes.get(attrName);
            }
            return this.getDefaultGlobalConfig(attrName);
        }
        catch (Exception ee) {
            return this.getDefaultGlobalConfig(attrName);
        }
    }

    protected Set getDefaultGlobalConfig(String attrName) {
        block4: {
            if (debug.messageEnabled()) {
                debug.message("CallBackHelper.getPrePostImpls() Organization config for service (iPlanetAMAdminConsoleService," + attrName + ") not found. Obtaining default service " + "config values ..");
            }
            try {
                Map defaultValues = AMServiceUtils.getServiceConfig(this.internalToken, "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                if (defaultValues != null) {
                    return (Set)defaultValues.get(attrName);
                }
            }
            catch (Exception e) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("CallBackHelper.getPrePostProcessClasses(): Unable to get Pre/Post Processing information", e);
            }
        }
        return null;
    }

    protected Set getPrePostImpls(String orgDN) {
        return this.getOrgConfigAttribute(orgDN, PRE_POST_PROCESSING_MODULES_ATTR);
    }

    public boolean isExistsPrePostPlugins(String orgDN) {
        Set plugins = this.getPrePostImpls(orgDN);
        return plugins != null && !plugins.isEmpty();
    }

    public boolean isExternalGetAttributesEnabled(String orgDN) {
        Set values = this.getOrgConfigAttribute(orgDN, EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
        boolean enabled = false;
        if (values != null && !values.isEmpty()) {
            String val = (String)values.iterator().next();
            enabled = val.equalsIgnoreCase("true");
        }
        debug.message("CallBackHelper.isExternalGetAttributeEnabled() = " + enabled);
        return enabled;
    }
}

