/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.common;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.common.MiscUtils;
import com.sun.identity.shared.debug.Debug;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class CacheBlockBase {
    private AMHashMap cacheEntries;
    private String entryDN;
    private int objectType = -9999;
    private AMHashMap stringAttributes;
    private AMHashMap byteAttributes;
    private long lastModifiedTime = 0L;
    private boolean isExpired = false;
    private String organizationDN = null;
    private boolean isValidEntry = true;

    public abstract Debug getDebug();

    public abstract boolean isEntryExpirationEnabled();

    public abstract long getUserEntryExpirationTime();

    public abstract long getDefaultEntryExpirationTime();

    public CacheBlockBase(String entryDN, boolean validEntry) {
        if (validEntry) {
            this.cacheEntries = new AMHashMap();
            this.stringAttributes = new AMHashMap(false);
            this.byteAttributes = new AMHashMap(true);
        } else {
            this.isValidEntry = false;
        }
        this.setLastModifiedTime();
        this.entryDN = entryDN;
    }

    public CacheBlockBase(String entryDN, String orgDN, boolean validEntry) {
        this(entryDN, validEntry);
        this.organizationDN = orgDN;
    }

    public synchronized void setExists(boolean exists) {
        if (exists) {
            this.cacheEntries = new AMHashMap();
            this.stringAttributes = new AMHashMap(false);
            this.byteAttributes = new AMHashMap(true);
        }
        this.isValidEntry = exists;
        this.updateLastModifiedTime();
    }

    private synchronized void setLastModifiedTime() {
        if (this.isEntryExpirationEnabled()) {
            this.lastModifiedTime = System.currentTimeMillis();
        }
    }

    private synchronized void updateLastModifiedTime() {
        if (this.isEntryExpirationEnabled() && this.isExpired) {
            this.lastModifiedTime = System.currentTimeMillis();
            this.isExpired = false;
        }
    }

    public synchronized void setObjectType(int type) {
        this.objectType = type;
        this.updateLastModifiedTime();
    }

    public synchronized void setOrganizationDN(String orgDN) {
        this.organizationDN = orgDN;
        this.updateLastModifiedTime();
    }

    public String getOrganizationDN() {
        this.hasExpiredAndUpdated();
        return this.organizationDN;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public synchronized boolean isExists() {
        return this.isValidEntry;
    }

    public synchronized boolean hasExpiredAndUpdated() {
        if (this.isEntryExpirationEnabled() && !this.isExpired) {
            long expirationTime = 0L;
            switch (this.objectType) {
                case 1: {
                    expirationTime = this.getUserEntryExpirationTime();
                    break;
                }
                default: {
                    expirationTime = this.getDefaultEntryExpirationTime();
                }
            }
            long elapsedTime = System.currentTimeMillis() - this.lastModifiedTime;
            if (elapsedTime >= expirationTime) {
                this.isExpired = true;
                this.clear();
                if (this.getDebug().messageEnabled()) {
                    this.getDebug().message("CacheBlock.hasExpiredAndUpdated(): Entry with DN " + this.entryDN + " expired.");
                }
            }
        }
        return this.isExpired;
    }

    public synchronized boolean hasCompleteSet(String principalDN) {
        CacheEntry ce = (CacheEntry)this.cacheEntries.get(principalDN);
        boolean completeSet = false;
        if (ce != null && !this.hasExpiredAndUpdated()) {
            completeSet = ce.isCompleteSet();
        }
        return completeSet;
    }

    public synchronized Map getAttributes(String principalDN, boolean byteValues) {
        return this.getAttributes(principalDN, null, byteValues);
    }

    public synchronized Map getAttributes(String principalDN, Set attrNames, boolean byteValues) {
        Map attributes = new AMHashMap(byteValues);
        CacheEntry ce = (CacheEntry)this.cacheEntries.get(principalDN);
        if (ce != null && !this.hasExpiredAndUpdated()) {
            Iterator items;
            Set accessibleAttrs = null;
            accessibleAttrs = attrNames == null ? ce.getReadableAttrNames() : ce.getReadableAttrNames(attrNames);
            if (!byteValues) {
                attributes = this.stringAttributes.getCopy(accessibleAttrs);
                if (ce.isCompleteSet() && !attributes.keySet().containsAll(accessibleAttrs) && !this.byteAttributes.isEmpty()) {
                    items = accessibleAttrs.iterator();
                    while (items.hasNext()) {
                        Object key = items.next();
                        if (attributes.containsKey(key) || !this.byteAttributes.containsKey(key)) continue;
                        byte[][] values = (byte[][])this.byteAttributes.get(key);
                        HashSet<String> valueSet = new HashSet<String>(values.length * 2);
                        for (int i = 0; i < values.length; ++i) {
                            try {
                                valueSet.add(new String(values[i], "UTF8"));
                                continue;
                            }
                            catch (UnsupportedEncodingException uee) {
                                valueSet.add(new String(values[i]));
                            }
                        }
                        attributes.put(key, valueSet);
                    }
                }
            } else {
                attributes = this.byteAttributes.getCopy(accessibleAttrs);
                if (ce.isCompleteSet() && !attributes.keySet().containsAll(accessibleAttrs) && !this.stringAttributes.isEmpty()) {
                    items = accessibleAttrs.iterator();
                    while (items.hasNext()) {
                        Object key = items.next();
                        if (attributes.containsKey(key) || !this.stringAttributes.containsKey(key)) continue;
                        Set valueSet = (Set)this.stringAttributes.get(key);
                        byte[][] values = new byte[valueSet.size()][];
                        int item = 0;
                        Iterator vals = valueSet.iterator();
                        while (vals.hasNext()) {
                            String val = (String)vals.next();
                            values[item] = new byte[val.length()];
                            byte[] src = null;
                            try {
                                src = val.getBytes("UTF8");
                            }
                            catch (UnsupportedEncodingException uee) {
                                src = val.getBytes();
                            }
                            System.arraycopy(src, 0, values[item], 0, val.length());
                            ++item;
                        }
                        attributes.put(key, values);
                    }
                }
            }
            Set inAccessibleAttrs = ce.getInaccessibleAttrNames(attrNames);
            ((AMHashMap)attributes).addEmptyValues(inAccessibleAttrs);
        }
        return attributes;
    }

    public synchronized void putAttributes(String principalDN, Map attributes, Set inAccessibleAttrNames, boolean isCompleteSet, boolean byteValues) {
        CacheEntry ce = (CacheEntry)this.cacheEntries.get(principalDN);
        if (ce == null) {
            ce = new CacheEntry();
            this.cacheEntries.put(principalDN, ce);
        }
        if (!byteValues) {
            Set attrsWithValues = this.stringAttributes.copyValuesOnly(attributes);
            ce.putAttributes(attrsWithValues, inAccessibleAttrNames, isCompleteSet);
        } else {
            Set attrsWithValues = this.byteAttributes.copyValuesOnly(attributes);
            ce.putAttributes(attrsWithValues, inAccessibleAttrNames, isCompleteSet);
        }
        this.updateLastModifiedTime();
    }

    public synchronized void removeAttributes(String principalDN) {
        CacheEntry ce = (CacheEntry)this.cacheEntries.remove(principalDN);
        if (ce != null) {
            ce.clear();
        }
    }

    public synchronized void removeAttributes(Set attrNames) {
        if (attrNames != null && !attrNames.isEmpty()) {
            this.stringAttributes.removeKeys(attrNames);
            this.byteAttributes.removeKeys(attrNames);
            Iterator itr = this.cacheEntries.keySet().iterator();
            while (itr.hasNext()) {
                String principalDN = (String)itr.next();
                this.removeAttributes(principalDN, attrNames);
            }
        }
    }

    private synchronized void removeAttributes(String principalDN, Set attrNames) {
        CacheEntry ce = (CacheEntry)this.cacheEntries.get(principalDN);
        if (ce != null) {
            ce.removeAttributeNames(attrNames);
        }
    }

    public synchronized void replaceAttributes(String principalDN, Map sAttributes, Map bAttributes) {
        CacheEntry ce = (CacheEntry)this.cacheEntries.get(principalDN);
        Set attrNames = Collections.EMPTY_SET;
        if (sAttributes != null && !sAttributes.isEmpty()) {
            attrNames = sAttributes.keySet();
        } else if (bAttributes != null && !bAttributes.isEmpty()) {
            attrNames = bAttributes.keySet();
        }
        if (ce != null && attrNames != null && !attrNames.isEmpty()) {
            ce.removeAttributeNames(attrNames);
        }
        this.stringAttributes.copy(sAttributes);
        this.byteAttributes.copy(bAttributes);
    }

    public synchronized void clear() {
        if (this.isValidEntry) {
            this.stringAttributes.clear();
            this.byteAttributes.clear();
            this.cacheEntries.clear();
        }
        this.lastModifiedTime = 0L;
        this.organizationDN = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n----------- START CACHE BLOCK -----------");
        sb.append("\nEntry DN: ").append(this.entryDN);
        sb.append(" Valid Entry: ").append(this.isValidEntry);
        sb.append("\nOrganization: ").append(this.organizationDN);
        sb.append("\nString Attributes: ");
        if (this.stringAttributes != null && !this.stringAttributes.isEmpty()) {
            sb.append(MiscUtils.mapSetToString(this.stringAttributes));
        }
        sb.append("\nByte Attributes: ");
        sb.append(MiscUtils.mapSetToString(this.byteAttributes));
        sb.append("\nByte Negative Attributes: ");
        if (this.byteAttributes != null && !this.byteAttributes.isEmpty()) {
            sb.append(this.byteAttributes.getNegativeByteAttrClone().toString());
        }
        sb.append("\nCache Entries: ");
        if (this.cacheEntries != null && !this.cacheEntries.isEmpty()) {
            Iterator itr = this.cacheEntries.keySet().iterator();
            while (itr.hasNext()) {
                String principal = (String)itr.next();
                CacheEntry ce = (CacheEntry)this.cacheEntries.get(principal);
                sb.append("\nPrincipal: ").append(principal);
                sb.append(ce.toString());
            }
        } else {
            sb.append("<empty>");
        }
        sb.append("\n----------- END CACHE BLOCK -----------");
        return sb.toString();
    }

    class CacheEntry {
        private boolean completeSet = false;
        private Set readableAttrNames = new HashSet();
        private Set inAccessibleAttrNames = new HashSet();

        CacheEntry() {
        }

        protected Set getReadableAttrNames() {
            return this.readableAttrNames;
        }

        protected Set getReadableAttrNames(Set attrNames) {
            HashSet<String> attributesPresent = new HashSet<String>();
            Iterator itr = attrNames.iterator();
            while (itr.hasNext()) {
                String name = ((String)itr.next()).toLowerCase();
                if (!this.readableAttrNames.contains(name)) continue;
                attributesPresent.add(name);
            }
            return attributesPresent;
        }

        protected Set getInaccessibleAttrNames(Set attrNames) {
            if (attrNames == null || attrNames.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> attributesPresent = new HashSet<String>();
            Iterator itr = attrNames.iterator();
            while (itr.hasNext()) {
                String name = ((String)itr.next()).toLowerCase();
                if (!this.inAccessibleAttrNames.contains(name)) continue;
                attributesPresent.add(name);
            }
            return attributesPresent;
        }

        protected void putAttributes(Set attrNames, Set invalidAttrs, boolean isCompleteSet) {
            String name;
            Iterator it;
            this.completeSet = isCompleteSet;
            if (attrNames != null && !attrNames.isEmpty()) {
                it = attrNames.iterator();
                while (it.hasNext()) {
                    name = ((String)it.next()).toLowerCase();
                    this.readableAttrNames.add(name);
                }
            }
            if (invalidAttrs != null && !invalidAttrs.isEmpty()) {
                it = invalidAttrs.iterator();
                while (it.hasNext()) {
                    name = ((String)it.next()).toLowerCase();
                    this.inAccessibleAttrNames.add(name);
                }
            }
        }

        protected void removeAttributeNames(Set attrNames) {
            this.completeSet = false;
            Iterator iter = attrNames.iterator();
            while (iter.hasNext()) {
                String name = ((String)iter.next()).toLowerCase();
                boolean removed = this.readableAttrNames.remove(name);
                if (removed) continue;
                this.inAccessibleAttrNames.remove(name);
            }
        }

        protected boolean isCompleteSet() {
            return this.completeSet;
        }

        protected void clear() {
            this.completeSet = false;
            this.readableAttrNames.clear();
            this.inAccessibleAttrNames.clear();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(" Complete Set: ").append(this.completeSet);
            sb.append(" Attributes: ").append(this.readableAttrNames);
            sb.append(" In Accessable attributes: ");
            sb.append(this.inAccessibleAttrNames);
            return sb.toString();
        }
    }
}

