/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.common;

import com.iplanet.am.sdk.common.CacheBlockBase;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.Debug;

public class CacheBlock
extends CacheBlockBase {
    protected static final String ENTRY_EXPIRATION_ENABLED_KEY = "com.iplanet.am.sdk.cache.entry.expire.enabled";
    protected static final String ENTRY_USER_EXPIRE_TIME_KEY = "com.iplanet.am.sdk.cache.entry.user.expire.time";
    protected static final String ENTRY_DEFAULT_EXPIRE_TIME_KEY = "com.iplanet.am.sdk.cache.entry.default.expire.time";
    protected static boolean ENTRY_EXPIRATION_ENABLED_FLAG = false;
    protected static long ENTRY_USER_EXPIRE_TIME;
    protected static long ENTRY_DEFAULT_EXPIRE_TIME;
    private Debug debug = Debug.getInstance("amProfile_ldap");

    private static void initializeExpirationParms() {
        CacheBlock.setEntryExpirationEnabledFlag();
        if (ENTRY_EXPIRATION_ENABLED_FLAG) {
            CacheBlock.setUserEntryExpirationTime();
            CacheBlock.setDefaultEntryExpirationTime();
        }
    }

    private static void setEntryExpirationEnabledFlag() {
        String userEntryExpireTimeStr = SystemProperties.get(ENTRY_EXPIRATION_ENABLED_KEY, "false");
        ENTRY_EXPIRATION_ENABLED_FLAG = Boolean.valueOf(userEntryExpireTimeStr);
    }

    private static void setUserEntryExpirationTime() {
        ENTRY_USER_EXPIRE_TIME = CacheBlock.getPropertyIntValue(ENTRY_USER_EXPIRE_TIME_KEY, 15) * 60000;
    }

    private static void setDefaultEntryExpirationTime() {
        ENTRY_DEFAULT_EXPIRE_TIME = CacheBlock.getPropertyIntValue(ENTRY_DEFAULT_EXPIRE_TIME_KEY, 30) * 60000;
    }

    private static int getPropertyIntValue(String key, int defaultValue) {
        int value = defaultValue;
        String valueStr = SystemProperties.get(key);
        if (valueStr != null && valueStr.trim().length() > 0) {
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public boolean isEntryExpirationEnabled() {
        return ENTRY_EXPIRATION_ENABLED_FLAG;
    }

    public long getUserEntryExpirationTime() {
        return ENTRY_USER_EXPIRE_TIME;
    }

    public long getDefaultEntryExpirationTime() {
        return ENTRY_DEFAULT_EXPIRE_TIME;
    }

    public CacheBlock(String entryDN, boolean validEntry) {
        super(entryDN, validEntry);
    }

    public CacheBlock(String entryDN, String orgDN, boolean validEntry) {
        super(entryDN, orgDN, validEntry);
    }

    static {
        CacheBlock.initializeExpirationParms();
    }
}

