/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMAssignableDynamicGroupImpl;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMDynamicGroupImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMGroupImpl;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStaticGroupImpl;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AMGroupContainerImpl
extends AMObjectImpl
implements AMGroupContainer {
    public AMGroupContainerImpl(SSOToken ssoToken, String DN2) {
        super(ssoToken, DN2, 4);
    }

    public Set createSubGroupContainers(Set groupContainerNames) throws AMException, SSOException {
        Iterator iter = groupContainerNames.iterator();
        HashSet<AMGroupContainerImpl> groupContainers = new HashSet<AMGroupContainerImpl>();
        while (iter.hasNext()) {
            String groupContainerDN = AMNamingAttrManager.getNamingAttr(4) + "=" + (String)iter.next() + "," + this.entryDN;
            AMGroupContainerImpl groupContainerImpl = new AMGroupContainerImpl(this.token, groupContainerDN);
            groupContainerImpl.create();
            groupContainers.add(groupContainerImpl);
        }
        return groupContainers;
    }

    public Set createSubGroupContainers(Map groupContainersMap) throws AMException, SSOException {
        Iterator iter = groupContainersMap.keySet().iterator();
        HashSet<AMGroupContainerImpl> groupContainers = new HashSet<AMGroupContainerImpl>();
        while (iter.hasNext()) {
            String groupContainerName = (String)iter.next();
            String groupContainerDN = AMNamingAttrManager.getNamingAttr(4) + "=" + groupContainerName + "," + this.entryDN;
            Map attributes = (Map)groupContainersMap.get(groupContainerName);
            AMGroupContainerImpl groupContainerImpl = new AMGroupContainerImpl(this.token, groupContainerDN);
            groupContainerImpl.setAttributes(attributes);
            groupContainerImpl.create();
            groupContainers.add(groupContainerImpl);
        }
        return groupContainers;
    }

    public Set getSubGroupContainerDNs(int level) throws AMException, SSOException {
        return this.search(level, this.getSearchFilter(4));
    }

    public long getNumberOfSubGroupContainers() throws AMException, SSOException {
        return this.getSubGroupContainerDNs(1).size();
    }

    public void deleteSubGroupContainers(Set groupContainers) throws AMException, SSOException {
        Iterator iter = groupContainers.iterator();
        while (iter.hasNext()) {
            String groupContainerDN = (String)iter.next();
            AMGroupContainerImpl groupContainer = new AMGroupContainerImpl(this.token, groupContainerDN);
            groupContainer.delete();
        }
    }

    public Set searchSubGroupContainers(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(4), this.getSearchFilter(4), wildcard, avPairs, level);
    }

    public AMSearchResults searchSubGroupContainers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(4), this.getSearchFilter(4), wildcard, avPairs, searchControl);
    }

    public Set createStaticGroups(Set groupNames) throws AMException, SSOException {
        Iterator iter = groupNames.iterator();
        HashSet<AMStaticGroupImpl> groups = new HashSet<AMStaticGroupImpl>();
        while (iter.hasNext()) {
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + (String)iter.next() + "," + this.entryDN;
            AMStaticGroupImpl groupImpl = new AMStaticGroupImpl(this.token, groupDN);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public Set createStaticGroups(Map groupsMap) throws AMException, SSOException {
        Iterator iter = groupsMap.keySet().iterator();
        HashSet<AMStaticGroupImpl> groups = new HashSet<AMStaticGroupImpl>();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + groupName + "," + this.entryDN;
            Map attributes = (Map)groupsMap.get(groupName);
            AMStaticGroupImpl groupImpl = new AMStaticGroupImpl(this.token, groupDN);
            groupImpl.setAttributes(attributes);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public AMGroup createStaticGroup(String name, Map attributes, Map serviceNameAndAttrs) throws AMException, SSOException {
        return this.createGroup(name, attributes, serviceNameAndAttrs, 10);
    }

    protected AMGroup createGroup(String name, Map attributes, Map serviceNameAndAttrs, int type) throws AMException, SSOException {
        AMGroupImpl groupImpl;
        String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + name + "," + this.entryDN;
        switch (type) {
            case 10: {
                groupImpl = new AMStaticGroupImpl(this.token, groupDN);
                break;
            }
            case 11: {
                groupImpl = new AMDynamicGroupImpl(this.token, groupDN);
                break;
            }
            case 12: {
                groupImpl = new AMAssignableDynamicGroupImpl(this.token, groupDN);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (serviceNameAndAttrs != null && !serviceNameAndAttrs.isEmpty()) {
            Set serviceNames = serviceNameAndAttrs.keySet();
            Set registered = this.dsServices.getRegisteredServiceNames(null, this.getOrganizationDN());
            Iterator it = serviceNames.iterator();
            while (it.hasNext()) {
                String tmpS = (String)it.next();
                if (registered.contains(tmpS)) continue;
                Object[] args = new Object[]{tmpS};
                throw new AMException(AMSDKBundle.getString("459", args, this.locale), "459", args);
            }
            Set objectClasses = null;
            if (serviceNames != null && !serviceNames.isEmpty()) {
                objectClasses = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
                Set userOCs = (Set)attributes.get("objectclass");
                objectClasses = AMCommonUtils.combineOCs(userOCs, objectClasses);
            }
            it = serviceNames.iterator();
            while (it.hasNext()) {
                String thisService = (String)it.next();
                Map sAttrMap = (Map)serviceNameAndAttrs.get(thisService);
                try {
                    ServiceSchemaManager ssm = new ServiceSchemaManager(thisService, this.token);
                    ServiceSchema ss = ssm.getSchema(SchemaType.GROUP);
                    sAttrMap = ss.validateAndInheritDefaults(sAttrMap, true);
                    sAttrMap = AMCommonUtils.removeEmptyValues(sAttrMap);
                    groupImpl.setAttributes(sAttrMap);
                }
                catch (SMSException se) {
                    debug.error("AMGroupContainerImpl.createStaticGroup: Data validation failed.. ", se);
                    Object[] args = new Object[]{thisService};
                    throw new AMException(AMSDKBundle.getString("976", args, this.locale), "976", args);
                }
            }
            if (objectClasses != null && !objectClasses.isEmpty()) {
                groupImpl.setAttribute("objectclass", objectClasses);
            }
        }
        groupImpl.setAttributes(attributes);
        groupImpl.create();
        return groupImpl;
    }

    public Set createDynamicGroups(Set groupNames) throws AMException, SSOException {
        Iterator iter = groupNames.iterator();
        HashSet<AMDynamicGroupImpl> groups = new HashSet<AMDynamicGroupImpl>();
        while (iter.hasNext()) {
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + (String)iter.next() + "," + this.entryDN;
            AMDynamicGroupImpl groupImpl = new AMDynamicGroupImpl(this.token, groupDN);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public Set createDynamicGroups(Map groupsMap) throws AMException, SSOException {
        Iterator iter = groupsMap.keySet().iterator();
        HashSet<AMDynamicGroupImpl> groups = new HashSet<AMDynamicGroupImpl>();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + groupName + "," + this.entryDN;
            Map attributes = (Map)groupsMap.get(groupName);
            AMDynamicGroupImpl groupImpl = new AMDynamicGroupImpl(this.token, groupDN);
            groupImpl.setAttributes(attributes);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public AMGroup createDynamicGroup(String name, Map attributes, Map serviceNameAndAttrs) throws AMException, SSOException {
        return this.createGroup(name, attributes, serviceNameAndAttrs, 11);
    }

    public Set createAssignableDynamicGroups(Set groupNames) throws AMException, SSOException {
        Iterator iter = groupNames.iterator();
        HashSet<AMAssignableDynamicGroupImpl> groups = new HashSet<AMAssignableDynamicGroupImpl>();
        while (iter.hasNext()) {
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + (String)iter.next() + "," + this.entryDN;
            AMAssignableDynamicGroupImpl groupImpl = new AMAssignableDynamicGroupImpl(this.token, groupDN);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public Set createAssignableDynamicGroups(Map groupsMap) throws AMException, SSOException {
        Iterator iter = groupsMap.keySet().iterator();
        HashSet<AMAssignableDynamicGroupImpl> groups = new HashSet<AMAssignableDynamicGroupImpl>();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + groupName + "," + this.entryDN;
            Map attributes = (Map)groupsMap.get(groupName);
            AMAssignableDynamicGroupImpl groupImpl = new AMAssignableDynamicGroupImpl(this.token, groupDN);
            groupImpl.setAttributes(attributes);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public AMGroup createAssignableDynamicGroup(String name, Map attributes, Map serviceNameAndAttrs) throws AMException, SSOException {
        return this.createGroup(name, attributes, serviceNameAndAttrs, 12);
    }

    public Set getGroupDNs(int level) throws AMException, SSOException {
        return this.searchGroups("*", null, level);
    }

    public long getNumberOfGroups(int level) throws AMException, SSOException {
        return this.getGroupDNs(level).size();
    }

    public void deleteStaticGroups(Set groupDNs) throws AMException, SSOException {
        Iterator iter = groupDNs.iterator();
        while (iter.hasNext()) {
            String groupDN = (String)iter.next();
            AMStaticGroupImpl group = new AMStaticGroupImpl(this.token, groupDN);
            group.delete();
        }
    }

    public void deleteDynamicGroups(Set groupDNs) throws AMException, SSOException {
        Iterator iter = groupDNs.iterator();
        while (iter.hasNext()) {
            String groupDN = (String)iter.next();
            AMDynamicGroupImpl group = new AMDynamicGroupImpl(this.token, groupDN);
            group.delete();
        }
    }

    public void deleteAssignableDynamicGroups(Set groupDNs) throws AMException, SSOException {
        Iterator iter = groupDNs.iterator();
        while (iter.hasNext()) {
            String groupDN = (String)iter.next();
            AMAssignableDynamicGroupImpl group = new AMAssignableDynamicGroupImpl(this.token, groupDN);
            group.delete();
        }
    }

    public Set searchGroups(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        String filter = "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, level);
    }

    public AMSearchResults searchGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        String filter = "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, searchControl);
    }

    public Set searchGroups(String wildcard, int level, String groupSearchTemplate, Map avPairs) throws AMException, SSOException {
        String filter = groupSearchTemplate != null && groupSearchTemplate.length() > 0 ? this.getSearchFilter(9, groupSearchTemplate) : "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, level);
    }

    public AMSearchResults searchGroups(String wildcard, Map avPairs, String groupSearchTemplate, AMSearchControl searchControl) throws AMException, SSOException {
        String filter = groupSearchTemplate != null && groupSearchTemplate.length() > 0 ? this.getSearchFilter(9, groupSearchTemplate) : "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, searchControl);
    }

    public AMSearchResults searchStaticGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        String filter = this.getSearchFilter(9);
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, searchControl);
    }
}

