/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.wife.swift.model.SwiftMessage;
import net.sourceforge.wife.validation.IValidationUnit;
import net.sourceforge.wife.validation.UnitResult;
import net.sourceforge.wife.validation.ValidationRuleResult;
import net.sourceforge.wife.validation.units.TagExists;
import org.apache.commons.lang.Validate;

public class ValidationRule {
    private List units = new ArrayList();

    public ValidationRuleResult evaluate(SwiftMessage message) {
        Validate.notNull((Object)message, (String)"SwiftMessage can not be null");
        ValidationRuleResult result = new ValidationRuleResult();
        Iterator it = this.units.iterator();
        while (it.hasNext()) {
            IValidationUnit vu = (IValidationUnit)it.next();
            try {
                boolean r = vu.evaluate(message);
                result.add(new UnitResult(null, r));
            }
            catch (Exception e) {
                result.add(new UnitResult(e, null));
            }
        }
        return result;
    }

    protected void addTagMustExistRule(String tag) {
        Validate.notNull((Object)tag);
        TagExists u = new TagExists();
        u.setBlock(new Integer(4));
        u.setTagName(tag);
        this.units.add(u);
    }

    protected void addUnit(IValidationUnit u) {
        Validate.notNull((Object)u);
        this.units.add(u);
    }
}

