/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.wife.WifeException;
import net.sourceforge.wife.swift.model.IMessageVisitor;
import net.sourceforge.wife.swift.model.SwiftBlock;
import net.sourceforge.wife.swift.model.SwiftBlock1;
import net.sourceforge.wife.swift.model.SwiftBlock2;
import net.sourceforge.wife.swift.model.SwiftBlock2Input;
import net.sourceforge.wife.swift.model.SwiftBlock2Output;
import net.sourceforge.wife.swift.model.SwiftBlock3;
import net.sourceforge.wife.swift.model.SwiftBlock4;
import net.sourceforge.wife.swift.model.SwiftBlock5;
import net.sourceforge.wife.swift.model.SwiftBlockUser;
import net.sourceforge.wife.swift.model.SwiftMessage;
import net.sourceforge.wife.swift.model.Tag;
import net.sourceforge.wife.swift.model.UnparsedTextList;

public class XMLWriterVisitor
implements IMessageVisitor {
    private static final transient Logger log = Logger.getLogger(XMLWriterVisitor.class.getName());
    private static final String EOL = System.getProperties().getProperty("line.separator", "\n");
    private Writer writer;

    public XMLWriterVisitor(Writer writer) {
        this.writer = writer;
    }

    public void startMessage(SwiftMessage m) {
        this.write("<message>");
    }

    public void endMessage(SwiftMessage m) {
        if (m.getUnparsedTextsSize() > 0) {
            this.write(m.getUnparsedTexts(), 0);
        }
        this.write(EOL + "</message>");
    }

    public void startBlock1(SwiftBlock1 b) {
        this.write(EOL + "<block1>");
    }

    public void value(SwiftBlock1 b, String v) {
        StringBuffer sb = new StringBuffer();
        if (!b.isEmpty()) {
            this.appendElement(sb, "applicationId", b.getApplicationId());
            this.appendElement(sb, "serviceId", b.getServiceId());
            this.appendElement(sb, "logicalTerminal", b.getLogicalTerminal());
            if (b.getSessionNumber() != null) {
                this.appendElement(sb, "sessionNumber", b.getSessionNumber());
            }
            if (b.getSequenceNumber() != null) {
                this.appendElement(sb, "sequenceNumber", b.getSequenceNumber());
            }
            this.write(sb.toString());
        }
    }

    public void endBlock1(SwiftBlock1 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block1>");
    }

    public void startBlock2(SwiftBlock2 b) {
        String xmlTag = "<block2>";
        if (!b.isEmpty()) {
            if (b instanceof SwiftBlock2Input) {
                xmlTag = "<block2 type=\"input\">";
            }
            if (b instanceof SwiftBlock2Output) {
                xmlTag = "<block2 type=\"output\">";
            }
        }
        this.write(EOL + xmlTag);
    }

    public void value(SwiftBlock2 b, String v) {
        SwiftBlock2 b2;
        if (v == null || v.equals("")) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (b instanceof SwiftBlock2Input) {
            b2 = (SwiftBlock2Input)b;
            this.appendElement(sb, "messageType", ((SwiftBlock2Input)b2).getMessageType());
            this.appendElement(sb, "receiverAddress", ((SwiftBlock2Input)b2).getReceiverAddress());
            if (((SwiftBlock2Input)b2).getMessagePriority() != null) {
                this.appendElement(sb, "messagePriority", ((SwiftBlock2Input)b2).getMessagePriority());
            }
            if (((SwiftBlock2Input)b2).getDeliveryMonitoring() != null) {
                this.appendElement(sb, "deliveryMonitoring", ((SwiftBlock2Input)b2).getDeliveryMonitoring());
            }
            if (((SwiftBlock2Input)b2).getObsolescencePeriod() != null) {
                this.appendElement(sb, "obsolescencePeriod", ((SwiftBlock2Input)b2).getObsolescencePeriod());
            }
        }
        if (b instanceof SwiftBlock2Output) {
            b2 = (SwiftBlock2Output)b;
            this.appendElement(sb, "messageType", b2.getMessageType());
            this.appendElement(sb, "senderInputTime", ((SwiftBlock2Output)b2).getSenderInputTime());
            this.appendElement(sb, "MIRDate", ((SwiftBlock2Output)b2).getMIRDate());
            this.appendElement(sb, "MIRLogicalTerminal", ((SwiftBlock2Output)b2).getMIRLogicalTerminal());
            this.appendElement(sb, "MIRSessionNumber", ((SwiftBlock2Output)b2).getMIRSessionNumber());
            this.appendElement(sb, "MIRSequenceNumber", ((SwiftBlock2Output)b2).getMIRSequenceNumber());
            this.appendElement(sb, "receiverOutputDate", ((SwiftBlock2Output)b2).getReceiverOutputDate());
            this.appendElement(sb, "receiverOutputTime", ((SwiftBlock2Output)b2).getReceiverOutputTime());
            if (b2.getMessagePriority() != null) {
                this.appendElement(sb, "messagePriority", b2.getMessagePriority());
            }
        }
        this.write(sb.toString());
    }

    public void endBlock2(SwiftBlock2 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block2>");
    }

    public void startBlock3(SwiftBlock3 b) {
        this.write(EOL + "<block3>");
    }

    public void tag(SwiftBlock3 b, Tag t) {
        this.appendTag(t);
    }

    public void endBlock3(SwiftBlock3 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block3>");
    }

    public void startBlock4(SwiftBlock4 b) {
        this.write(EOL + "<block4>");
    }

    public void tag(SwiftBlock4 b, Tag t) {
        this.appendTag(t);
    }

    public void endBlock4(SwiftBlock4 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block4>");
    }

    public void startBlock5(SwiftBlock5 b) {
        this.write(EOL + "<block5>");
    }

    public void tag(SwiftBlock5 b, Tag t) {
        this.appendTag(t);
    }

    public void endBlock5(SwiftBlock5 b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block5>");
    }

    public void startBlockUser(SwiftBlockUser b) {
        this.write(EOL + "<block name=\"" + b.getName() + "\">");
    }

    public void tag(SwiftBlockUser b, Tag t) {
        this.appendTag(t);
    }

    public void endBlockUser(SwiftBlockUser b) {
        if (b.getUnparsedTextsSize() > 0) {
            this.write(b.getUnparsedTexts(), 1);
        }
        this.write(EOL + "</block>");
    }

    public void tag(SwiftBlock b, Tag t) {
        if (b == null) {
            return;
        }
        if (b instanceof SwiftBlock3) {
            this.tag((SwiftBlock3)b, t);
        }
        if (b instanceof SwiftBlock4) {
            this.tag((SwiftBlock4)b, t);
        }
        if (b instanceof SwiftBlock5) {
            this.tag((SwiftBlock5)b, t);
        }
        if (b instanceof SwiftBlockUser) {
            this.tag((SwiftBlockUser)b, t);
        }
    }

    private final void appendTag(Tag t) {
        this.write(EOL + "\t<tag>");
        this.write(EOL + "\t\t<name>");
        if (t.getName() != null) {
            this.write(t.getName());
        }
        this.write("</name>");
        this.write(EOL + "\t\t<value>");
        if (t.getValue() != null) {
            this.write(t.getValue());
        }
        this.write("</value>");
        if (t.getUnparsedTextsSize() > 0) {
            this.write(t.getUnparsedTexts(), 2);
        }
        this.write(EOL + "\t</tag>");
    }

    private final void appendElement(StringBuffer sb, String element, String value) {
        sb.append(EOL + "\t<").append(element).append('>').append(value).append("</").append(element).append('>');
    }

    private void write(UnparsedTextList texts, int level) {
        String prefix = "\t";
        switch (level) {
            case 0: {
                prefix = "";
                break;
            }
            case 1: {
                prefix = "\t";
                break;
            }
            case 2: {
                prefix = "\t\t";
                break;
            }
            default: {
                prefix = "\t";
            }
        }
        if (texts.size() > 0) {
            this.write(EOL + prefix + "<unparsedTexts>");
            for (int i = 0; i < texts.size(); ++i) {
                this.write(EOL + prefix + "\t<text>");
                this.write(texts.getText(new Integer(i)));
                this.write("</text>");
            }
            this.write(EOL + prefix + "</unparsedTexts>");
        }
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Caught exception in XMLWriterVisitor, method write", e);
            throw new WifeException(e);
        }
    }
}

