/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.wife.swift.model.IMessageVisitor;
import net.sourceforge.wife.swift.model.SwiftBlock;
import net.sourceforge.wife.swift.model.SwiftBlock1;
import net.sourceforge.wife.swift.model.SwiftBlock2;
import net.sourceforge.wife.swift.model.SwiftBlock2Input;
import net.sourceforge.wife.swift.model.SwiftBlock2Output;
import net.sourceforge.wife.swift.model.SwiftBlock3;
import net.sourceforge.wife.swift.model.SwiftBlock4;
import net.sourceforge.wife.swift.model.SwiftBlock5;
import net.sourceforge.wife.swift.model.SwiftBlockUser;
import net.sourceforge.wife.swift.model.Tag;
import net.sourceforge.wife.swift.model.UnparsedTextList;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SwiftMessage
implements Serializable {
    private static final transient Logger log = Logger.getLogger(SwiftMessage.class.getName());
    protected transient Map handlers = new HashMap();
    private SwiftBlock1 block1;
    private SwiftBlock2 block2;
    private SwiftBlock3 block3;
    private SwiftBlock4 block4;
    private SwiftBlock5 block5;
    protected List userBlocks;
    protected UnparsedTextList unparsedTexts = null;
    protected Long id;
    private boolean initBlocks = false;

    public SwiftMessage() {
        this.initBlocks();
    }

    public SwiftMessage(boolean initBlocks) {
        this.initBlocks = initBlocks;
        if (initBlocks) {
            this.initBlocks();
        }
    }

    public SwiftMessage(boolean initBlocks, UnparsedTextList unparsedText) {
        this(initBlocks);
        this.unparsedTexts = unparsedText;
    }

    public SwiftMessage(UnparsedTextList unparsedText) {
        this();
        this.unparsedTexts = unparsedText;
    }

    private void initBlocks() {
        if (this.initBlocks) {
            this.addBlock(new SwiftBlock1());
            this.addBlock(new SwiftBlock2Input());
            this.addBlock(new SwiftBlock3());
            this.addBlock(new SwiftBlock4());
            this.addBlock(new SwiftBlock5());
            this.userBlocks = new ArrayList();
        }
    }

    public SwiftBlock getBlock(int b) {
        Validate.isTrue((1 <= b && b <= 5 ? 1 : 0) != 0, (String)("block index must be 1-5 (was " + b + ")"));
        switch (b) {
            case 1: {
                return this.block1;
            }
            case 2: {
                return this.block2;
            }
            case 3: {
                return this.block3;
            }
            case 4: {
                return this.block4;
            }
            case 5: {
                return this.block5;
            }
        }
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void addBlock(SwiftBlock b) {
        if (b == null) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Add block " + b);
        }
        if (b instanceof SwiftBlockUser) {
            this.addUserBlock((SwiftBlockUser)b);
            return;
        }
        Validate.notNull((Object)b.getNumber(), (String)"SwiftBlock.getNumber() is null");
        int index = b.getNumber();
        Validate.isTrue((index >= 1 && index <= 5 ? 1 : 0) != 0, (String)"SwiftBlock.getNumber int did not return an int between 1-5");
        switch (index) {
            case 1: {
                this.setBlock1((SwiftBlock1)b);
                break;
            }
            case 2: {
                this.setBlock2((SwiftBlock2)b);
                break;
            }
            case 3: {
                this.setBlock3((SwiftBlock3)b);
                break;
            }
            case 4: {
                this.setBlock4((SwiftBlock4)b);
                break;
            }
            case 5: {
                this.setBlock5((SwiftBlock5)b);
            }
        }
    }

    public boolean isMT(String type) {
        Validate.notNull((Object)type);
        Validate.isTrue((type.length() == 3 ? 1 : 0) != 0, (String)("The string must be exactly 3 chars size (type=" + type + ")"));
        return this.getType() != null && this.getType().equals(type);
    }

    public String getType() {
        SwiftBlock2 b2 = this.getBlock2();
        if (b2 == null) {
            return null;
        }
        if (b2 instanceof SwiftBlock2Input) {
            return ((SwiftBlock2Input)b2).getMessageType();
        }
        if (b2 instanceof SwiftBlock2Output) {
            return ((SwiftBlock2Output)b2).getMessageType();
        }
        return null;
    }

    public void visit(IMessageVisitor visitor) {
        SwiftBlock5 b5;
        SwiftBlock4 b4;
        SwiftBlock3 b3;
        SwiftBlock2 b2;
        Validate.notNull((Object)visitor);
        visitor.startMessage(this);
        SwiftBlock1 b1 = this.getBlock1();
        if (b1 != null) {
            visitor.startBlock1(b1);
            visitor.value(b1, b1.getValue());
            visitor.endBlock1(b1);
        }
        if ((b2 = this.getBlock2()) != null) {
            visitor.startBlock2(b2);
            visitor.value(b2, b2.getValue());
            visitor.endBlock2(b2);
        }
        if ((b3 = this.getBlock3()) != null) {
            visitor.startBlock3(b3);
            this.visit(b3, visitor);
            visitor.endBlock3(b3);
        }
        if ((b4 = this.getBlock4()) != null) {
            visitor.startBlock4(b4);
            this.visit(b4, visitor);
            visitor.endBlock4(b4);
        }
        if ((b5 = this.getBlock5()) != null) {
            visitor.startBlock5(b5);
            this.visit(b5, visitor);
            visitor.endBlock5(b5);
        }
        if (this.userBlocks != null) {
            for (int i = 0; i < this.userBlocks.size(); ++i) {
                SwiftBlockUser userBlock = (SwiftBlockUser)this.userBlocks.get(i);
                if (userBlock == null) continue;
                visitor.startBlockUser(userBlock);
                this.visit(userBlock, visitor);
                visitor.endBlockUser(userBlock);
            }
        }
        visitor.endMessage(this);
    }

    public void visit(SwiftBlock block, IMessageVisitor visitor) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)visitor);
        if (block instanceof SwiftBlock3) {
            this.visit((SwiftBlock3)block, visitor);
        }
        if (block instanceof SwiftBlock4) {
            this.visit((SwiftBlock4)block, visitor);
        }
        if (block instanceof SwiftBlock5) {
            this.visit((SwiftBlock5)block, visitor);
        }
        if (block instanceof SwiftBlockUser) {
            this.visit((SwiftBlockUser)block, visitor);
        }
    }

    public void visit(SwiftBlock3 block, IMessageVisitor visitor) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)visitor);
        Iterator it = block.tagIterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            visitor.tag(block, t);
        }
    }

    public void visit(SwiftBlock4 block, IMessageVisitor visitor) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)visitor);
        Iterator it = block.tagIterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            visitor.tag(block, t);
        }
    }

    public void visit(SwiftBlock5 block, IMessageVisitor visitor) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)visitor);
        Iterator it = block.tagIterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            visitor.tag(block, t);
        }
    }

    public void visit(SwiftBlockUser block, IMessageVisitor visitor) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)visitor);
        Iterator it = block.tagIterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            visitor.tag(block, t);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getBlockCount() {
        return this.getBlockCount(Boolean.TRUE);
    }

    public int getBlockCount(Boolean includeUserBlocks) {
        int count = 0;
        if (this.block1 != null && !this.getBlock1().isEmpty()) {
            ++count;
        }
        if (this.block2 != null && !this.getBlock2().isEmpty()) {
            ++count;
        }
        if (this.block3 != null && !this.getBlock3().isEmpty()) {
            ++count;
        }
        if (this.block4 != null && !this.getBlock4().isEmpty()) {
            ++count;
        }
        if (this.block5 != null && !this.getBlock5().isEmpty()) {
            ++count;
        }
        if (includeUserBlocks.booleanValue() && this.userBlocks != null) {
            count += this.userBlocks.size();
        }
        return count;
    }

    public SwiftBlock1 getBlock1() {
        return this.block1;
    }

    public void setBlock1(SwiftBlock block1) {
        this.block1 = (SwiftBlock1)block1;
    }

    public void setBlock1(SwiftBlock1 block1) {
        this.block1 = block1;
    }

    public SwiftBlock2 getBlock2() {
        return this.block2;
    }

    public void setBlock2(SwiftBlock block2) {
        this.block2 = (SwiftBlock2)block2;
    }

    public void setBlock2(SwiftBlock2 block2) {
        this.block2 = block2;
    }

    public SwiftBlock3 getBlock3() {
        return this.block3;
    }

    public void setBlock3(SwiftBlock block3) {
        this.block3 = (SwiftBlock3)block3;
    }

    public void setBlock3(SwiftBlock3 block3) {
        this.block3 = block3;
    }

    public SwiftBlock4 getBlock4() {
        return this.block4;
    }

    public void setBlock4(SwiftBlock block4) {
        this.block4 = (SwiftBlock4)block4;
    }

    public void setBlock4(SwiftBlock4 block4) {
        this.block4 = block4;
    }

    public SwiftBlock5 getBlock5() {
        return this.block5;
    }

    public void setBlock5(SwiftBlock block5) {
        this.block5 = (SwiftBlock5)block5;
    }

    public void setBlock5(SwiftBlock5 block5) {
        this.block5 = block5;
    }

    public Integer getUserBlockPosition(String blockName) {
        if (blockName == null || blockName.equals("") || this.userBlocks == null) {
            return new Integer(-1);
        }
        for (int i = 0; i < this.userBlocks.size(); ++i) {
            SwiftBlockUser userBlock = (SwiftBlockUser)this.userBlocks.get(i);
            if (userBlock == null || !userBlock.getName().equals(blockName)) continue;
            return new Integer(i);
        }
        return new Integer(-1);
    }

    public List getUserBlocks() {
        return this.userBlocks;
    }

    protected void setUserBlocks(List userBlocks) {
        Validate.notNull((Object)userBlocks, (String)"parameter 'userBlocks' cannot be null");
        Validate.allElementsOfType((Collection)userBlocks, (Class)SwiftBlockUser.class, (String)"parameter 'userBlocks' may only have SwiftBlockUser elements");
        this.userBlocks = userBlocks;
    }

    public SwiftBlockUser getUserBlock(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Integer pos = this.getUserBlockPosition(blockName);
        if (pos != -1) {
            return (SwiftBlockUser)this.userBlocks.get(pos);
        }
        return null;
    }

    public SwiftBlockUser getUserBlock(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        return this.getUserBlock(blockNumber.toString());
    }

    public void addUserBlock(SwiftBlockUser userBlock) {
        Integer pos;
        Validate.notNull((Object)userBlock);
        Validate.isTrue((boolean)userBlock.isValidName(), (String)("Invalid name for User Defined Blocks (" + userBlock.getName() + ")"));
        if (this.userBlocks == null) {
            this.userBlocks = new ArrayList();
        }
        if ((pos = this.getUserBlockPosition(userBlock.getName())) != -1) {
            this.userBlocks.add(pos, userBlock);
        } else {
            this.userBlocks.add(userBlock);
        }
    }

    public void removeUserBlock(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockNumber), (String)("Invalid name for User Defined Blocks (" + blockNumber.toString() + ")"));
        this.removeUserBlock(blockNumber.toString());
    }

    public void removeUserBlock(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockName), (String)("Invalid name for User Defined Blocks (" + blockName + ")"));
        Integer pos = this.getUserBlockPosition(blockName);
        if (pos != -1) {
            this.userBlocks.remove(pos);
        }
    }

    public void clear() {
        this.block1 = null;
        this.block2 = null;
        this.block3 = null;
        this.block4 = null;
        this.block5 = null;
        this.userBlocks = null;
    }

    public Boolean isFragment() {
        SwiftBlock4 b4 = this.getBlock4();
        if (b4 != null) {
            String t202 = b4.getTagValue("202");
            String t203 = b4.getTagValue("203");
            return t202 != null && t203 != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLastFragment() {
        if (!this.isFragment().booleanValue()) {
            return Boolean.FALSE;
        }
        try {
            Integer count = this.fragmentCount();
            Integer number = this.fragmentNumber();
            return count.intValue() == number.intValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Boolean.FALSE;
        }
    }

    public Integer fragmentCount() {
        Integer _t203;
        if (!this.isFragment().booleanValue()) {
            return new Integer(0);
        }
        SwiftBlock4 b4 = this.getBlock4();
        String t203 = b4.getTagValue("203");
        try {
            _t203 = new Integer(Integer.parseInt(t203, 10));
        }
        catch (NumberFormatException nfe) {
            throw new UnsupportedOperationException("message is not a fragment");
        }
        return _t203;
    }

    public Integer fragmentNumber() {
        Integer _t202;
        if (!this.isFragment().booleanValue()) {
            throw new UnsupportedOperationException("message is not a fragment");
        }
        SwiftBlock4 b4 = this.getBlock4();
        String t202 = b4.getTagValue("202");
        try {
            _t202 = new Integer(Integer.parseInt(t202, 10));
        }
        catch (NumberFormatException nfe) {
            throw new UnsupportedOperationException("message is not a fragment");
        }
        return _t202;
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList texts) {
        this.unparsedTexts = texts;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return new Integer(0);
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(index);
    }

    public String unparsedTextGetText(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(index);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(index);
    }

    public void unparsedTextAddText(String text) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(text);
    }

    public void unparsedTextAddText(SwiftMessage message) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(message);
    }
}

