/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts.config;

import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.xml.ws.api.security.trust.config.TrustSPMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAMTrustSPMetadata
implements TrustSPMetadata {
    private static Set attrNames = new HashSet();
    private String endpoint;
    private String spName;
    private String tokenType;
    private String keyType;
    private String certAlias;
    private Map<String, Object> otherOptions = new HashMap<String, Object>();
    private static Debug debug = STSUtils.debug;
    private List secMech = null;
    private static final String AGENT_TYPE_ATTR = "AgentType";
    private static final String WSP_ENDPOINT = "WSPEndpoint";
    private static final String NAME = "Name";
    private static final String SEC_MECH = "SecurityMech";
    private static final String KEY_ALIAS = "privateKeyAlias";
    private static final String KEY_TYPE = "privateKeyType";

    public FAMTrustSPMetadata(String spEndPoint) {
        this.endpoint = spEndPoint;
        this.getAndProcessWSPKeyValues(spEndPoint);
    }

    public String getSPEndPoint() {
        return this.endpoint;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public Map<String, Object> getOtherOptions() {
        return this.otherOptions;
    }

    private void getAndProcessWSPKeyValues(String providerEndPoint) {
        HashSet agentConfigAttribute = new HashSet();
        try {
            SSOToken adminToken = WSSUtils.getAdminToken();
            AMIdentityRepository idRepo = new AMIdentityRepository(adminToken, "/");
            IdSearchControl control = new IdSearchControl();
            control.setAllReturnAttributes(true);
            control.setTimeOut(0);
            HashMap kvPairMap = new HashMap();
            HashSet<String> set = new HashSet<String>();
            set.add("WSPAgent");
            kvPairMap.put(AGENT_TYPE_ATTR, set);
            set = new HashSet();
            set.add(providerEndPoint);
            kvPairMap.put(WSP_ENDPOINT, set);
            control.setSearchModifiers(IdSearchOpModifier.OR, kvPairMap);
            IdSearchResults results = idRepo.searchIdentities(IdType.AGENTONLY, "*", control);
            Set agents = results.getSearchResults();
            if (!agents.isEmpty()) {
                Map attrs = results.getResultAttributes();
                AMIdentity provider = (AMIdentity)agents.iterator().next();
                Map attributes = provider.getAttributes(attrNames);
                if (debug.messageEnabled()) {
                    debug.message("FAMTrustSPMetadata.getAndProcessWSPKeyValues: SP Attributes: " + attributes);
                }
                this.parseAgentKeyValues(attributes);
            }
        }
        catch (Exception e) {
            debug.error("FAMTrustSPMetadata.getAndProcessWSPKeyValues:ERROR: ", (Throwable)e);
        }
    }

    private void parseAgentKeyValues(Map attributes) throws ProviderException {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (String key : attributes.keySet()) {
            Set valSet = (Set)attributes.get(key);
            String value = null;
            if (valSet != null && valSet.size() > 0) {
                Iterator iter = valSet.iterator();
                StringBuffer sb = new StringBuffer(100);
                while (iter.hasNext()) {
                    sb.append((String)iter.next()).append(",");
                }
                sb = sb.deleteCharAt(sb.length() - 1);
                value = sb.toString();
            }
            this.setConfig(key, value);
        }
    }

    private void setConfig(String attr, String value) {
        if (attr.equals(NAME)) {
            this.spName = value;
        } else if (attr.equals(SEC_MECH)) {
            if (this.secMech == null) {
                this.secMech = new ArrayList();
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                this.secMech.add(st.nextToken());
            }
            if (this.secMech != null) {
                if (this.secMech.contains("urn:sun:wss:security:null:SAML2Token-HK") || this.secMech.contains("urn:sun:wss:security:TLS:SAML2Token-HK") || this.secMech.contains("urn:sun:wss:security:ClientTLS:SAML2Token-HK")) {
                    this.tokenType = "urn:oasis:names:tc:SAML:2.0:assertion";
                } else if (this.secMech.contains("urn:sun:wss:security:null:SAMLToken-HK") || this.secMech.contains("urn:sun:wss:security:TLS:SAMLToken-HK") || this.secMech.contains("urn:sun:wss:security:ClientTLS:SAMLToken-HK")) {
                    this.tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
                }
            }
        } else if (attr.equals(KEY_ALIAS)) {
            this.certAlias = value;
        } else if (attr.equals(KEY_TYPE)) {
            this.keyType = value == null || value.length() == 0 ? "http://schemas.xmlsoap.org/ws/2005/02/trust/PublicKey" : "http://schemas.xmlsoap.org/ws/2005/02/trust/" + value;
        }
    }

    static {
        attrNames.add(SEC_MECH);
        attrNames.add(WSP_ENDPOINT);
        attrNames.add(KEY_ALIAS);
        attrNames.add(KEY_TYPE);
    }
}

