/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security.handler;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.X509CertificateCallback;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.security.AssertionToken;
import com.sun.identity.wss.security.PasswordCredential;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SAML2TokenUtils;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityMechanism;
import com.sun.identity.wss.security.SecurityPrincipal;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.UserNameToken;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.security.handler.MessageAuthenticator;
import com.sun.identity.wss.security.handler.SecureSOAPMessage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class DefaultAuthenticator
implements MessageAuthenticator {
    private ProviderConfig config = null;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private static Debug debug = WSSUtils.debug;

    public Object authenticate(Subject subject, SecurityMechanism securityMechanism, SecurityToken securityToken, ProviderConfig config, Object secureMessage, boolean isLiberty) throws SecurityException {
        debug.message("DefaultAuthenticator.authenticate: start");
        this.config = config;
        String authChain = null;
        if (config != null) {
            authChain = config.getAuthenticationChain();
        }
        if (isLiberty) {
            return this.authenticateLibertyMessage(secureMessage, subject);
        }
        if (securityMechanism == null || securityToken == null) {
            throw new SecurityException(bundle.getString("nullInputParameter"));
        }
        String uri = securityMechanism.getURI();
        if ("urn:sun:wss:security:null:UserNameToken".equals(uri) || "urn:sun:wss:security:TLS:UserNameToken".equals(uri) || "urn:sun:wss:security:ClientTLS:UserNameToken".equals(uri) || "urn:sun:wss:security:null:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:TLS:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:ClientTLS:UserNameToken-Plain".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate:: username token authentication");
                debug.message("authenticate: authChain : " + authChain);
            }
            UserNameToken usertoken = (UserNameToken)securityToken;
            if (authChain == null || authChain.length() == 0 || authChain.equals("none") ? config != null && !this.validateUser(usertoken, subject) : !this.authenticateUser(usertoken, subject, authChain)) {
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
        } else if ("urn:sun:wss:security:null:X509Token".equals(uri) || "urn:sun:wss:security:TLS:X509Token".equals(uri) || "urn:sun:wss:security:ClientTLS:X509Token".equals(uri)) {
            SecureSOAPMessage securedMessage;
            X509Certificate cert;
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate:: x509 token authentication");
                debug.message("authenticate: authChain : " + authChain);
            }
            if ((cert = (securedMessage = (SecureSOAPMessage)secureMessage).getMessageCertificate()) == null) {
                debug.error("DefaultAuthenticator.authenticate:: X509 auth could not find the message certificate.");
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
            XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
            String certAlias = sigManager.getKeyProvider().getCertificateAlias((Certificate)cert);
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate: cert : " + cert);
                debug.message("DefaultAuthenticator.authenticate: certAlias : " + certAlias);
            }
            if (authChain != null && authChain.length() != 0 && !authChain.equals("none") && !this.authenticateCert(certAlias, authChain, cert, subject)) {
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
            String subjectDN = cert.getSubjectDN().getName();
            subject = this.addPrincipal(subjectDN, subject);
            subject.getPublicCredentials().add(cert);
            WSSUtils.setRoles(subject, subjectDN);
        } else if ("urn:sun:wss:security:null:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:null:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-SV".equals(uri)) {
            AssertionToken assertionToken;
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate:: saml token authentication");
            }
            if (!this.validateAssertion((assertionToken = (AssertionToken)securityToken).getAssertion(), subject)) {
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
        } else if ("urn:sun:wss:security:null:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:null:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-SV".equals(uri)) {
            SAML2Token saml2Token;
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate:: saml2 token authentication");
            }
            if (!SAML2TokenUtils.validateAssertion((saml2Token = (SAML2Token)securityToken).getAssertion(), subject)) {
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
        } else {
            debug.error("DefaultAuthenticator.authenticate:: Invalid security mechanism");
            throw new SecurityException(bundle.getString("authenticationFailed"));
        }
        return subject;
    }

    private boolean validateUser(UserNameToken usernameToken, Subject subject) throws SecurityException {
        String user = usernameToken.getUserName();
        String password = usernameToken.getPassword();
        if (user == null || password == null) {
            return false;
        }
        List users = this.config.getUsers();
        if (users == null || users.isEmpty()) {
            debug.error("DefaultAuthenticator.validateUser:: users are not  configured in the providers.");
            return false;
        }
        Iterator iter = users.iterator();
        String configuredUser = null;
        String configuredPassword = null;
        while (iter.hasNext()) {
            PasswordCredential cred = (PasswordCredential)iter.next();
            configuredUser = cred.getUserName();
            if (!configuredUser.equals(user)) continue;
            configuredPassword = cred.getPassword();
            break;
        }
        if (configuredUser == null || configuredPassword == null) {
            debug.error("DefaultAuthenticator.validateUser:: configured user  does not have the password.");
            return false;
        }
        String passwordType = usernameToken.getPasswordType();
        if (passwordType != null && passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
            String created;
            String nonce = usernameToken.getNonce();
            String digest = UserNameToken.getPasswordDigest(configuredPassword, nonce, created = usernameToken.getCreated());
            if (!digest.equals(password) || !configuredUser.equals(user)) {
                debug.error("DefaultAuthenticator.validateUser:: Password does not match");
                return false;
            }
        } else if (!configuredPassword.equals(password) || !configuredUser.equals(user)) {
            debug.error("DefaultAuthenticator.validateUser:: Password does not match");
            return false;
        }
        subject = this.addPrincipal(user, subject);
        WSSUtils.setRoles(subject, user);
        return true;
    }

    private boolean authenticateUser(UserNameToken usernameToken, Subject subject, String authChain) throws SecurityException {
        String user = usernameToken.getUserName();
        String password = usernameToken.getPassword();
        if (user == null || password == null) {
            return false;
        }
        AuthContext ac = null;
        AuthContext.IndexType indexType = AuthContext.IndexType.SERVICE;
        String indexName = authChain;
        try {
            ac = new AuthContext("/");
            debug.message("authenticateUser: Obtained AuthContext");
            ac.login(indexType, indexName);
        }
        catch (AuthLoginException le) {
            debug.error("authenticateUser: Login error : " + le.getMessage());
            return false;
        }
        Callback[] callbacks = null;
        while (ac.hasMoreRequirements()) {
            callbacks = ac.getRequirements();
            if (callbacks == null) continue;
            try {
                DefaultAuthenticator.addLoginCallbackMessage(callbacks, user, password, null);
                ac.submitRequirements(callbacks);
            }
            catch (Exception e) {
                debug.error("authenticateUser: Submit error : " + e.getMessage());
                return false;
            }
        }
        SSOToken ssotoken = null;
        if (ac.getStatus() == AuthContext.Status.SUCCESS) {
            debug.message("authenticateUser: Login success!!");
            try {
                ssotoken = ac.getSSOToken();
                debug.message("authenticateUser: got SSOToken successfully");
            }
            catch (Exception ex) {
                if (debug.messageEnabled()) {
                    debug.message("authenticateUser: SSOToken error : " + ex.getMessage());
                }
            }
        } else {
            if (ac.getStatus() == AuthContext.Status.FAILED) {
                debug.error("authenticateUser: Login Failed.");
                return false;
            }
            debug.error("authenticateUser: Unknown status : " + ac.getStatus());
            return false;
        }
        subject = this.addPrincipal(user, subject);
        WSSUtils.setRoles(subject, user);
        this.addSSOToken(ssotoken, subject);
        return true;
    }

    private boolean authenticateCert(String certAlias, String authChain, X509Certificate cert, Subject subject) throws SecurityException {
        if (certAlias == null || certAlias.length() == 0) {
            return false;
        }
        if (debug.messageEnabled()) {
            debug.message("authenticateCert: certAlias : " + certAlias);
        }
        AuthContext ac = null;
        AuthContext.IndexType indexType = AuthContext.IndexType.SERVICE;
        String indexName = authChain;
        try {
            ac = new AuthContext("/", certAlias);
            debug.message("authenticateCert: Obtained AuthContext");
            ac.login(indexType, indexName);
        }
        catch (AuthLoginException le) {
            debug.error("authenticateCert: Login error : " + le.getMessage());
            return false;
        }
        Callback[] callbacks = null;
        while (ac.hasMoreRequirements()) {
            callbacks = ac.getRequirements();
            if (callbacks == null) continue;
            try {
                DefaultAuthenticator.addLoginCallbackMessage(callbacks, null, null, cert);
                ac.submitRequirements(callbacks);
            }
            catch (Exception e) {
                debug.error("authenticateCert: Submit error : " + e.getMessage());
                return false;
            }
        }
        SSOToken ssotoken = null;
        if (ac.getStatus() == AuthContext.Status.SUCCESS) {
            debug.message("authenticateCert: Login success!!");
            try {
                ssotoken = ac.getSSOToken();
                debug.message("authenticateCert: got SSOToken successfully");
            }
            catch (Exception ex) {
                if (debug.messageEnabled()) {
                    debug.message("authenticateCert: SSOToken error : " + ex.getMessage());
                }
            }
        } else {
            if (ac.getStatus() == AuthContext.Status.FAILED) {
                debug.error("authenticateCert: Login Failed.");
                return false;
            }
            debug.error("authenticateCert: Unknown status : " + ac.getStatus());
            return false;
        }
        this.addSSOToken(ssotoken, subject);
        return true;
    }

    private boolean validateAssertion(Assertion assertion, Subject subject) throws SecurityException {
        if (assertion.getConditions() != null && !assertion.getConditions().checkDateValidity(System.currentTimeMillis())) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.validateAssertionToken::  assertion time is not valid");
            }
            return false;
        }
        com.sun.identity.saml.assertion.Subject sub = null;
        for (Statement st : assertion.getStatement()) {
            if (1 == st.getStatementType()) {
                AuthenticationStatement authStatement = (AuthenticationStatement)st;
                sub = authStatement.getSubject();
                break;
            }
            if (3 != st.getStatementType()) continue;
            AttributeStatement attribStatement = (AttributeStatement)st;
            sub = attribStatement.getSubject();
            break;
        }
        if (sub == null) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.validateAssertionToken:: Assertion does not have subject");
            }
            return false;
        }
        NameIdentifier ni = sub.getNameIdentifier();
        if (ni == null) {
            return false;
        }
        subject = this.addPrincipal(ni.getName(), subject);
        WSSUtils.setRoles(subject, ni.getName());
        return true;
    }

    private Object authenticateLibertyMessage(Object message, Subject subject) throws SecurityException {
        if (message == null || subject == null) {
            throw new IllegalArgumentException(bundle.getString("nullInput"));
        }
        Message requestMsg = (Message)message;
        SecurityAssertion assertion = requestMsg.getAssertion();
        if (assertion != null) {
            if (!this.validateAssertion((Assertion)assertion, subject)) {
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
            return subject;
        }
        X509Certificate messageCert = requestMsg.getMessageCertificate();
        if (messageCert == null) {
            throw new SecurityException(bundle.getString("authenticationFailed"));
        }
        String subjectDN = messageCert.getSubjectDN().getName();
        SecurityPrincipal principal = new SecurityPrincipal(subjectDN);
        subject.getPrincipals().add(principal);
        return subject;
    }

    private void addSSOToken(final SSOToken ssoToken, final Subject subj) throws SecurityException {
        if (ssoToken != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        subj.getPrivateCredentials().add(ssoToken);
                        return null;
                    }
                });
                debug.message("Set SSOToken in Subject successfully");
            }
            catch (Exception e) {
                debug.message("Can not set SSOToken in Subject");
                throw new SecurityException(e.getMessage());
            }
        }
    }

    private Subject addPrincipal(String principalName, Subject subject) {
        SecurityPrincipal principal = new SecurityPrincipal(principalName);
        subject.getPrincipals().add(principal);
        return subject;
    }

    static void addLoginCallbackMessage(Callback[] callbacks, String userName, String password, X509Certificate cert) throws UnsupportedCallbackException {
        int i = 0;
        try {
            for (i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(userName.trim());
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(password.toCharArray());
                    continue;
                }
                if (!(callbacks[i] instanceof X509CertificateCallback)) continue;
                X509CertificateCallback certCB = (X509CertificateCallback)callbacks[i];
                try {
                    certCB.setReqSignature(false);
                    certCB.setCertificate(cert);
                    continue;
                }
                catch (Exception e) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("createX509CertificateCallback : " + e.toString());
                }
            }
        }
        catch (Exception e) {
            throw new UnsupportedCallbackException(callbacks[i], "Callback exception: " + e);
        }
    }
}

