/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.SignatureProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.AMTokenProvider;
import com.sun.identity.wss.security.AssertionToken;
import com.sun.identity.wss.security.BinarySecurityToken;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityPrincipal;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.xmlenc.WSSEncryptionProvider;
import com.sun.identity.wss.xmlsig.WSSSignatureProvider;
import com.sun.identity.xmlenc.EncryptionProvider;
import com.sun.identity.xmlenc.XMLEncryptionManager;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSSUtils {
    public static ResourceBundle bundle = null;
    public static Debug debug = Debug.getInstance((String)"fmWebServicesSecurity");
    private static XMLSignatureManager xmlSigManager = null;
    private static XMLEncryptionManager xmlEncManager = null;

    public static X509Certificate getCertificate(SecurityToken securityToken) throws SecurityException {
        String tokenType = securityToken.getTokenType();
        if (tokenType.equals("urn:sun:wss:samltoken")) {
            Element keyInfo = null;
            AssertionToken assertionToken = (AssertionToken)securityToken;
            if (!assertionToken.isSenderVouches()) {
                Assertion assertion = assertionToken.getAssertion();
                keyInfo = WSSUtils.getKeyInfo(assertion);
                return WSSUtils.getCertificate(keyInfo);
            }
        } else if (tokenType.equals("urn:sun:wss:x509token")) {
            BinarySecurityToken binaryToken = (BinarySecurityToken)securityToken;
            String certValue = binaryToken.getTokenValue();
            StringBuffer xml = new StringBuffer(100);
            xml.append("-----BEGIN CERTIFICATE-----\n");
            xml.append(certValue);
            xml.append("\n-----END CERTIFICATE-----");
            byte[] bytevalue = xml.toString().getBytes();
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream bais = new ByteArrayInputStream(bytevalue);
                return (X509Certificate)cf.generateCertificate(bais);
            }
            catch (Exception ex) {
                debug.error("WSSUtils.getCertificate:: Unable to retrieve  certificate from the binary token", (Throwable)ex);
                throw new SecurityException(bundle.getString("cannotRetrieveCert"));
            }
        }
        return null;
    }

    private static Element getKeyInfo(Assertion assertion) {
        try {
            AuthenticationStatement authStatement = null;
            AttributeStatement attributeStatement = null;
            Subject subject = null;
            Set statements = assertion.getStatement();
            if (statements == null) {
                debug.error("Assertion does not contain any Statement.");
            }
            if (!statements.isEmpty()) {
                for (Statement statement : statements) {
                    if (statement.getStatementType() == 1) {
                        authStatement = (AuthenticationStatement)statement;
                        subject = authStatement.getSubject();
                        break;
                    }
                    if (statement.getStatementType() != 3) continue;
                    attributeStatement = (AttributeStatement)statement;
                    subject = attributeStatement.getSubject();
                }
            }
            SubjectConfirmation subConfirm = subject.getSubjectConfirmation();
            return subConfirm.getKeyInfo();
        }
        catch (Exception e) {
            debug.error("getCertificate Exception: ", (Throwable)e);
            return null;
        }
    }

    public static X509Certificate getCertificate(Element keyinfo) {
        Element x509;
        X509Certificate cert = null;
        if (debug.messageEnabled()) {
            debug.message("KeyInfo = " + XMLUtils.print((Node)keyinfo));
        }
        if ((x509 = (Element)keyinfo.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0)) == null) {
            try {
                PublicKey pk = WSSUtils.getPublicKey(keyinfo);
                cert = (X509Certificate)AMTokenProvider.getKeyProvider().getCertificate(pk);
            }
            catch (Exception e) {
                debug.error("getCertificate Exception: ", (Throwable)e);
            }
        } else {
            String certString = x509.getChildNodes().item(0).getNodeValue();
            cert = WSSUtils.getCertificate(certString, null);
        }
        return cert;
    }

    private static PublicKey getPublicKey(Element reference) throws XMLSignatureException {
        PublicKey pubKey = null;
        Document doc = reference.getOwnerDocument();
        Element dsaKey = (Element)reference.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue").item(0);
        if (dsaKey != null) {
            NodeList nodes = dsaKey.getChildNodes();
            int nodeCount = nodes.getLength();
            if (nodeCount > 0) {
                BigInteger p = null;
                BigInteger q = null;
                BigInteger g = null;
                BigInteger y = null;
                for (int i = 0; i < nodeCount; ++i) {
                    Node currentNode = nodes.item(i);
                    if (currentNode.getNodeType() != 1) continue;
                    String tagName = currentNode.getLocalName();
                    Node sub = currentNode.getChildNodes().item(0);
                    String value = sub.getNodeValue();
                    value = SAMLUtils.removeNewLineChars((String)value);
                    BigInteger v = new BigInteger(Base64.decode((String)value));
                    if (tagName.equals("P")) {
                        p = v;
                        continue;
                    }
                    if (tagName.equals("Q")) {
                        q = v;
                        continue;
                    }
                    if (tagName.equals("G")) {
                        g = v;
                        continue;
                    }
                    if (tagName.equals("Y")) {
                        y = v;
                        continue;
                    }
                    throw new XMLSignatureException("Invalid reference");
                }
                DSAKeyValue dsaKeyValue = new DSAKeyValue(doc, p, q, g, y);
                try {
                    pubKey = dsaKeyValue.getPublicKey();
                }
                catch (XMLSecurityException xse) {
                    debug.error("Could not get Public Key from DSA key value.");
                    throw new XMLSignatureException(bundle.getString("errorObtainPK"));
                }
            }
        } else {
            Element rsaKey = (Element)reference.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue").item(0);
            if (rsaKey != null) {
                NodeList nodes = rsaKey.getChildNodes();
                int nodeCount = nodes.getLength();
                BigInteger m = null;
                BigInteger e = null;
                if (nodeCount > 0) {
                    for (int i = 0; i < nodeCount; ++i) {
                        Node currentNode = nodes.item(i);
                        if (currentNode.getNodeType() != 1) continue;
                        String tagName = currentNode.getLocalName();
                        Node sub = currentNode.getChildNodes().item(0);
                        String value = sub.getNodeValue();
                        value = SAMLUtils.removeNewLineChars((String)value);
                        BigInteger v = new BigInteger(Base64.decode((String)value));
                        if (tagName.equals("Exponent")) {
                            e = v;
                            continue;
                        }
                        if (tagName.equals("Modulus")) {
                            m = v;
                            continue;
                        }
                        throw new XMLSignatureException("Invalid reference");
                    }
                }
                RSAKeyValue rsaKeyValue = new RSAKeyValue(doc, m, e);
                try {
                    pubKey = rsaKeyValue.getPublicKey();
                }
                catch (XMLSecurityException ex) {
                    debug.error("Could not get Public Key from RSA key value.");
                    throw new XMLSignatureException(bundle.getString("errorObtainPK"));
                }
            }
        }
        return pubKey;
    }

    /*
     * WARNING - void declaration
     */
    private static X509Certificate getCertificate(String certString, String format) {
        void var2_7;
        Object var2_2 = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("getCertificate(Assertion) : " + certString);
            }
            StringBuffer xml = new StringBuffer(100);
            xml.append("-----BEGIN CERTIFICATE-----\n");
            xml.append(certString);
            xml.append("\n-----END CERTIFICATE-----");
            byte[] barr = null;
            barr = xml.toString().getBytes();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(barr);
            if (format != null && format.equals("wsse:PKCS7")) {
                Collection<? extends Certificate> c = cf.generateCertificates(bais);
                for (X509Certificate x509Certificate : c) {
                }
            } else {
                while (bais.available() > 0) {
                    X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(bais);
                }
            }
        }
        catch (Exception e) {
            debug.error("getCertificate Exception: ", (Throwable)e);
        }
        return var2_7;
    }

    public static SOAPMessage toSOAPMessage(Document document) {
        try {
            MessageFactory msgFactory = MessageFactory.newInstance();
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", "text/xml");
            String xmlStr = WSSUtils.print(document);
            return msgFactory.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(xmlStr.getBytes("UTF-8")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String print(Node node) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(node);
            ByteArrayOutputStream os = new ByteArrayOutputStream(2000);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            return os.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Element prependChildElement(Element parent, Element child, boolean addWhitespace, Document doc) {
        Node firstChild = parent.getFirstChild();
        if (firstChild == null) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, firstChild);
        }
        if (addWhitespace) {
            Text whitespaceText = doc.createTextNode("\n");
            parent.insertBefore(whitespaceText, child);
        }
        return child;
    }

    public static Node getDirectChild(Node fNode, String localName, String namespace) {
        for (Node currentChild = fNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!localName.equals(currentChild.getLocalName()) || !namespace.equals(currentChild.getNamespaceURI())) continue;
            return currentChild;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XMLEncryptionManager getXMLEncryptionManager() {
        if (xmlEncManager != null) return xmlEncManager;
        Class<XMLEncryptionManager> clazz = XMLEncryptionManager.class;
        synchronized (XMLEncryptionManager.class) {
            if (xmlEncManager != null) return xmlEncManager;
            xmlEncManager = XMLEncryptionManager.getInstance((EncryptionProvider)new WSSEncryptionProvider(), (KeyProvider)new JKSKeyProvider());
            // ** MonitorExit[var0] (shouldn't be in output)
            return xmlEncManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XMLSignatureManager getXMLSignatureManager() {
        if (xmlSigManager != null) return xmlSigManager;
        Class<XMLSignatureManager> clazz = XMLSignatureManager.class;
        synchronized (XMLSignatureManager.class) {
            if (xmlSigManager != null) return xmlSigManager;
            xmlSigManager = XMLSignatureManager.getInstance((KeyProvider)new JKSKeyProvider(), (SignatureProvider)new WSSSignatureProvider());
            // ** MonitorExit[var0] (shouldn't be in output)
            return xmlSigManager;
        }
    }

    public static String getAuthMethodURI(String authModuleName) {
        if (authModuleName == null) {
            return null;
        }
        if (authModuleName.equalsIgnoreCase("Cert")) {
            return "urn:ietf:rfc:2246";
        }
        if (authModuleName.equalsIgnoreCase("Kerberos")) {
            return "urn:ietf:rfc:1510";
        }
        if (SAMLConstants.passwordAuthMethods.contains(authModuleName.toLowerCase())) {
            return "urn:oasis:names:tc:SAML:1.0:am:password";
        }
        if (SAMLConstants.tokenAuthMethods.contains(authModuleName.toLowerCase())) {
            return "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("urn:com:sun:identity:").append(authModuleName);
        return sb.toString();
    }

    public static void setRoles(javax.security.auth.Subject subject, String user) {
        List roles = WSSUtils.getMemberShips(user);
        if (roles == null || roles.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("WSSUtils.setRoles:: There are no memberships for this user");
            }
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("WSSUtils.setRoles:: " + roles);
        }
        for (String roleName : roles) {
            SecurityPrincipal principal = new SecurityPrincipal(roleName);
            subject.getPrincipals().add(principal);
        }
    }

    public static List getMemberShips(String pattern) {
        ArrayList<String> roles = new ArrayList<String>();
        try {
            SSOToken adminToken = WSSUtils.getAdminToken();
            if (adminToken == null) {
                debug.message("WSSUtils.getRoleMemberShips: Admin Token is null");
                return roles;
            }
            AMIdentity user = new AMIdentity(adminToken, pattern);
            if (user == null) {
                if (debug.messageEnabled()) {
                    debug.message("WSSUtils.getMemberShips: unable to get the user");
                }
                return roles;
            }
            AMIdentityRepository idRepo = new AMIdentityRepository(adminToken, user.getRealm());
            Set supportedTypes = idRepo.getSupportedIdTypes();
            HashSet<IdType> enrolledTypes = new HashSet<IdType>();
            for (IdType idType : supportedTypes) {
                Set canHaveMembers = idType.canHaveMembers();
                if (canHaveMembers.isEmpty()) continue;
                enrolledTypes.add(idType);
            }
            if (enrolledTypes.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("WSSUtils.getMemberShips: Can have enrolled types are empty");
                }
                return roles;
            }
            for (IdType idType : enrolledTypes) {
                Set roleMemberships = user.getMemberships(idType);
                for (AMIdentity role : roleMemberships) {
                    roles.add(role.getUniversalId());
                }
            }
            return roles;
        }
        catch (SSOException se) {
            debug.message("WSSUtils.getRoleMemberShips: SSOException : " + (Object)((Object)se));
        }
        catch (IdRepoException ire) {
            debug.message("WSSUtils.getRoleMemberShips: IdRepoException : " + (Object)((Object)ire));
        }
        return roles;
    }

    public static SSOToken getAdminToken() {
        SSOToken adminToken = null;
        try {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            if (adminToken != null) {
                SSOTokenManager.getInstance().refreshSession(adminToken);
            }
        }
        catch (Exception se) {
            debug.message("WSSUtils.getAdminToken::Trying second time ....");
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return adminToken;
    }

    static {
        bundle = Locale.getInstallResourceBundle((String)"fmWSSecurity");
    }
}

