/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.provider.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.provider.ProviderUtils;
import com.sun.identity.wss.provider.STSConfig;
import com.sun.identity.wss.security.PasswordCredential;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class STSAgent
extends STSConfig {
    private static Set attrNames = new HashSet();
    private static final String AGENT_PASSWORD_ATTR = "userpassword";
    private static final String AGENT_DEVICE_STATUS_ATTR = "sunIdentityServerDeviceStatus";
    private static final String AGENT_TYPE_ATTR = "AgentType";
    private static final String ENDPOINT = "STSEndpoint";
    private static final String MEX_ENDPOINT = "STSMexEndpoint";
    private static final String SEC_MECH = "SecurityMech";
    private static final String RESPONSE_SIGN = "isResponseSign";
    private static final String RESPONSE_ENCRYPT = "isResponseEncrypt";
    private static final String REQUEST_SIGN = "isRequestSign";
    private static final String REQUEST_ENCRYPT = "isRequestEncrypt";
    private static final String REQUEST_HEADER_ENCRYPT = "isRequestHeaderEncrypt";
    private static final String USER_NAME = "UserName";
    private static final String USER_PASSWORD = "UserPassword";
    private static final String USER_CREDENTIAL = "UserCredential";
    private static final String STS_CONFIG = "STS";
    private static final String PRIVATE_KEY_ALIAS = "privateKeyAlias";
    private static final String PUBLIC_KEY_ALIAS = "publicKeyAlias";
    private static Debug debug = ProviderUtils.debug;
    private AMIdentityRepository idRepo;
    private boolean profilePresent = false;
    private SSOToken token = null;

    public STSAgent() {
    }

    public STSAgent(AMIdentity amIdentity) throws ProviderException {
        try {
            this.name = amIdentity.getName();
            this.type = amIdentity.getType().getName();
            Map attributes = amIdentity.getAttributes(attrNames);
            this.parseAgentKeyValues(attributes);
        }
        catch (IdRepoException ire) {
            debug.error("STSAgent.constructor: Idrepo exception", (Throwable)ire);
            throw new ProviderException(ire.getMessage());
        }
        catch (SSOException se) {
            debug.error("STSAgent.constructor: SSO exception", (Throwable)se);
            throw new ProviderException(se.getMessage());
        }
    }

    public void init(String name, String type, SSOToken token) throws ProviderException {
        this.name = name;
        this.type = type;
        this.token = token;
        try {
            if (this.idRepo == null) {
                this.idRepo = new AMIdentityRepository(token, "/");
            }
            IdSearchControl control = new IdSearchControl();
            control.setAllReturnAttributes(true);
            IdSearchResults results = this.idRepo.searchIdentities(IdType.AGENTONLY, name, control);
            Set agents = results.getSearchResults();
            if (!agents.isEmpty()) {
                AMIdentity provider = (AMIdentity)agents.iterator().next();
                this.profilePresent = true;
                Map attributes = provider.getAttributes(attrNames);
                this.parseAgentKeyValues(attributes);
            }
        }
        catch (Exception e) {
            debug.error("STSAgent.init: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    private void parseAgentKeyValues(Map attributes) throws ProviderException {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (String key : attributes.keySet()) {
            Set valSet = (Set)attributes.get(key);
            String value = null;
            if (valSet != null && valSet.size() > 0) {
                Iterator iter = valSet.iterator();
                StringBuffer sb = new StringBuffer(100);
                while (iter.hasNext()) {
                    sb.append((String)iter.next()).append(",");
                }
                sb = sb.deleteCharAt(sb.length() - 1);
                value = sb.toString();
            }
            this.setConfig(key, value);
        }
    }

    private void setConfig(String attr, String value) {
        block9: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block10: {
                                                    block8: {
                                                        if (debug.messageEnabled()) {
                                                            debug.message("Attribute name: " + attr + " Value: " + value);
                                                        }
                                                        if (!attr.equals(ENDPOINT)) break block8;
                                                        this.endpoint = value;
                                                        break block9;
                                                    }
                                                    if (!attr.equals(MEX_ENDPOINT)) break block10;
                                                    this.mexEndpoint = value;
                                                    break block9;
                                                }
                                                if (!attr.equals(SEC_MECH)) break block11;
                                                if (this.secMech == null) {
                                                    this.secMech = new ArrayList();
                                                }
                                                StringTokenizer st = new StringTokenizer(value, ",");
                                                while (st.hasMoreTokens()) {
                                                    this.secMech.add(st.nextToken());
                                                }
                                                break block9;
                                            }
                                            if (!attr.equals(RESPONSE_SIGN)) break block12;
                                            this.isResponseSigned = Boolean.valueOf(value);
                                            break block9;
                                        }
                                        if (!attr.equals(RESPONSE_ENCRYPT)) break block13;
                                        this.isResponseEncrypted = Boolean.valueOf(value);
                                        break block9;
                                    }
                                    if (!attr.equals(REQUEST_SIGN)) break block14;
                                    this.isRequestSigned = Boolean.valueOf(value);
                                    break block9;
                                }
                                if (!attr.equals(REQUEST_ENCRYPT)) break block15;
                                this.isRequestEncrypted = Boolean.valueOf(value);
                                break block9;
                            }
                            if (!attr.equals(REQUEST_HEADER_ENCRYPT)) break block16;
                            this.isRequestHeaderEncrypted = Boolean.valueOf(value);
                            break block9;
                        }
                        if (!attr.equals(PRIVATE_KEY_ALIAS)) break block17;
                        this.privateKeyAlias = value;
                        break block9;
                    }
                    if (!attr.equals(STS_CONFIG)) break block18;
                    this.stsConfigName = value;
                    break block9;
                }
                if (!attr.equals(PUBLIC_KEY_ALIAS)) break block19;
                this.publicKeyAlias = value;
                break block9;
            }
            if (!attr.equals(USER_CREDENTIAL) || value == null || value.length() == 0) break block9;
            if (this.usercredentials == null) {
                this.usercredentials = new ArrayList();
            }
            StringTokenizer stVal = new StringTokenizer(value, ",");
            while (stVal.hasMoreTokens()) {
                StringTokenizer st1;
                String tmpVal = stVal.nextToken();
                int index = tmpVal.indexOf("|");
                if (index == -1) {
                    return;
                }
                String usertmp = tmpVal.substring(0, index);
                String passwordtmp = tmpVal.substring(index + 1, tmpVal.length());
                String user = null;
                String password = null;
                StringTokenizer st = new StringTokenizer(usertmp, ":");
                if (USER_NAME.equals(st.nextToken()) && st.hasMoreTokens()) {
                    user = st.nextToken();
                }
                if (USER_PASSWORD.equals((st1 = new StringTokenizer(passwordtmp, ":")).nextToken()) && st1.hasMoreTokens()) {
                    password = st1.nextToken();
                }
                if (user == null || password == null) continue;
                PasswordCredential credential = new PasswordCredential(user, password);
                this.usercredentials.add(credential);
            }
        }
    }

    public void delete() throws ProviderException {
        if (!this.profilePresent) {
            return;
        }
        try {
            if (this.idRepo == null) {
                this.idRepo = new AMIdentityRepository(this.token, "/");
            }
            AMIdentity id = new AMIdentity(this.token, this.name, IdType.AGENTONLY, "/", null);
            HashSet<AMIdentity> identities = new HashSet<AMIdentity>();
            identities.add(id);
            this.idRepo.deleteIdentities(identities);
        }
        catch (Exception e) {
            debug.error("STSAgent.delete: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    public void store() throws ProviderException {
        Iterator iter;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(AGENT_TYPE_ATTR, this.type);
        config.put(AGENT_PASSWORD_ATTR, this.name);
        config.put(AGENT_DEVICE_STATUS_ATTR, "Active");
        if (this.endpoint != null) {
            config.put(ENDPOINT, this.endpoint);
        }
        if (this.mexEndpoint != null) {
            config.put(MEX_ENDPOINT, this.mexEndpoint);
        }
        if (this.privateKeyAlias != null) {
            config.put(PRIVATE_KEY_ALIAS, this.privateKeyAlias);
        }
        if (this.publicKeyAlias != null) {
            config.put(PUBLIC_KEY_ALIAS, this.publicKeyAlias);
        }
        if (this.stsConfigName != null) {
            config.put(STS_CONFIG, this.stsConfigName);
        }
        HashSet<String> secMechSet = new HashSet<String>();
        if (this.secMech != null) {
            iter = this.secMech.iterator();
            while (iter.hasNext()) {
                secMechSet.add((String)iter.next());
            }
        }
        config.put(RESPONSE_SIGN, Boolean.toString(this.isResponseSigned));
        config.put(RESPONSE_ENCRYPT, Boolean.toString(this.isResponseEncrypted));
        config.put(REQUEST_SIGN, Boolean.toString(this.isRequestSigned));
        config.put(REQUEST_ENCRYPT, Boolean.toString(this.isRequestEncrypted));
        config.put(REQUEST_HEADER_ENCRYPT, Boolean.toString(this.isRequestHeaderEncrypted));
        if (this.usercredentials != null) {
            iter = this.usercredentials.iterator();
            StringBuffer sb = new StringBuffer(100);
            while (iter.hasNext()) {
                PasswordCredential cred = (PasswordCredential)iter.next();
                String user = cred.getUserName();
                String password = cred.getPassword();
                if (user == null || password == null) continue;
                sb.append(USER_NAME).append(":").append(user).append("|").append(USER_PASSWORD).append(":").append(password).append(",");
            }
            sb = sb.deleteCharAt(sb.length() - 1);
            config.put(USER_CREDENTIAL, sb.toString());
        }
        try {
            HashMap attributes = new HashMap();
            HashSet<String> values = null;
            for (String key : config.keySet()) {
                String value = (String)config.get(key);
                values = new HashSet<String>();
                values.add(value);
                attributes.put(key, values);
            }
            if (secMechSet != null) {
                attributes.put(SEC_MECH, secMechSet);
            }
            if (this.profilePresent) {
                attributes.remove(AGENT_TYPE_ATTR);
                AMIdentity id = new AMIdentity(this.token, this.name, IdType.AGENTONLY, "/", null);
                if (debug.messageEnabled()) {
                    debug.message("Attributes to be stored: " + attributes);
                }
                id.setAttributes(attributes);
                id.store();
            } else {
                if (this.idRepo == null) {
                    this.idRepo = new AMIdentityRepository(this.token, "/");
                }
                this.idRepo.createIdentity(IdType.AGENTONLY, this.name, attributes);
            }
        }
        catch (Exception e) {
            debug.error("STSAgent.store: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    private String getKeyValue(String key, String value) {
        return key + "=" + value;
    }

    static {
        attrNames.add(ENDPOINT);
        attrNames.add(MEX_ENDPOINT);
        attrNames.add(SEC_MECH);
        attrNames.add(RESPONSE_SIGN);
        attrNames.add(RESPONSE_ENCRYPT);
        attrNames.add(REQUEST_SIGN);
        attrNames.add(REQUEST_ENCRYPT);
        attrNames.add(REQUEST_HEADER_ENCRYPT);
        attrNames.add(USER_CREDENTIAL);
        attrNames.add(STS_CONFIG);
        attrNames.add(PRIVATE_KEY_ALIAS);
        attrNames.add(PUBLIC_KEY_ALIAS);
    }
}

