/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.plugins;

import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.wsfederation.plugins.DefaultLibrarySPAccountMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DefaultADFSPartnerAccountMapper
extends DefaultLibrarySPAccountMapper {
    private String UID = "uid";

    public DefaultADFSPartnerAccountMapper() {
        debug.message("DefaultADFSPartnerAccountMapper.constructor: ");
    }

    protected Map getSearchParameters(NameIdentifier nameID, String hostEntityID, String remoteEntityID) {
        String classMethod = "DefaultADFSPartnerAccountMapper.getSearchParameters";
        HashMap keyMap = new HashMap();
        String upn = nameID.getName();
        if (upn != null && upn.length() > 0) {
            int atSign = upn.indexOf(64);
            if (atSign == -1) {
                debug.error(classMethod + "No @ in name");
            } else {
                String name = upn.substring(0, atSign);
                String domain = upn.substring(atSign + 1);
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "name is " + name);
                    debug.message(classMethod + "domain is " + domain);
                }
                HashSet<String> set = new HashSet<String>();
                set.add(name);
                keyMap.put(this.UID, set);
            }
        } else {
            debug.error(classMethod + "name is null");
        }
        return keyMap;
    }

    protected boolean isDynamicalOrIgnoredProfile(String realm) {
        try {
            OrganizationConfigManager orgConfigMgr = AuthD.getAuth().getOrgConfigManager(realm);
            ServiceConfig svcConfig = orgConfigMgr.getServiceConfig("iPlanetAMAuthService");
            Map attrs = svcConfig.getAttributes();
            String tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-dynamic-profile-creation");
            if (debug.messageEnabled()) {
                debug.message("dynamicalCreationEnabled, attr=" + tmp);
            }
            return tmp != null && (tmp.equalsIgnoreCase("createAlias") || tmp.equalsIgnoreCase("true") || tmp.equalsIgnoreCase("ignore"));
        }
        catch (Exception e) {
            debug.error("dynamicalCreationEnabled, unable to get attribute", (Throwable)e);
            return false;
        }
    }
}

