/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.wsfederation.common.WSFederationConstants;
import com.sun.identity.wsfederation.jaxb.entityconfig.AttributeElement;
import com.sun.identity.wsfederation.jaxb.entityconfig.FederationConfigElement;
import com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.ClaimType;
import com.sun.identity.wsfederation.jaxb.wsfederation.DisplayNameType;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.SingleSignOutNotificationEndpointElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenIssuerEndpointElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenIssuerNameElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenSigningKeyInfoElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenType;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenTypesOfferedElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.UriNamedClaimTypesOfferedElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.CertificateEncodingException;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityTokenReference;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityTokenReferenceType;
import org.w3._2000._09.xmldsig_.ObjectFactory;
import org.w3._2000._09.xmldsig_.X509Data;
import org.w3._2000._09.xmldsig_.X509DataType;
import org.w3._2005._08.addressing.AttributedURIType;

public class CreateWSFedMetaDataTemplate {
    private CreateWSFedMetaDataTemplate() {
    }

    public static String createStandardMetaTemplate(String entityId, Map mapParams, String url) throws JAXBException, CertificateEncodingException {
        String spAlias;
        JAXBContext jc = WSFederationMetaUtils.getMetaJAXBContext();
        com.sun.identity.wsfederation.jaxb.wsfederation.ObjectFactory objFactory = new com.sun.identity.wsfederation.jaxb.wsfederation.ObjectFactory();
        FederationElement fed = objFactory.createFederationElement();
        fed.setFederationID(entityId);
        String idpAlias = (String)mapParams.get("idp");
        if (idpAlias != null) {
            CreateWSFedMetaDataTemplate.addWSFedIdentityProviderTemplate(entityId, objFactory, fed, mapParams, url);
        }
        if ((spAlias = (String)mapParams.get("sp")) != null) {
            CreateWSFedMetaDataTemplate.addWSFedServiceProviderTemplate(entityId, objFactory, fed, mapParams, url);
        }
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter pw = new StringWriter();
        m.marshal((Object)fed, (Writer)pw);
        return pw.toString();
    }

    private static void addWSFedIdentityProviderTemplate(String entityId, com.sun.identity.wsfederation.jaxb.wsfederation.ObjectFactory objFactory, FederationElement fed, Map mapParams, String url) throws JAXBException, CertificateEncodingException {
        if (url == null) {
            url = CreateWSFedMetaDataTemplate.getHostURL();
        }
        String idpAlias = (String)mapParams.get("idp");
        String idpSCertAlias = (String)mapParams.get("idpscert");
        String maStr = CreateWSFedMetaDataTemplate.buildMetaAliasInURI(idpAlias);
        if (idpSCertAlias != null && idpSCertAlias.length() > 0) {
            org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory secextObjFactory = new org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory();
            ObjectFactory dsObjectFactory = new ObjectFactory();
            TokenSigningKeyInfoElement tski = objFactory.createTokenSigningKeyInfoElement();
            SecurityTokenReference str = secextObjFactory.createSecurityTokenReference();
            X509Data x509Data = dsObjectFactory.createX509Data();
            X509DataType.X509Certificate x509Cert = dsObjectFactory.createX509DataTypeX509Certificate();
            x509Cert.setValue(KeyUtil.getKeyProviderInstance().getX509Certificate(idpSCertAlias).getEncoded());
            x509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(x509Cert);
            str.getAny().add(x509Data);
            tski.setSecurityTokenReference((SecurityTokenReferenceType)str);
            fed.getAny().add(tski);
        }
        TokenIssuerNameElement tin = objFactory.createTokenIssuerNameElement();
        tin.setValue(entityId);
        fed.getAny().add(tin);
        TokenIssuerEndpointElement tie = objFactory.createTokenIssuerEndpointElement();
        org.w3._2005._08.addressing.ObjectFactory addrObjFactory = new org.w3._2005._08.addressing.ObjectFactory();
        AttributedURIType auri = addrObjFactory.createAttributedURIType();
        auri.setValue(url + "/WSFederationServlet" + maStr);
        tie.setAddress(auri);
        fed.getAny().add(tie);
        TokenTypesOfferedElement tto = objFactory.createTokenTypesOfferedElement();
        TokenType tt = objFactory.createTokenType();
        tt.setUri("urn:oasis:names:tc:SAML:1.1");
        tto.getTokenType().add(tt);
        fed.getAny().add(tto);
        UriNamedClaimTypesOfferedElement uncto = objFactory.createUriNamedClaimTypesOfferedElement();
        ClaimType ct = objFactory.createClaimType();
        ct.setUri(WSFederationConstants.NAMED_CLAIM_TYPES[0]);
        DisplayNameType dnt = objFactory.createDisplayNameType();
        dnt.setValue(WSFederationConstants.NAMED_CLAIM_DISPLAY_NAMES[0]);
        ct.setDisplayName(dnt);
        uncto.getClaimType().add(ct);
        fed.getAny().add(uncto);
    }

    private static void addWSFedServiceProviderTemplate(String entityId, com.sun.identity.wsfederation.jaxb.wsfederation.ObjectFactory objFactory, FederationElement fed, Map mapParams, String url) throws JAXBException {
        if (url == null) {
            url = CreateWSFedMetaDataTemplate.getHostURL();
        }
        String spAlias = (String)mapParams.get("sp");
        String maStr = CreateWSFedMetaDataTemplate.buildMetaAliasInURI(spAlias);
        TokenIssuerNameElement tin = objFactory.createTokenIssuerNameElement();
        tin.setValue(entityId);
        fed.getAny().add(tin);
        TokenIssuerEndpointElement tie = objFactory.createTokenIssuerEndpointElement();
        org.w3._2005._08.addressing.ObjectFactory addrObjFactory = new org.w3._2005._08.addressing.ObjectFactory();
        AttributedURIType auri = addrObjFactory.createAttributedURIType();
        auri.setValue(url + "/WSFederationServlet" + maStr);
        tie.setAddress(auri);
        fed.getAny().add(tie);
        SingleSignOutNotificationEndpointElement ssne = objFactory.createSingleSignOutNotificationEndpointElement();
        AttributedURIType ssneUri = addrObjFactory.createAttributedURIType();
        ssneUri.setValue(url + "/WSFederationServlet" + maStr);
        ssne.setAddress(auri);
        fed.getAny().add(ssne);
    }

    public static String createExtendedMetaTemplate(String entityId, Map mapParams) throws JAXBException {
        String spAlias;
        JAXBContext jc = WSFederationMetaUtils.getMetaJAXBContext();
        com.sun.identity.wsfederation.jaxb.entityconfig.ObjectFactory objFactory = new com.sun.identity.wsfederation.jaxb.entityconfig.ObjectFactory();
        FederationConfigElement fedConfig = objFactory.createFederationConfigElement();
        fedConfig.setFederationID(entityId);
        fedConfig.setHosted(true);
        String idpAlias = (String)mapParams.get("idp");
        if (idpAlias != null) {
            CreateWSFedMetaDataTemplate.buildWSFedIDPConfigTemplate(objFactory, fedConfig, mapParams);
        }
        if ((spAlias = (String)mapParams.get("sp")) != null) {
            CreateWSFedMetaDataTemplate.buildWSFedSPConfigTemplate(objFactory, fedConfig, mapParams);
        }
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter pw = new StringWriter();
        m.marshal((Object)fedConfig, (Writer)pw);
        return pw.toString();
    }

    private static void buildWSFedIDPConfigTemplate(com.sun.identity.wsfederation.jaxb.entityconfig.ObjectFactory objFactory, FederationConfigElement fedConfig, Map mapParams) throws JAXBException {
        String idpAlias = (String)mapParams.get("idp");
        String idpSCertAlias = (String)mapParams.get("idpscert");
        String[][] configDefaults = new String[][]{{"displayName", idpAlias}, {"upnDomain", ""}, {"signingCertAlias", idpSCertAlias}, {"assertionNotBeforeTimeSkew", "600"}, {"assertionEffectiveTime", "600"}, {"idpAuthncontextMapper", "com.sun.identity.wsfederation.plugins.DefaultIDPAuthenticationMethodMapper"}, {"idpAccountMapper", "com.sun.identity.wsfederation.plugins.DefaultIDPAccountMapper"}, {"idpAttributeMapper", "com.sun.identity.wsfederation.plugins.DefaultIDPAttributeMapper"}, {"attributeMap", ""}, {"cotlist", null}};
        IDPSSOConfigElement idpSSOConfig = objFactory.createIDPSSOConfigElement();
        idpSSOConfig.setMetaAlias(idpAlias);
        for (int i = 0; i < configDefaults.length; ++i) {
            AttributeElement attribute = objFactory.createAttributeElement();
            attribute.setName(configDefaults[i][0]);
            if (configDefaults[i][1] != null) {
                attribute.getValue().add(configDefaults[i][1]);
            }
            idpSSOConfig.getAttribute().add(attribute);
        }
        fedConfig.getIDPSSOConfigOrSPSSOConfig().add(idpSSOConfig);
    }

    private static void buildWSFedSPConfigTemplate(com.sun.identity.wsfederation.jaxb.entityconfig.ObjectFactory objFactory, FederationConfigElement fedConfig, Map mapParams) throws JAXBException {
        String url = CreateWSFedMetaDataTemplate.getHostURL();
        String spAlias = (String)mapParams.get("sp");
        String spSCertAlias = (String)mapParams.get("spscert");
        String maStr = CreateWSFedMetaDataTemplate.buildMetaAliasInURI(spAlias);
        String[][] configDefaults = new String[][]{{"displayName", spAlias}, {"AccountRealmSelection", "cookie"}, {"AccountRealmCookieName", "amWSFederationAccountRealm"}, {"HomeRealmDiscoveryService", url + "/RealmSelection" + maStr}, {"signingCertAlias", spSCertAlias.length() > 0 ? spSCertAlias : ""}, {"assertionEffectiveTime", "600"}, {"spAccountMapper", "com.sun.identity.wsfederation.plugins.DefaultADFSPartnerAccountMapper"}, {"spAttributeMapper", "com.sun.identity.wsfederation.plugins.DefaultSPAttributeMapper"}, {"spAuthncontextMapper", "com.sun.identity.saml2.plugins.DefaultSPAuthnContextMapper"}, {"spAuthncontextClassrefMapping", "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport|0|default"}, {"spAuthncontextComparisonType", "exact"}, {"attributeMap", ""}, {"saml2AuthModuleName", ""}, {"defaultRelayState", ""}, {"assertionTimeSkew", "300"}, {"wantAssertionSigned", "true"}, {"cotlist", null}};
        SPSSOConfigElement spSSOConfig = objFactory.createSPSSOConfigElement();
        spSSOConfig.setMetaAlias(spAlias);
        for (int i = 0; i < configDefaults.length; ++i) {
            AttributeElement attribute = objFactory.createAttributeElement();
            attribute.setName(configDefaults[i][0]);
            if (configDefaults[i][1] != null) {
                attribute.getValue().add(configDefaults[i][1]);
            }
            spSSOConfig.getAttribute().add(attribute);
        }
        fedConfig.getIDPSSOConfigOrSPSSOConfig().add(spSSOConfig);
    }

    private static String getHostURL() {
        String protocol = SystemPropertiesManager.get((String)"com.iplanet.am.server.protocol");
        String host = SystemPropertiesManager.get((String)"com.iplanet.am.server.host");
        String port = SystemPropertiesManager.get((String)"com.iplanet.am.server.port");
        String deploymentURI = SystemPropertiesManager.get((String)"com.iplanet.am.services.deploymentDescriptor");
        return protocol + "://" + host + ":" + port + deploymentURI;
    }

    private static String buildMetaAliasInURI(String alias) {
        return "/metaAlias" + alias;
    }
}

