/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.workflow;

import com.sun.identity.cot.COTException;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.workflow.AddProviderToCOT;
import com.sun.identity.workflow.CreateSAML2HostedProviderTemplate;
import com.sun.identity.workflow.ImportSAML2MetaData;
import com.sun.identity.workflow.Task;
import com.sun.identity.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CreateHostedSP
extends Task {
    public String execute(Locale locale, Map params) throws WorkflowException {
        this.validateParameters(params);
        String metadataFile = this.getString(params, "metadata");
        String defAttrMappings = this.getString(params, "defaultattributemappings");
        boolean hasMetaData = metadataFile != null && metadataFile.trim().length() > 0;
        String metadata = null;
        String extendedData = null;
        if (hasMetaData) {
            String extendedDataFile = this.getString(params, "extendeddata");
            metadata = CreateHostedSP.getContent(metadataFile, locale);
            extendedData = CreateHostedSP.getContent(extendedDataFile, locale);
        } else {
            String entityId = this.getString(params, "entityId");
            String metaAlias = CreateHostedSP.generateMetaAliasForSP(this.getString(params, "realm"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sp", metaAlias);
            map.put("specert", this.getString(params, "idpecert"));
            try {
                metadata = CreateSAML2HostedProviderTemplate.buildMetaDataTemplate(entityId, map, this.getRequestURL(params));
                extendedData = CreateSAML2HostedProviderTemplate.createExtendedDataTemplate(entityId, map, this.getRequestURL(params));
            }
            catch (SAML2MetaException e) {
                return e.getMessage();
            }
        }
        String[] results = ImportSAML2MetaData.importData(null, metadata, extendedData);
        String realm = results[0];
        String entityId = results[1];
        String cot = this.getString(params, "cot");
        if (cot != null && cot.length() > 0) {
            try {
                AddProviderToCOT.addToCOT(realm, cot, entityId);
            }
            catch (COTException e) {
                throw new WorkflowException(e.getMessage());
            }
        }
        ArrayList<String> attrMapping = null;
        if (defAttrMappings.equals("true")) {
            attrMapping = new ArrayList<String>(1);
            attrMapping.add("*=*");
        } else {
            attrMapping = this.getAttributeMapping(params);
        }
        if (!attrMapping.isEmpty()) {
            try {
                SAML2MetaManager manager = new SAML2MetaManager();
                EntityConfigElement config = manager.getEntityConfig(realm, entityId);
                SPSSOConfigElement ssoConfig = manager.getSPSSOConfig(realm, entityId);
                Map attribConfig = SAML2MetaUtils.getAttributes((BaseConfigType)ssoConfig);
                List mappedAttributes = (List)attribConfig.get("attributeMap");
                mappedAttributes.addAll(attrMapping);
                manager.setEntityConfig(realm, config);
            }
            catch (SAML2MetaException e) {
                throw new WorkflowException(e.getMessage());
            }
        }
        return CreateHostedSP.getMessage("sp.configured", locale) + "|||realm=" + realm;
    }

    private String enableSigning(String metadata) {
        int idx = metadata.indexOf("WantAssertionsSigned=\"false\"");
        if (idx != -1) {
            metadata = metadata.substring(0, idx) + "WantAssertionsSigned=\"true\"" + metadata.substring(idx + 28);
        }
        return metadata;
    }

    private void validateParameters(Map params) throws WorkflowException {
        boolean hasExtendedData;
        String metadata = this.getString(params, "metadata");
        boolean hasMetaData = metadata != null && metadata.trim().length() > 0;
        String extendedData = this.getString(params, "extendeddata");
        boolean bl = hasExtendedData = extendedData != null && extendedData.trim().length() > 0;
        if (hasMetaData && !hasExtendedData || !hasMetaData && hasExtendedData) {
            throw new WorkflowException("both-meta-extended-data-required", null);
        }
        if (params.size() == 3 && params.containsKey("metadata") && params.containsKey("extendeddata") && !hasMetaData && !hasExtendedData) {
            throw new WorkflowException("both-meta-extended-data-required", null);
        }
        String cotname = this.getString(params, "cot");
        if (cotname == null || cotname.trim().length() == 0) {
            throw new WorkflowException("missing-cot", null);
        }
        if (!hasMetaData && !hasExtendedData) {
            String realm = this.getString(params, "realm");
            if (realm == null || realm.trim().length() == 0) {
                throw new WorkflowException("missing-realm", null);
            }
            String entityId = this.getString(params, "entityId");
            if (entityId == null || entityId.trim().length() == 0) {
                throw new WorkflowException("missing-entity-id", null);
            }
        }
    }
}

