/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.mechanism;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.PeriodicCleanUpMap;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.mechanism.MechanismHandler;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLRequest;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLResponse;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.datastore.DataStoreProviderManager;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSEntry;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class CramMD5MechanismHandler
implements MechanismHandler {
    private static Debug debug;
    private static final String PROP_SERVER_HOST = "com.iplanet.am.server.host";
    private static final String serverHost;
    private static final int MAX_RANDOM_NUM = 9999;
    private static final int NUM_RANDOM_DIGITS;
    private static final String ATTR_USER_PASSWORD = "userPassword";
    private static final String COMP_AUTHN_SVC = "authnsvc";
    private static final int BLOCK_LENGTH = 64;
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private static char[] hexChar;
    private static SecureRandom secureRandom;
    static final String CHALLENGE_CLEANUP_INTERVAL_PROP = "com.sun.identity.liberty.ws.authnsvc.challengeCleanupInterval";
    static int challenge_cleanup_interval;
    static final String STALE_TIME_LIMIT_PROP = "com.sun.identity.liberty.ws.soap.staleTimeLimit";
    static int stale_time_limit;
    private static Map challengeMap;

    public SASLResponse processSASLRequest(SASLRequest saslReq, Message message, String respMessageID) {
        String refToMessageID;
        boolean isFirstRequest;
        if (debug.messageEnabled()) {
            debug.message("CramMD5MechanismHandler.processSASLRequest: ");
        }
        boolean bl = isFirstRequest = (refToMessageID = saslReq.getRefToMessageID()) == null || refToMessageID.length() == 0;
        if (debug.messageEnabled()) {
            debug.message("CramMD5MechanismHandler.processSASLRequest: refToMessageID = " + refToMessageID);
        }
        SASLResponse saslResp = null;
        byte[] data = saslReq.getData();
        if (data == null) {
            if (isFirstRequest) {
                saslResp = new SASLResponse("continue");
                saslResp.setServerMechanism("CRAM-MD5");
                byte[] challenge = CramMD5MechanismHandler.generateChallenge();
                if (debug.messageEnabled()) {
                    debug.message("CramMD5MechanismHandler.processSASLRequest: add respMessageID: " + respMessageID);
                }
                challengeMap.put(respMessageID, challenge);
                saslResp.setData(challenge);
            } else {
                saslResp = new SASLResponse("abort");
            }
        } else {
            String dataStr = null;
            try {
                dataStr = new String(data, "UTF-8");
            }
            catch (Exception ex) {
                debug.error("CramMD5MechanismHandler.processSASLRequest: ", (Throwable)ex);
            }
            saslResp = dataStr == null ? new SASLResponse("abort") : this.authenticate(dataStr, message);
            if (isFirstRequest) {
                saslResp.setServerMechanism("PLAIN");
            }
        }
        return saslResp;
    }

    private SASLResponse authenticate(String data, Message message) {
        Callback[] callbacks;
        int index = data.indexOf(32);
        if (index == -1) {
            return new SASLResponse("abort");
        }
        String userName = data.substring(0, index);
        String clientDigest = data.substring(index + 1);
        DataStoreProvider dsp = null;
        try {
            dsp = DataStoreProviderManager.getInstance().getDataStoreProvider(COMP_AUTHN_SVC);
        }
        catch (DataStoreProviderException dspex) {
            debug.error("CramMD5MechanismHandler.authenticate:", (Throwable)dspex);
            return new SASLResponse("abort");
        }
        String password = CramMD5MechanismHandler.getUserPassword(userName, dsp);
        if (password == null) {
            if (debug.messageEnabled()) {
                debug.message("CramMD5MechanismHandler.authenticate: can't get password");
            }
            return new SASLResponse("abort");
        }
        String refToMessageID = message.getCorrelationHeader().getRefToMessageID();
        if (refToMessageID == null || refToMessageID.length() == 0) {
            if (debug.messageEnabled()) {
                debug.message("CramMD5MechanismHandler.authenticate: no refToMessageID");
            }
            return new SASLResponse("abort");
        }
        byte[] challengeBytes = null;
        if (debug.messageEnabled()) {
            debug.message("CramMD5MechanismHandler.authenticate: remove refToMessageID: " + refToMessageID);
        }
        if ((challengeBytes = (byte[])challengeMap.remove(refToMessageID)) == null) {
            if (debug.messageEnabled()) {
                debug.message("CramMD5MechanismHandler.authenticate: no challenge found");
            }
            return new SASLResponse("abort");
        }
        byte[] passwordBytes = null;
        try {
            passwordBytes = password.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            debug.error("CramMD5MechanismHandler.authenticate:", (Throwable)ueex);
            return new SASLResponse("abort");
        }
        String serverDigest = null;
        try {
            serverDigest = CramMD5MechanismHandler.generateHMACMD5(passwordBytes, challengeBytes);
        }
        catch (NoSuchAlgorithmException nsaex) {
            debug.error("CramMD5MechanismHandler.authenticate:", (Throwable)nsaex);
            return new SASLResponse("abort");
        }
        if (!clientDigest.equals(serverDigest)) {
            if (debug.messageEnabled()) {
                debug.message("CramMD5MechanismHandler.authenticate: digests not equal");
            }
            return new SASLResponse("abort");
        }
        if (debug.messageEnabled()) {
            debug.message("CramMD5MechanismHandler.authenticate: digests equal");
        }
        AuthContext authContext = null;
        try {
            authContext = new AuthContext(SMSEntry.getRootSuffix());
            authContext.login(AuthContext.IndexType.MODULE_INSTANCE, "LDAP");
        }
        catch (AuthLoginException le) {
            debug.error("CramMD5MechanismHandler.authenticate: ", (Throwable)le);
            return new SASLResponse("abort");
        }
        if (authContext.hasMoreRequirements() && (callbacks = authContext.getRequirements()) != null) {
            CramMD5MechanismHandler.fillInCallbacks(callbacks, userName, password);
            authContext.submitRequirements(callbacks);
        }
        AuthContext.Status loginStatus = authContext.getStatus();
        if (debug.messageEnabled()) {
            debug.message("CramMD5MechanismHandler.authenticate: login status = " + loginStatus);
        }
        if (loginStatus != AuthContext.Status.SUCCESS) {
            return new SASLResponse("abort");
        }
        try {
            String userDN;
            block27: {
                SSOToken token = authContext.getSSOToken();
                userDN = token.getPrincipal().getName();
                try {
                    SSOTokenManager.getInstance().destroyToken(token);
                }
                catch (SSOException ssoex) {
                    if (!AuthnSvcUtils.debug.warningEnabled()) break block27;
                    AuthnSvcUtils.debug.warning("PlainMechanismHandler.authenticate:", (Throwable)ssoex);
                }
            }
            SASLResponse saslResp = new SASLResponse("OK");
            if (!AuthnSvcUtils.setResourceOfferingAndCredentials((SASLResponse)saslResp, (Message)message, (String)userDN)) {
                return new SASLResponse("abort");
            }
            return saslResp;
        }
        catch (Exception ex) {
            debug.error("CramMD5MechanismHandler.authenticate: ", (Throwable)ex);
            return new SASLResponse("abort");
        }
    }

    private static void fillInCallbacks(Callback[] callbacks, String username, String password) {
        if (debug.messageEnabled()) {
            debug.message("CramMD5MechanismHandler.fillInCallbacks:");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(username);
                continue;
            }
            if (!(callback instanceof PasswordCallback)) continue;
            ((PasswordCallback)callback).setPassword(password.toCharArray());
        }
    }

    private static byte[] generateChallenge() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        int randomInt = secureRandom.nextInt(9999);
        String randomIntString = Integer.toString(randomInt);
        for (int i = randomIntString.length(); i < NUM_RANDOM_DIGITS; ++i) {
            sb.append("0");
        }
        sb.append(randomIntString).append(".");
        sb.append(System.currentTimeMillis()).append("@");
        sb.append(serverHost).append(">");
        try {
            return sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            return sb.toString().getBytes();
        }
    }

    private static String getUserPassword(String userName, DataStoreProvider dsp) {
        try {
            Set passwords = dsp.getAttribute(userName, ATTR_USER_PASSWORD);
            if (passwords == null || passwords.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("CramMD5MechanismHandler.getUserPassword: user has no password");
                }
                return null;
            }
            if (passwords.size() > 1) {
                if (debug.messageEnabled()) {
                    debug.message("CramMD5MechanismHandler.getUserPassword: user has more than 1 passwords");
                }
                return null;
            }
            String password = (String)passwords.iterator().next();
            return password;
        }
        catch (Exception ex) {
            debug.error("CramMD5MechanismHandler.getUserPassword: ", (Throwable)ex);
            return null;
        }
    }

    private static String generateHMACMD5(byte[] passwordBytes, byte[] challengeBytes) throws NoSuchAlgorithmException {
        int i;
        MessageDigest messagedigest = MessageDigest.getInstance("MD5");
        if (passwordBytes.length > 64) {
            passwordBytes = messagedigest.digest(passwordBytes);
        }
        byte[] abyte2 = new byte[64];
        byte[] abyte3 = new byte[64];
        for (i = 0; i < passwordBytes.length; ++i) {
            abyte2[i] = (byte)(passwordBytes[i] ^ 0x36);
            abyte3[i] = (byte)(passwordBytes[i] ^ 0x5C);
        }
        for (i = passwordBytes.length; i < 64; ++i) {
            abyte2[i] = 54;
            abyte3[i] = 92;
        }
        messagedigest.update(abyte2);
        messagedigest.update(challengeBytes);
        byte[] digestBytes = messagedigest.digest();
        messagedigest.update(abyte3);
        messagedigest.update(digestBytes);
        digestBytes = messagedigest.digest();
        return CramMD5MechanismHandler.toHexString(digestBytes);
    }

    private static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    static {
        block7: {
            String tmpstr;
            block6: {
                debug = Debug.getInstance((String)"fmAuthnSvc");
                serverHost = SystemPropertiesManager.get((String)PROP_SERVER_HOST, (String)"localhost");
                NUM_RANDOM_DIGITS = Integer.toString(9999).length();
                hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
                secureRandom = new SecureRandom();
                challenge_cleanup_interval = 60000;
                stale_time_limit = 300000;
                challengeMap = new PeriodicCleanUpMap((long)challenge_cleanup_interval, (long)stale_time_limit);
                tmpstr = SystemPropertiesManager.get((String)CHALLENGE_CLEANUP_INTERVAL_PROP);
                if (tmpstr != null) {
                    try {
                        challenge_cleanup_interval = Integer.parseInt(tmpstr);
                    }
                    catch (Exception ex) {
                        if (!debug.warningEnabled()) break block6;
                        debug.warning("CramMD5MechanismHandler.static: Unable to get stale time limit. Default value will be used", (Throwable)ex);
                    }
                }
            }
            if ((tmpstr = SystemPropertiesManager.get((String)STALE_TIME_LIMIT_PROP)) != null) {
                try {
                    stale_time_limit = Integer.parseInt(tmpstr);
                }
                catch (Exception ex) {
                    if (!debug.warningEnabled()) break block7;
                    debug.warning("CramMD5MechanismHandler.static: Unable to get stale time limit. Default value will be used");
                }
            }
        }
        SystemTimerPool.getTimerPool().schedule((TaskRunnable)challengeMap, new Date((System.currentTimeMillis() + (long)challenge_cleanup_interval) / 1000L * 1000L));
    }
}

