/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.COTUtils;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.shared.debug.Debug;
import java.text.MessageFormat;

public class RemoveCircleOfTrustMembers
extends AuthenticatedCommand {
    private static Debug debug = COTUtils.debug;
    private String realm;
    private String cot;
    private String entityID;
    private String spec;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.realm = this.getStringOptionValue("realm", "/");
        this.cot = this.getStringOptionValue("cot");
        this.entityID = this.getStringOptionValue("entityid");
        this.spec = FederationManager.getIDFFSubCommandSpecification(rc);
        try {
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            cotManager.removeCircleOfTrustMember(this.realm, this.cot, this.spec, this.entityID);
            Object[] objs = new Object[]{this.cot, this.entityID, this.realm};
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("remove-circle-of-trust-member-succeeded"), objs));
        }
        catch (COTException e) {
            debug.warning("RemoveCircleOfTrustMembers.handleRequest", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

