/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;

public class ListEntities
extends AuthenticatedCommand {
    private static Debug debug = SAML2MetaUtils.debug;
    private String realm;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.realm = this.getStringOptionValue("realm", "/");
        String spec = FederationManager.getIDFFSubCommandSpecification(rc);
        if (spec.equals("saml2")) {
            this.handleSAML2Request(rc);
        } else if (spec.equals("idff")) {
            this.handleIDFFRequest(rc);
        } else if (spec.equals("wsfed")) {
            this.handleWSFedRequest(rc);
        } else {
            throw new CLIException(this.getResourceString("unsupported-specification"), 127);
        }
    }

    private void handleSAML2Request(RequestContext rc) throws CLIException {
        IOutput outputWriter = this.getOutputWriter();
        Object[] objs = new Object[]{this.realm};
        try {
            SAML2MetaManager metaManager = new SAML2MetaManager();
            Set entities = metaManager.getAllEntities(this.realm);
            if (entities == null || entities.isEmpty()) {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-no-entities"), objs));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-entity-listing"), objs));
                Iterator i = entities.iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    outputWriter.printlnMessage("  " + name);
                }
            }
        }
        catch (SAML2MetaException e) {
            debug.warning("ListEntities.handleRequest", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private void handleIDFFRequest(RequestContext rc) throws CLIException {
        IOutput outputWriter = this.getOutputWriter();
        Object[] objs = new Object[]{this.realm};
        try {
            IDFFMetaManager metaManager = new IDFFMetaManager((Object)this.getAdminSSOToken());
            Set entities = metaManager.getAllEntities(this.realm);
            if (entities == null || entities.isEmpty()) {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-no-entities"), objs));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-entity-listing"), objs));
                Iterator i = entities.iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    outputWriter.printlnMessage("  " + name);
                }
            }
        }
        catch (IDFFMetaException e) {
            debug.warning("ListEntities.handleIDFFRequest", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private void handleWSFedRequest(RequestContext rc) throws CLIException {
        IOutput outputWriter = this.getOutputWriter();
        Object[] objs = new Object[]{this.realm};
        try {
            Set entities = WSFederationMetaManager.getAllEntities((String)this.realm);
            if (entities == null || entities.isEmpty()) {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-no-entities"), objs));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-entities-entity-listing"), objs));
                Iterator i = entities.iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    outputWriter.printlnMessage("  " + name);
                }
            }
        }
        catch (WSFederationMetaException e) {
            debug.warning("ListEntities.handleRequest", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

