/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.COTUtils;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.shared.debug.Debug;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;

public class ListCircleOfTrustMembers
extends AuthenticatedCommand {
    private static Debug debug = COTUtils.debug;
    private String realm;
    private String cot;
    private String spec;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.realm = this.getStringOptionValue("realm", "/");
        this.cot = this.getStringOptionValue("cot");
        IOutput outputWriter = this.getOutputWriter();
        this.spec = FederationManager.getIDFFSubCommandSpecification(rc);
        try {
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            Set circleOfTrusts = cotManager.getAllCirclesOfTrust(this.realm);
            if (!circleOfTrusts.contains(this.cot)) {
                Object[] obj = new Object[]{this.cot};
                throw new CLIException(MessageFormat.format(this.getResourceString("list-circle-of-trust-members-cot-does-not-exists"), obj), 127);
            }
            Set members = cotManager.listCircleOfTrustMember(this.realm, this.cot, this.spec);
            if (members == null || members.isEmpty()) {
                Object[] obj = new Object[]{this.cot};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-circle-of-trust-members-no-members"), obj));
            } else {
                Object[] obj = new Object[]{this.cot};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("list-circle-of-trust-members-members"), obj));
                Iterator i = members.iterator();
                while (i.hasNext()) {
                    String entityId = (String)i.next();
                    outputWriter.printlnMessage("  " + entityId);
                }
            }
        }
        catch (COTException e) {
            debug.warning("ListCircleOfTrustMembers.handleRequest", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

