/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.xml;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.dom4j.Branch;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dom4JXMLOutput
implements XMLOutput {
    private LinkedList<Branch> stack = new LinkedList();

    @CreatesObligation
    public Dom4JXMLOutput(Branch topLevel) {
        this.stack.addLast(topLevel);
    }

    @Override
    public void beginDocument() {
    }

    @Override
    public void openTag(String tagName) {
        Branch top = this.stack.getLast();
        Element element = top.addElement(tagName);
        this.stack.addLast(element);
    }

    @Override
    public void openTag(String tagName, XMLAttributeList attributeList) {
        Branch top = this.stack.getLast();
        Element element = top.addElement(tagName);
        this.stack.addLast(element);
        Iterator<XMLAttributeList.NameValuePair> i = attributeList.iterator();
        while (i.hasNext()) {
            XMLAttributeList.NameValuePair pair = i.next();
            element.addAttribute(pair.getName(), pair.getValue());
        }
    }

    @Override
    public void openCloseTag(String tagName) {
        this.openTag(tagName);
        this.closeTag(tagName);
    }

    @Override
    public void openCloseTag(String tagName, XMLAttributeList attributeList) {
        this.openTag(tagName, attributeList);
        this.closeTag(tagName);
    }

    @Override
    public void startTag(String tagName) {
        Branch top = this.stack.getLast();
        Element element = top.addElement(tagName);
        this.stack.addLast(element);
    }

    @Override
    public void addAttribute(String name, String value) {
        Element element = (Element)this.stack.getLast();
        element.addAttribute(name, value);
    }

    @Override
    public void stopTag(boolean close) {
        if (close) {
            this.closeTag(null);
        }
    }

    @Override
    public void closeTag(String tagName) {
        this.stack.removeLast();
    }

    @Override
    public void writeText(String text) {
        Element top = (Element)this.stack.getLast();
        top.addText(text);
    }

    @Override
    public void writeCDATA(String cdata) {
        Element top = (Element)this.stack.getLast();
        top.addCDATA(cdata);
    }

    public void writeElementList(String tagName, Collection<String> listValues) {
        for (String listValue : listValues) {
            this.openTag(tagName);
            this.writeText(listValue);
            this.closeTag(tagName);
        }
    }

    public void write(XMLWriteable obj) {
        try {
            obj.writeXML(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeCollection(Collection<? extends XMLWriteable> collection) {
        for (XMLWriteable xMLWriteable : collection) {
            this.write(xMLWriteable);
        }
    }

    @Override
    public void finish() {
    }
}

