/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.userAnnotations.ri;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.userAnnotations.Plugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFileUserAnnotationPlugin
implements Plugin {
    public static final boolean DEBUG = SystemProperties.getBoolean("ua.debug");
    private Map<String, String> properties = new HashMap<String, String>();

    @Override
    public Set<String> getPropertyNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.add("filename");
        return names;
    }

    @Override
    public boolean setProperties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
        return true;
    }

    @Override
    public void loadUserAnnotations(BugCollection bugs) {
        try {
            if (DEBUG) {
                System.out.println("Loading user annotations from " + this.properties.get("filename") + "...");
            }
            Document document = this.readXMLFile();
            if (DEBUG) {
                System.out.println("   Read XML file successfully");
            }
            HashMap<String, BugInstance> instanceHashToBugInstanceMap = new HashMap<String, BugInstance>();
            Iterator<BugInstance> i = bugs.iterator();
            while (i.hasNext()) {
                BugInstance bugInstance = i.next();
                instanceHashToBugInstanceMap.put(bugInstance.getInstanceHash(), bugInstance);
            }
            List entries = document.selectNodes("/FindBugsUserAnnotations/Entry");
            for (Element entry : entries) {
                BugInstance bugInstance;
                String instanceHash = this.safeGetAttribute(entry, "hash");
                String designationKey = this.safeGetAttribute(entry, "designation");
                String annotationText = this.safeGetText(entry);
                if (!I18N.instance().getUserDesignationKeys().contains(designationKey)) {
                    designationKey = "UNCLASSIFIED";
                }
                if ((bugInstance = (BugInstance)instanceHashToBugInstanceMap.get(instanceHash)) == null) continue;
                if (DEBUG) {
                    System.out.println("Updating user annotations for " + instanceHash);
                    System.out.println("  designationKey=" + designationKey);
                    System.out.println("  annotationText=" + annotationText);
                }
                BugDesignation bugDesignation = bugInstance.getNonnullUserDesignation();
                bugDesignation.setDesignationKey(designationKey);
                bugDesignation.setAnnotationText(annotationText);
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse XML file", e);
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Could not parse XML file", e);
        }
    }

    @Override
    public void storeUserAnnotation(BugInstance bug) {
        HashMap<String, BugDesignation> toUpdate = new HashMap<String, BugDesignation>();
        toUpdate.put(bug.getInstanceHash(), bug.getUserDesignation());
        this.storeAnnotations(toUpdate);
    }

    @Override
    public void storeUserAnnotations(BugCollection bugs) {
        HashMap<String, BugDesignation> toUpdate = new HashMap<String, BugDesignation>();
        Iterator<BugInstance> i = bugs.iterator();
        while (i.hasNext()) {
            BugInstance bugInstance = i.next();
            if (bugInstance.getUserDesignation() == null) continue;
            toUpdate.put(bugInstance.getInstanceHash(), bugInstance.getUserDesignation());
        }
        this.storeAnnotations(toUpdate);
    }

    private Document readXMLFile() throws MalformedURLException, DocumentException, FileNotFoundException {
        if (!this.properties.containsKey("filename")) {
            throw new IllegalArgumentException("Required property 'filename' is not set");
        }
        File f = new File(this.properties.get("filename"));
        if (!f.exists()) {
            throw new FileNotFoundException("Could not open XML file " + f.getPath());
        }
        SAXReader reader = new SAXReader();
        URL url = new URL("file:///" + this.properties.get("filename"));
        Document document = reader.read(url);
        return document;
    }

    private String safeGetAttribute(Element entry, String attrName) {
        Node attrNode = entry.selectSingleNode("@" + attrName);
        return attrNode != null ? attrNode.getText() : "";
    }

    private String safeGetText(Node node) {
        String text = node.getText();
        return text != null ? text : "";
    }

    private void storeAnnotations(Map<String, BugDesignation> toUpdate) {
        BugDesignation bugDesignation;
        String instanceHash;
        Document document;
        try {
            document = this.readXMLFile();
        }
        catch (FileNotFoundException f) {
            document = DocumentHelper.createDocument();
            document.addElement("FindBugsUserAnnotations");
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Could not parse XML file", e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse XML file", e);
        }
        HashSet<String> updatedEntries = new HashSet<String>();
        List entries = document.selectNodes("/FindBugsUserAnnotations/Entry");
        for (Element entry : entries) {
            instanceHash = this.safeGetAttribute(entry, "hash");
            if (!toUpdate.containsKey(instanceHash)) continue;
            bugDesignation = toUpdate.get(instanceHash);
            entry.addAttribute("designation", bugDesignation.getDesignationKey());
            entry.setText(bugDesignation.getAnnotationText());
            updatedEntries.add(instanceHash);
        }
        for (Map.Entry<String, BugDesignation> updateEntry : toUpdate.entrySet()) {
            instanceHash = updateEntry.getKey();
            if (updatedEntries.contains(instanceHash)) continue;
            bugDesignation = updateEntry.getValue();
            Element entry = document.getRootElement().addElement("Entry");
            entry.addAttribute("hash", instanceHash);
            entry.addAttribute("designation", bugDesignation.getDesignationKey());
            entry.setText(bugDesignation.getAnnotationText());
        }
        XMLWriter writer = null;
        try {
            FileWriter fw = new FileWriter(this.properties.get("filename"));
            OutputFormat format = OutputFormat.createPrettyPrint();
            writer = new XMLWriter(fw, format);
            writer.write(document);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not write XML file", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

