/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 6710532766397389391L;
    private HashMap<Integer, TreeSet<Integer>> map = new HashMap();

    public HashList() {
    }

    public HashList(Collection<? extends E> c) {
        this.addAll(c);
    }

    @Override
    public boolean add(E o) {
        this.add(this.size(), o);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.addToMap(element, index);
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E i : c) {
            this.add(i);
        }
        return c.size() > 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int offset = 0;
        for (E i : c) {
            this.add(index + offset, i);
            ++offset;
        }
        return c.size() > 0;
    }

    @Override
    public void clear() {
        super.clear();
        this.map.clear();
    }

    @Override
    public boolean contains(Object elem) {
        return this.indexOf(elem) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object i : c) {
            if (this.contains(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object elem) {
        Set s = this.map.get(elem.hashCode());
        if (s == null) {
            return -1;
        }
        for (Integer i : s) {
            if (!this.get(i).equals(elem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        int result = -1;
        for (Integer i : this.map.get(elem.hashCode())) {
            if (!this.get(i).equals(elem)) continue;
            result = i;
        }
        return result;
    }

    @Override
    public E remove(int index) {
        Object result = super.remove(index);
        this.removeFromMap(result, index);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.removeFromMap(o, this.indexOf(o));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object i : c) {
            result |= this.remove(i);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object i = iterator.next();
            if (c.contains(i)) continue;
            iterator.remove();
            result = true;
        }
        return result;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        Object result = this.get(index);
        if (this.map.get(result.hashCode()).size() == 1) {
            this.map.remove(result.hashCode());
        } else {
            this.map.get(result.hashCode()).remove(index);
        }
        if (!this.map.containsKey(element.hashCode())) {
            this.map.put(element.hashCode(), new TreeSet());
        }
        this.map.get(element.hashCode()).add(index);
        super.set(index, element);
        return result;
    }

    private void addToMap(E o, int index) {
        if (index < this.size()) {
            for (Map.Entry<Integer, TreeSet<Integer>> i : this.map.entrySet()) {
                TreeSet<Integer> newSet = new TreeSet<Integer>();
                for (Integer j : i.getValue()) {
                    if (j >= index) {
                        newSet.add(j + 1);
                        continue;
                    }
                    newSet.add(j);
                }
                i.setValue(newSet);
            }
        }
        if (!this.map.containsKey(o.hashCode())) {
            this.map.put(o.hashCode(), new TreeSet());
        }
        this.map.get(o.hashCode()).add(index);
    }

    private void removeFromMap(Object o, int index) {
        if (this.map.get(o.hashCode()).size() == 1) {
            this.map.remove(o.hashCode());
        } else {
            this.map.get(o.hashCode()).remove(index);
        }
        if (index < this.size() - 1) {
            for (Map.Entry<Integer, TreeSet<Integer>> i : this.map.entrySet()) {
                TreeSet<Integer> newSet = new TreeSet<Integer>();
                for (Integer j : i.getValue()) {
                    if (j <= index) continue;
                    newSet.add(j - 1);
                }
                i.setValue(newSet);
            }
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIterator<E>(){
            int cursor = -1;
            boolean removable = false;
            boolean removed = false;

            @Override
            public void add(E o) {
                HashList.this.add(this.cursor++, o);
                this.removable = false;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < HashList.this.size() - 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.removed) {
                    this.removable = true;
                    this.removed = false;
                    return HashList.this.get(this.cursor);
                }
                this.removable = true;
                this.removed = false;
                return HashList.this.get(++this.cursor);
            }

            @Override
            public int nextIndex() {
                return this.removed ? this.cursor : this.cursor + 1;
            }

            @Override
            public E previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.removable = true;
                this.removed = false;
                return HashList.this.get(--this.cursor);
            }

            @Override
            public int previousIndex() {
                if (this.hasPrevious()) {
                    return this.cursor - 1;
                }
                return -1;
            }

            @Override
            public void remove() {
                if (!this.removable) {
                    throw new IllegalStateException("next() and previous() have not been called since the last call to remove()");
                }
                this.removable = false;
                this.removed = true;
                HashList.this.remove(this.cursor);
            }

            @Override
            public void set(E o) {
                HashList.this.set(this.cursor, o);
            }
        };
    }
}

