/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.gui.AnalysisRun;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class RunAnalysisDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final AnalysisRun analysisRun;
    private Thread analysisThread;
    private boolean completed;
    private Exception fatalException;
    private int analysisPriority;
    private JLabel bottomVerticalFiller;
    private JButton cancelButton;
    private JLabel countLabel;
    private JLabel countValueLabel;
    private JLabel findBugsLabel;
    private JSeparator jSeparator1;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JLabel stageLabel;
    private JLabel stageNameLabel;
    private JLabel topVerticalFiller;

    public RunAnalysisDialog(Frame parent, AnalysisRun analysisRun_, int analysisPriority) {
        super(parent, true);
        this.initComponents();
        this.analysisRun = analysisRun_;
        this.completed = false;
        this.analysisPriority = analysisPriority;
        final RunAnalysisProgress progress = new RunAnalysisProgress();
        this.analysisThread = new Thread(){

            public void run() {
                try {
                    RunAnalysisDialog.this.analysisRun.execute(progress);
                    RunAnalysisDialog.this.setCompleted(true);
                }
                catch (IOException e) {
                    RunAnalysisDialog.this.setException(e);
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    RunAnalysisDialog.this.setException(e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RunAnalysisDialog.this.closeDialog(new WindowEvent(RunAnalysisDialog.this, 201));
                    }
                });
            }
        };
    }

    public synchronized void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public synchronized boolean isCompleted() {
        return this.completed;
    }

    public synchronized void setException(Exception e) {
        this.fatalException = e;
    }

    public synchronized boolean exceptionOccurred() {
        return this.fatalException != null;
    }

    public synchronized Exception getException() {
        return this.fatalException;
    }

    private void initComponents() {
        this.findBugsLabel = new JLabel();
        this.countLabel = new JLabel();
        this.progressLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.stageLabel = new JLabel();
        this.stageNameLabel = new JLabel();
        this.topVerticalFiller = new JLabel();
        this.bottomVerticalFiller = new JLabel();
        this.countValueLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Run Analysis");
        this.setTitle(L10N.getLocalString("dlg.runanalysis_ttl", "Run Analysis"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RunAnalysisDialog.this.closeDialog(evt);
            }

            public void windowOpened(WindowEvent evt) {
                RunAnalysisDialog.this.formWindowOpened(evt);
            }
        });
        this.findBugsLabel.setBackground(new Color(0, 0, 204));
        this.findBugsLabel.setFont(new Font("Dialog", 1, 24));
        this.findBugsLabel.setForeground(new Color(255, 255, 255));
        this.findBugsLabel.setText("Find Bugs!");
        this.findBugsLabel.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.getContentPane().add((Component)this.findBugsLabel, gridBagConstraints);
        this.countLabel.setFont(new Font("Dialog", 0, 12));
        this.countLabel.setText("Count:");
        this.countLabel.setText(L10N.getLocalString("dlg.count_lbl", "Count:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.countLabel, gridBagConstraints);
        this.progressLabel.setFont(new Font("Dialog", 0, 12));
        this.progressLabel.setText("Progress:");
        this.progressLabel.setText(L10N.getLocalString("dlg.progress_lbl", "Progress:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.progressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints);
        this.cancelButton.setFont(new Font("Dialog", 0, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setText(L10N.getLocalString("dlg.cancel_btn", "Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunAnalysisDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.stageLabel.setFont(new Font("Dialog", 0, 12));
        this.stageLabel.setText("Stage:");
        this.stageLabel.setText(L10N.getLocalString("dlg.stage_lbl", "Stage:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.stageLabel, gridBagConstraints);
        this.stageNameLabel.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.stageNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.topVerticalFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.bottomVerticalFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.getContentPane().add((Component)this.countValueLabel, gridBagConstraints);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        int option = JOptionPane.showConfirmDialog(this, L10N.getLocalString("msg.cancelanalysis_txt", "Cancel analysis?"), L10N.getLocalString("msg.analyze_txt", "Analysis"), 0, 3);
        if (option == 0) {
            this.analysisThread.interrupt();
        }
    }

    private void formWindowOpened(WindowEvent evt) {
        this.analysisThread.setPriority(this.analysisPriority);
        this.analysisThread.start();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private class RunAnalysisProgress
    implements FindBugsProgress {
        private int goal;
        private int count;

        private RunAnalysisProgress() {
        }

        private synchronized int getGoal() {
            return this.goal;
        }

        private synchronized int getCount() {
            return this.count;
        }

        public void reportNumberOfArchives(int numArchives) {
            this.beginStage(L10N.getLocalString("msg.scanningarchives_txt", "Scanning archives"), numArchives);
        }

        public void finishArchive() {
            this.step();
        }

        public void startAnalysis(int numClasses) {
            this.beginStage(L10N.getLocalString("msg.analysingclasses_txt", "Analyzing classes"), numClasses);
        }

        public void finishClass() {
            this.step();
        }

        public void finishPerClassAnalysis() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RunAnalysisDialog.this.stageNameLabel.setText(L10N.getLocalString("msg.finishedanalysis_txt", "Finishing analysis"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void beginStage(final String stageName, int goal) {
            RunAnalysisProgress runAnalysisProgress = this;
            synchronized (runAnalysisProgress) {
                this.count = 0;
                this.goal = goal;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int goal = RunAnalysisProgress.this.getGoal();
                    RunAnalysisDialog.this.stageNameLabel.setText(stageName);
                    RunAnalysisDialog.this.countValueLabel.setText("0/" + goal);
                    RunAnalysisDialog.this.progressBar.setMaximum(goal);
                    RunAnalysisDialog.this.progressBar.setValue(0);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void step() {
            RunAnalysisProgress runAnalysisProgress = this;
            synchronized (runAnalysisProgress) {
                ++this.count;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int count = RunAnalysisProgress.this.getCount();
                    int goal = RunAnalysisProgress.this.getGoal();
                    RunAnalysisDialog.this.countValueLabel.setText(count + "/" + goal);
                    RunAnalysisDialog.this.progressBar.setValue(count);
                }
            });
        }

        public void predictPassCount(int[] classesPerPass) {
        }
    }
}

