/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompoundMatcher
implements Matcher {
    protected LinkedHashSet<Matcher> children = new LinkedHashSet();

    public int hashCode() {
        int result = this.getClass().hashCode();
        for (Matcher m : this.children) {
            result += m.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        CompoundMatcher m = (CompoundMatcher)o;
        return this.children.equals(m.children);
    }

    protected int numberChildren() {
        return this.children.size();
    }

    public void addChild(Matcher child) {
        this.children.add(child);
    }

    protected void removeChild(Matcher child) {
        this.children.remove(child);
    }

    protected void clear() {
        this.children.clear();
    }

    public Collection<Matcher> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public Iterator<Matcher> childIterator() {
        return this.children.iterator();
    }

    public void writeChildrenXML(XMLOutput xmlOutput) throws IOException {
        for (Matcher m : this.children) {
            m.writeXML(xmlOutput, false);
        }
    }

    public String toString() {
        if (this.children.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Matcher m : this.children) {
            buf.append(m).append(" ");
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }
}

