/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.JavaClass;

public class UseObjectEquals
extends OpcodeStackDetector
implements StatelessDetector {
    private BugReporter bugReporter;

    public UseObjectEquals(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen == 182 && this.getNameConstantOperand().equals("equals") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z") && this.stack.getStackDepth() > 1) {
            OpcodeStack.Item item1 = this.stack.getStackItem(1);
            try {
                JavaClass cls = item1.getJavaClass();
                if (cls != null && cls.isFinal()) {
                    if (item1.getSignature().equals("Ljava/lang/Class;")) {
                        return;
                    }
                    String methodClassName = this.getClassConstantOperand();
                    if (methodClassName.equals("java/lang/Object")) {
                        if (!AnalysisContext.currentAnalysisContext().isApplicationClass(cls)) {
                            return;
                        }
                        this.bugReporter.reportBug(new BugInstance("UOE_USE_OBJECT_EQUALS", 3).addClassAndMethod(this).addSourceLine(this));
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
    }
}

