/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;

public class NumberConstructor
extends BytecodeScanningDetector {
    private final Map<String, XMethod> boxClasses = new HashMap<String, XMethod>();
    private final BugAccumulator bugAccumulator;
    private final BugReporter bugReporter;

    public NumberConstructor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.handle("java/lang/Byte", false, "(B)V");
        this.handle("java/lang/Character", false, "(C)V");
        this.handle("java/lang/Short", false, "(S)V");
        this.handle("java/lang/Integer", false, "(I)V");
        this.handle("java/lang/Long", false, "(J)V");
        this.handle("java/lang/Float", true, "(F)V");
        this.handle("java/lang/Double", true, "(D)V");
    }

    private void handle(@SlashedClassName String className, boolean isFloatingPoint, String sig) {
        XMethod m = XFactory.createXMethod(ClassName.toDottedClassName(className), "valueOf", sig, true);
        this.boxClasses.put(className, m);
    }

    public void visitClassContext(ClassContext classContext) {
        int majorVersion = classContext.getJavaClass().getMajor();
        if (majorVersion >= 49) {
            super.visitClassContext(classContext);
        }
    }

    public void visit(Code obj) {
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    public void sawOpcode(int seen) {
        String type;
        int prio;
        if (seen != 183) {
            return;
        }
        if (!"<init>".equals(this.getNameConstantOperand())) {
            return;
        }
        String cls = this.getClassConstantOperand();
        XMethod shouldCall = this.boxClasses.get(cls);
        if (shouldCall == null) {
            return;
        }
        if (!shouldCall.getSignature().substring(0, 3).equals(this.getSigConstantOperand().substring(0, 3))) {
            return;
        }
        if (cls.equals("java/lang/Float") || cls.equals("java/lang/Double")) {
            prio = 3;
            type = "DM_FP_NUMBER_CTOR";
        } else {
            prio = 2;
            type = "DM_NUMBER_CTOR";
        }
        this.bugAccumulator.accumulateBug(new BugInstance(this, type, prio).addClass(this).addMethod(this).addCalledMethod(this).addMethod(shouldCall).describe("SHOULD_CALL"), this);
    }
}

