/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ClassSummary;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.IncompatibleTypes;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.TestCaseDetector;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindUnrelatedTypesInGenericContainer
implements Detector {
    private BugReporter bugReporter;
    private static final boolean DEBUG = SystemProperties.getBoolean("gc.debug");
    private MultiMap<String, ClassDescriptor> nameToInterfaceMap = new MultiMap(LinkedList.class);
    private Map<String, Integer> nameToTypeArgumentIndex = new HashMap<String, Integer>();

    private void addToCollectionsMap(@DottedClassName String className, String methodName, int argumentParameterIndex) {
        ClassDescriptor c = DescriptorFactory.instance().getClassDescriptorForDottedClassName(className);
        this.nameToInterfaceMap.add(methodName, c);
        this.nameToTypeArgumentIndex.put(methodName, argumentParameterIndex);
    }

    public FindUnrelatedTypesInGenericContainer(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.addToCollectionsMap(Collection.class.getName(), "contains", 0);
        this.addToCollectionsMap(Collection.class.getName(), "remove", 0);
        this.addToCollectionsMap(Collection.class.getName(), "removeFirstOccurrence", 0);
        this.addToCollectionsMap(Collection.class.getName(), "removeLastOccurrence", 0);
        this.addToCollectionsMap(Collection.class.getName(), "containsAll", -1);
        this.addToCollectionsMap(Collection.class.getName(), "removeAll", -1);
        this.addToCollectionsMap(Collection.class.getName(), "retainAll", -1);
        this.addToCollectionsMap(List.class.getName(), "indexOf", 0);
        this.addToCollectionsMap(List.class.getName(), "lastIndexOf", 0);
        this.addToCollectionsMap(Map.class.getName(), "containsKey", 0);
        this.addToCollectionsMap(Map.class.getName(), "containsValue", 1);
        this.addToCollectionsMap(Map.class.getName(), "get", 0);
        this.addToCollectionsMap(Map.class.getName(), "remove", 0);
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method method : methodList = javaClass.getMethods()) {
            String msg;
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (MethodUnprofitableException e) {
            }
            catch (CFGBuilderException e) {
                msg = "Detector " + this.getClass().getName() + " caught exception while analyzing " + javaClass.getClassName() + "." + method.getName() + " : " + method.getSignature();
                this.bugReporter.logError(msg, e);
            }
            catch (DataflowAnalysisException e) {
                msg = "Detector " + this.getClass().getName() + " caught exception while analyzing " + javaClass.getClassName() + "." + method.getName() + " : " + method.getSignature();
                this.bugReporter.logError(msg, e);
            }
        }
    }

    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(185) || bytecodeSet.get(182) || bytecodeSet.get(183) || bytecodeSet.get(184) || bytecodeSet.get(183));
    }

    private boolean isSynthetic(Method m) {
        Attribute[] attrs;
        if ((m.getAccessFlags() & 0x1000) != 0) {
            return true;
        }
        for (Attribute attr : attrs = m.getAttributes()) {
            if (!(attr instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        if (this.isSynthetic(method) || !this.prescreen(classContext, method)) {
            return;
        }
        XMethod xmethod = XFactory.createXMethod(classContext.getJavaClass(), method);
        if (xmethod.isSynthetic()) {
            return;
        }
        BugAccumulator accumulator = new BugAccumulator(this.bugReporter);
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        ValueNumberDataflow vnDataflow = classContext.getValueNumberDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        String fullMethodName = methodGen.getClassName() + "." + methodGen.getName();
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        if (DEBUG) {
            System.out.println("Checking " + fullMethodName);
        }
        Iterator<Location> iter = cfg.locationIterator();
        while (iter.hasNext()) {
            Location location = iter.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction inv = (InvokeInstruction)ins;
            XMethod invokedMethod = XFactory.createXMethod(inv, cpg);
            for (ClassDescriptor interfaceOfInterest : this.nameToInterfaceMap.get(invokedMethod.getName())) {
                XMethod nextMethod;
                Instruction nextIns;
                InstructionHandle next;
                GenericObjectType p2;
                List<? extends ReferenceType> parameters;
                boolean selfOperation;
                GenericObjectType operand;
                Type objectType;
                ValueNumber argVN;
                Type operandType;
                Subtypes2 subtypes2;
                boolean allMethod;
                int pos;
                String argSignature;
                block36: {
                    if (DEBUG) {
                        System.out.println("Checking call to " + interfaceOfInterest + " : " + invokedMethod);
                    }
                    argSignature = invokedMethod.getSignature();
                    argSignature = argSignature.substring(0, argSignature.indexOf(41) + 1);
                    pos = 0;
                    allMethod = false;
                    if (!argSignature.equals("(Ljava/lang/Object;)")) {
                        if (invokedMethod.getName().equals("removeAll") || invokedMethod.getName().equals("containsAll") || invokedMethod.getName().equals("retainAll")) {
                            if (!invokedMethod.getSignature().equals("(Ljava/util/Collection;)Z")) continue;
                            allMethod = true;
                        } else {
                            if (!invokedMethod.getName().endsWith("ndexOf") || !invokedMethod.getClassName().equals("java.util.Vector") || !argSignature.equals("(Ljava/lang/Object;I)")) continue;
                            pos = 1;
                        }
                    }
                    subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                    try {
                        if (!subtypes2.isSubtype(invokedMethod.getClassDescriptor(), interfaceOfInterest)) {
                        }
                        break block36;
                    }
                    catch (ClassNotFoundException e) {
                        AnalysisContext.reportMissingClass(e);
                    }
                    continue;
                }
                int typeArgument = this.nameToTypeArgumentIndex.get(invokedMethod.getName());
                TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
                if (!frame.isValid() || (operandType = (Type)frame.getStackValue(pos)).equals(TopType.instance())) continue;
                ValueNumberFrame vnFrame = (ValueNumberFrame)vnDataflow.getFactAtLocation(location);
                int numArguments = frame.getNumArguments(inv, cpg);
                if (numArguments != 1 + pos) continue;
                int expectedParameters = 1;
                if (interfaceOfInterest.getSimpleName().equals("Map")) {
                    expectedParameters = 2;
                }
                SignatureParser sigParser = new SignatureParser(inv.getSignature(cpg));
                ValueNumber objectVN = (ValueNumber)vnFrame.getInstance(ins, cpg);
                if (objectVN.equals(argVN = (ValueNumber)vnFrame.getArgument(inv, cpg, 0, sigParser))) {
                    XMethod nextMethod2;
                    Instruction nextIns2;
                    InstructionHandle next2;
                    String bugPattern = "DMI_COLLECTIONS_SHOULD_NOT_CONTAIN_THEMSELVES";
                    int priority = 1;
                    if (invokedMethod.getName().equals("removeAll")) {
                        bugPattern = "DMI_USING_REMOVEALL_TO_CLEAR_COLLECTION";
                        priority = 2;
                    } else if (invokedMethod.getName().endsWith("All")) {
                        bugPattern = "DMI_VACUOUS_SELF_COLLECTION_CALL";
                        priority = 2;
                    }
                    if (invokedMethod.getName().startsWith("contains") && (next2 = handle.getNext()) != null && (nextIns2 = next2.getInstruction()) instanceof InvokeInstruction && (nextMethod2 = XFactory.createXMethod((InvokeInstruction)nextIns2, cpg)).getName().equals("assertTrue")) continue;
                    accumulator.accumulateBug(new BugInstance(this, bugPattern, priority).addClassAndMethod(methodGen, sourceFile).addCalledMethod(methodGen, (InvokeInstruction)ins).addOptionalAnnotation(ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, objectVN, vnFrame, "INVOKED_ON")), SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle));
                }
                if (!((objectType = (Type)frame.getInstance(inv, cpg)) instanceof GenericObjectType) || !(operand = (GenericObjectType)objectType).hasParameters()) continue;
                ClassDescriptor operandClass = DescriptorFactory.getClassDescriptor(operand);
                if (!operandClass.getClassName().startsWith("java/util")) {
                    try {
                        XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, operandClass);
                        String sig = xclass.getSourceSignature();
                        if (sig != null && sig.indexOf("<L") > 0) {
                            continue;
                        }
                    }
                    catch (CheckedAnalysisException e1) {
                        AnalysisContext.logError("Error checking for weird generic parameterization", e1);
                    }
                }
                if (operand.getNumParameters() != expectedParameters) continue;
                Type expectedType = typeArgument < 0 ? operand : operand.getParameterAt(typeArgument);
                Type actualType = (Type)frame.getArgument(inv, cpg, 0, sigParser);
                IncompatibleTypes matchResult = this.compareTypes(expectedType, actualType, allMethod);
                boolean parmIsObject = expectedType.getSignature().equals("Ljava/lang/Object;");
                boolean bl = selfOperation = !allMethod && operand.equals(actualType) && !parmIsObject;
                if (!allMethod && !parmIsObject && actualType instanceof GenericObjectType && (parameters = (p2 = (GenericObjectType)actualType).getParameters()) != null && ((Object)parameters).equals(operand.getParameters())) {
                    selfOperation = true;
                }
                if (!selfOperation && matchResult == IncompatibleTypes.SEEMS_OK || invokedMethod.getName().startsWith("contains") && (next = handle.getNext()) != null && (nextIns = next.getInstruction()) instanceof InvokeInstruction && (nextMethod = XFactory.createXMethod((InvokeInstruction)nextIns, cpg)).getName().equals("assertFalse")) continue;
                SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle);
                if (expectedType instanceof GenericObjectType) {
                    expectedType = ((GenericObjectType)expectedType).getUpperBound();
                }
                int priority = matchResult.getPriority();
                if (TestCaseDetector.likelyTestCase(xmethod)) {
                    priority = Math.max(priority, 2);
                } else if (selfOperation) {
                    priority = 1;
                }
                ClassDescriptor expectedClassDescriptor = DescriptorFactory.createClassOrObjectDescriptorFromSignature(expectedType.getSignature());
                ClassDescriptor actualClassDescriptor = DescriptorFactory.createClassOrObjectDescriptorFromSignature(actualType.getSignature());
                ClassSummary classSummary = AnalysisContext.currentAnalysisContext().getClassSummary();
                Set<XMethod> targets = null;
                try {
                    targets = Hierarchy2.resolveVirtualMethodCallTargets(actualClassDescriptor, "equals", "(Ljava/lang/Object;)Z", false, false);
                    boolean allOk = targets.size() > 0;
                    for (XMethod m2 : targets) {
                        if (classSummary.mightBeEqualTo(m2.getClassDescriptor(), expectedClassDescriptor)) continue;
                        allOk = false;
                    }
                    if (allOk) {
                        priority += 2;
                    }
                }
                catch (ClassNotFoundException e) {
                    AnalysisContext.reportMissingClass(e);
                }
                String bugPattern = "GC_UNRELATED_TYPES";
                if (matchResult == IncompatibleTypes.UNCHECKED) {
                    boolean foundMatch = false;
                    for (ClassDescriptor selfInterface : this.nameToInterfaceMap.get(methodGen.getName())) {
                        if (DEBUG) {
                            System.out.println("Checking call to " + interfaceOfInterest + " : " + invokedMethod);
                        }
                        String selfSignature = methodGen.getSignature();
                        argSignature = argSignature.substring(0, argSignature.indexOf(41) + 1);
                        try {
                            if (!argSignature.equals("(Ljava/lang/Object;)") || !subtypes2.isSubtype(classContext.getClassDescriptor(), selfInterface)) continue;
                            foundMatch = true;
                            break;
                        }
                        catch (ClassNotFoundException e) {
                            AnalysisContext.reportMissingClass(e);
                        }
                    }
                    if (foundMatch) continue;
                    bugPattern = "GC_UNCHECKED_TYPE_IN_GENERIC_CALL";
                }
                accumulator.accumulateBug(new BugInstance(this, bugPattern, priority).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(actualType, expectedType).addCalledMethod(methodGen, (InvokeInstruction)ins).addOptionalAnnotation(ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, objectVN, vnFrame, "INVOKED_ON")).addOptionalAnnotation(ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, argVN, vnFrame, "ARGUMENT")).addEqualsMethodUsed(targets), sourceLineAnnotation);
            }
        }
        accumulator.reportAccumulatedBugs();
    }

    private IncompatibleTypes compareTypes(Type expectedType, Type actualType, boolean ignoreBaseType) {
        String actualString;
        if (expectedType == actualType) {
            return IncompatibleTypes.SEEMS_OK;
        }
        String expectedString = GenericUtilities.getString(expectedType);
        if (expectedString.equals(actualString = GenericUtilities.getString(actualType))) {
            return IncompatibleTypes.SEEMS_OK;
        }
        if (expectedType.equals(Type.OBJECT)) {
            return IncompatibleTypes.SEEMS_OK;
        }
        String objString = GenericUtilities.getString(Type.OBJECT);
        if (expectedString.equals(objString)) {
            return IncompatibleTypes.SEEMS_OK;
        }
        GenericUtilities.TypeCategory parmCat = GenericUtilities.getTypeCategory(expectedType);
        GenericUtilities.TypeCategory argCat = GenericUtilities.getTypeCategory(actualType);
        if (actualString.equals(objString) && parmCat == GenericUtilities.TypeCategory.TYPE_VARIABLE) {
            return IncompatibleTypes.SEEMS_OK;
        }
        if (ignoreBaseType) {
            if (parmCat == GenericUtilities.TypeCategory.PARAMETERIZED && argCat == GenericUtilities.TypeCategory.PARAMETERIZED) {
                GenericObjectType parmGeneric = (GenericObjectType)expectedType;
                GenericObjectType argGeneric = (GenericObjectType)actualType;
                return this.compareTypeParameters(parmGeneric, argGeneric);
            }
            return IncompatibleTypes.SEEMS_OK;
        }
        if (actualType.equals(Type.OBJECT) && parmCat == GenericUtilities.TypeCategory.ARRAY_TYPE) {
            return IncompatibleTypes.ARRAY_AND_OBJECT;
        }
        if (parmCat == GenericUtilities.TypeCategory.PLAIN_OBJECT_TYPE && argCat == GenericUtilities.TypeCategory.PLAIN_OBJECT_TYPE) {
            return IncompatibleTypes.getPriorityForAssumingCompatible(expectedType, actualType, false);
        }
        if (parmCat == GenericUtilities.TypeCategory.PARAMETERIZED && argCat == GenericUtilities.TypeCategory.PLAIN_OBJECT_TYPE) {
            return IncompatibleTypes.getPriorityForAssumingCompatible(((GenericObjectType)expectedType).getObjectType(), actualType);
        }
        if (parmCat == GenericUtilities.TypeCategory.PLAIN_OBJECT_TYPE && argCat == GenericUtilities.TypeCategory.PARAMETERIZED) {
            return IncompatibleTypes.getPriorityForAssumingCompatible(expectedType, ((GenericObjectType)actualType).getObjectType());
        }
        if (parmCat == GenericUtilities.TypeCategory.WILDCARD_EXTENDS || parmCat == GenericUtilities.TypeCategory.WILDCARD_SUPER) {
            return this.compareTypes(((GenericObjectType)expectedType).getExtension(), actualType, ignoreBaseType);
        }
        if (parmCat == GenericUtilities.TypeCategory.TYPE_VARIABLE || argCat == GenericUtilities.TypeCategory.TYPE_VARIABLE) {
            return IncompatibleTypes.SEEMS_OK;
        }
        if (parmCat == GenericUtilities.TypeCategory.ARRAY_TYPE && argCat == GenericUtilities.TypeCategory.ARRAY_TYPE) {
            ArrayType parmArray = (ArrayType)expectedType;
            ArrayType argArray = (ArrayType)actualType;
            if (parmArray.getDimensions() != argArray.getDimensions()) {
                return IncompatibleTypes.ARRAY_AND_NON_ARRAY;
            }
            return this.compareTypes(parmArray.getBasicType(), argArray.getBasicType(), ignoreBaseType);
        }
        if (parmCat == GenericUtilities.TypeCategory.ARRAY_TYPE ^ argCat == GenericUtilities.TypeCategory.ARRAY_TYPE) {
            return IncompatibleTypes.ARRAY_AND_NON_ARRAY;
        }
        if (parmCat == GenericUtilities.TypeCategory.PARAMETERIZED && argCat == GenericUtilities.TypeCategory.PARAMETERIZED) {
            GenericObjectType parmGeneric = (GenericObjectType)expectedType;
            GenericObjectType argGeneric = (GenericObjectType)actualType;
            IncompatibleTypes result = this.compareTypes(parmGeneric.getObjectType(), argGeneric.getObjectType(), ignoreBaseType);
            if (!result.equals(IncompatibleTypes.SEEMS_OK)) {
                return result;
            }
            return this.compareTypeParameters(parmGeneric, argGeneric);
        }
        if (parmCat == GenericUtilities.TypeCategory.WILDCARD) {
            return IncompatibleTypes.SEEMS_OK;
        }
        if (expectedType instanceof BasicType || actualType instanceof BasicType) {
            throw new IllegalArgumentException("checking for compatibility of " + expectedType + " with " + actualType);
        }
        return IncompatibleTypes.SEEMS_OK;
    }

    private IncompatibleTypes compareTypeParameters(GenericObjectType parmGeneric, GenericObjectType argGeneric) {
        int p = parmGeneric.getNumParameters();
        if (p != argGeneric.getNumParameters()) {
            if (SystemProperties.ASSERTIONS_ENABLED) {
                AnalysisContext.logError("Wierd generic parameters: " + parmGeneric + " and " + argGeneric);
            }
            return IncompatibleTypes.SEEMS_OK;
        }
        for (int x = 0; x < p; ++x) {
            IncompatibleTypes result = this.compareTypes(parmGeneric.getParameterAt(x), argGeneric.getParameterAt(x), false);
            if (result == IncompatibleTypes.SEEMS_OK) continue;
            return result;
        }
        return IncompatibleTypes.SEEMS_OK;
    }

    private boolean compareTypesOld(Type parmType, Type argType) {
        GenericObjectType o;
        if (GenericUtilities.getString(parmType).equals(GenericUtilities.getString(argType))) {
            return true;
        }
        if (parmType instanceof GenericObjectType && (o = (GenericObjectType)parmType).getTypeCategory() == GenericUtilities.TypeCategory.WILDCARD_EXTENDS) {
            return this.compareTypesOld(o.getExtension(), argType);
        }
        if (parmType instanceof GenericObjectType && !((GenericObjectType)parmType).hasParameters()) {
            return true;
        }
        if (argType instanceof GenericObjectType && !((GenericObjectType)argType).hasParameters()) {
            return true;
        }
        if (parmType instanceof GenericObjectType && argType instanceof GenericObjectType) {
            return true;
        }
        if (!(parmType instanceof ReferenceType) || !(argType instanceof ReferenceType)) {
            return true;
        }
        if (!(parmType instanceof ObjectType) || !(argType instanceof ObjectType)) {
            return true;
        }
        try {
            return Repository.instanceOf(((ObjectType)argType).getClassName(), ((ObjectType)parmType).getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    public void report() {
    }
}

