/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsNullValueDataflowFactory
extends AnalysisFactory<IsNullValueDataflow> {
    public IsNullValueDataflowFactory() {
        super("null value analysis", IsNullValueDataflow.class);
    }

    @Override
    public IsNullValueDataflow analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        MethodGen methodGen = this.getMethodGen(analysisCache, descriptor);
        if (methodGen == null) {
            throw new MethodUnprofitableException(descriptor);
        }
        CFG cfg = this.getCFG(analysisCache, descriptor);
        ValueNumberDataflow vnaDataflow = this.getValueNumberDataflow(analysisCache, descriptor);
        DepthFirstSearch dfs = this.getDepthFirstSearch(analysisCache, descriptor);
        AssertionMethods assertionMethods = this.getAssertionMethods(analysisCache, descriptor.getClassDescriptor());
        IsNullValueAnalysis invAnalysis = new IsNullValueAnalysis(methodGen, cfg, vnaDataflow, dfs, assertionMethods);
        invAnalysis.setClassAndMethod(new JavaClassAndMethod(this.getJavaClass(analysisCache, descriptor.getClassDescriptor()), this.getMethod(analysisCache, descriptor)));
        IsNullValueDataflow invDataflow = new IsNullValueDataflow(cfg, invAnalysis);
        invDataflow.execute();
        if (ClassContext.DUMP_DATAFLOW_ANALYSIS) {
            invDataflow.dumpDataflow(invAnalysis);
        }
        return invDataflow;
    }
}

