/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.jsr305.FlowValue;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkInfo;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeQualifierValueSet {
    private static final FlowValue DEFAULT_FLOW_VALUE = FlowValue.UNKNOWN;
    private Map<ValueNumber, FlowValue> valueMap;
    private Map<ValueNumber, Set<SourceSinkInfo>> whereAlways;
    private Map<ValueNumber, Set<SourceSinkInfo>> whereNever;
    private State state = State.VALID;

    public TypeQualifierValueSet() {
        this.valueMap = new HashMap<ValueNumber, FlowValue>();
        this.whereAlways = new HashMap<ValueNumber, Set<SourceSinkInfo>>();
        this.whereNever = new HashMap<ValueNumber, Set<SourceSinkInfo>>();
        this.state = State.TOP;
    }

    public void modelSourceSink(SourceSinkInfo sourceSinkInfo) {
        assert (sourceSinkInfo != null);
        ValueNumber vn = sourceSinkInfo.getValueNumber();
        FlowValue flowValue = FlowValue.flowValueFromWhen(sourceSinkInfo.getWhen());
        this.setValue(vn, flowValue);
        if (flowValue.isYes()) {
            TypeQualifierValueSet.addSourceSinkInfo(this.whereAlways, vn, sourceSinkInfo);
        }
        if (flowValue.isNo()) {
            TypeQualifierValueSet.addSourceSinkInfo(this.whereNever, vn, sourceSinkInfo);
        }
    }

    private void setValue(ValueNumber vn, FlowValue flowValue) {
        this.valueMap.put(vn, flowValue);
    }

    private static void addSourceSinkInfo(Map<ValueNumber, Set<SourceSinkInfo>> sourceSinkInfoSetMap, ValueNumber vn, SourceSinkInfo sourceSinkInfo) {
        Set<SourceSinkInfo> sourceSinkInfoSet = TypeQualifierValueSet.getOrCreateSourceSinkInfoSet(sourceSinkInfoSetMap, vn);
        sourceSinkInfoSet.add(sourceSinkInfo);
    }

    public void pruneValue(ValueNumber vn) {
        assert (this.isValid());
        this.valueMap.remove(vn);
        this.whereAlways.remove(vn);
        this.whereNever.remove(vn);
    }

    public Set<SourceSinkInfo> getWhereAlways(ValueNumber vn) {
        return TypeQualifierValueSet.getOrCreateSourceSinkInfoSet(this.whereAlways, vn);
    }

    public Set<SourceSinkInfo> getWhereNever(ValueNumber vn) {
        return TypeQualifierValueSet.getOrCreateSourceSinkInfoSet(this.whereNever, vn);
    }

    private static Set<SourceSinkInfo> getOrCreateSourceSinkInfoSet(Map<ValueNumber, Set<SourceSinkInfo>> sourceSinkInfoSetMap, ValueNumber vn) {
        Set<SourceSinkInfo> sourceSinkInfoSet = sourceSinkInfoSetMap.get(vn);
        if (sourceSinkInfoSet == null) {
            sourceSinkInfoSet = new HashSet<SourceSinkInfo>();
            sourceSinkInfoSetMap.put(vn, sourceSinkInfoSet);
        }
        return sourceSinkInfoSet;
    }

    public FlowValue getValue(ValueNumber vn) {
        FlowValue result = this.valueMap.get(vn);
        return result != null ? result : FlowValue.TOP;
    }

    public Collection<? extends ValueNumber> getValueNumbers() {
        return this.valueMap.keySet();
    }

    public boolean isValid() {
        return this.state == State.VALID;
    }

    public void makeValid() {
        this.reset(State.VALID);
    }

    public void makeSameAs(TypeQualifierValueSet source) {
        this.reset(source.state);
        this.valueMap.putAll(source.valueMap);
        this.copySourceSinkInfoSetMap(this.whereAlways, source.whereAlways);
        this.copySourceSinkInfoSetMap(this.whereNever, source.whereNever);
    }

    private void copySourceSinkInfoSetMap(Map<ValueNumber, Set<SourceSinkInfo>> dest, Map<ValueNumber, Set<SourceSinkInfo>> source) {
        dest.keySet().retainAll(source.keySet());
        for (Map.Entry<ValueNumber, Set<SourceSinkInfo>> entry : source.entrySet()) {
            Set<SourceSinkInfo> locSet = TypeQualifierValueSet.getOrCreateSourceSinkInfoSet(dest, entry.getKey());
            locSet.clear();
            locSet.addAll((Collection<SourceSinkInfo>)entry.getValue());
        }
    }

    public boolean isTop() {
        return this.state == State.TOP;
    }

    public void setTop() {
        this.reset(State.TOP);
    }

    public boolean isBottom() {
        return this.state == State.BOTTOM;
    }

    public void setBottom() {
        this.reset(State.BOTTOM);
    }

    private void reset(State state) {
        this.valueMap.clear();
        this.whereAlways.clear();
        this.whereNever.clear();
        this.state = state;
    }

    public void propagateAcrossPhiNode(ValueNumber fromVN, ValueNumber toVN) {
        assert (this.isValid());
        this.setValue(toVN, this.getValue(fromVN));
        TypeQualifierValueSet.transferSourceSinkInfoSet(this.whereAlways, fromVN, toVN);
        TypeQualifierValueSet.transferSourceSinkInfoSet(this.whereNever, fromVN, toVN);
        this.valueMap.remove(fromVN);
        this.whereAlways.remove(fromVN);
        this.whereNever.remove(fromVN);
    }

    private static void transferSourceSinkInfoSet(Map<ValueNumber, Set<SourceSinkInfo>> sourceSinkInfoSetMap, ValueNumber fromVN, ValueNumber toVN) {
        Set<SourceSinkInfo> locSet = TypeQualifierValueSet.getOrCreateSourceSinkInfoSet(sourceSinkInfoSetMap, fromVN);
        for (SourceSinkInfo loc : locSet) {
            TypeQualifierValueSet.addSourceSinkInfo(sourceSinkInfoSetMap, toVN, loc);
        }
    }

    public void mergeWith(TypeQualifierValueSet fact) throws DataflowAnalysisException {
        if (!this.isValid() || !fact.isValid()) {
            throw new DataflowAnalysisException("merging an invalid TypeQualifierValueSet");
        }
        HashSet<ValueNumber> interesting = new HashSet<ValueNumber>();
        interesting.addAll(this.valueMap.keySet());
        interesting.addAll(fact.valueMap.keySet());
        for (ValueNumber vn : interesting) {
            this.setValue(vn, FlowValue.meet(this.getValue(vn), fact.getValue(vn)));
            this.mergeSourceSinkInfoSets(this.whereAlways, fact.whereAlways, vn);
            this.mergeSourceSinkInfoSets(this.whereNever, fact.whereNever, vn);
        }
    }

    private void mergeSourceSinkInfoSets(Map<ValueNumber, Set<SourceSinkInfo>> sourceSinkInfoSetMapToUpdate, Map<ValueNumber, Set<SourceSinkInfo>> otherSourceSinkInfoSetMap, ValueNumber vn) {
        if (!otherSourceSinkInfoSetMap.containsKey(vn)) {
            return;
        }
        Set<SourceSinkInfo> sourceSinkInfoSetToUpdate = TypeQualifierValueSet.getOrCreateSourceSinkInfoSet(sourceSinkInfoSetMapToUpdate, vn);
        sourceSinkInfoSetToUpdate.addAll(TypeQualifierValueSet.getOrCreateSourceSinkInfoSet(otherSourceSinkInfoSetMap, vn));
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TypeQualifierValueSet other = (TypeQualifierValueSet)obj;
        if (this.isValid() && other.isValid()) {
            return ((Object)this.valueMap).equals(other.valueMap);
        }
        return this.state == other.state;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.state != State.VALID) {
            return this.state.toString();
        }
        TreeSet<ValueNumber> interesting = new TreeSet<ValueNumber>();
        interesting.addAll(this.valueMap.keySet());
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        for (ValueNumber vn : interesting) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append(this.valueNumberToString(vn));
        }
        buf.append("}");
        return buf.toString();
    }

    public String valueNumberToString(ValueNumber vn) {
        StringBuilder buf = new StringBuilder();
        buf.append(vn.getNumber());
        buf.append("->");
        buf.append(this.getValue(vn).toString());
        buf.append("[");
        TypeQualifierValueSet.appendSourceSinkInfos(buf, "YES=", TypeQualifierValueSet.getOrCreateSourceSinkInfoSet(this.whereAlways, vn));
        buf.append(",");
        TypeQualifierValueSet.appendSourceSinkInfos(buf, "NO=", TypeQualifierValueSet.getOrCreateSourceSinkInfoSet(this.whereNever, vn));
        buf.append("]");
        return buf.toString();
    }

    private static void appendSourceSinkInfos(StringBuilder buf, String key, Set<SourceSinkInfo> sourceSinkInfoSet) {
        TreeSet<SourceSinkInfo> sortedLocSet = new TreeSet<SourceSinkInfo>();
        sortedLocSet.addAll(sourceSinkInfoSet);
        boolean first = true;
        buf.append(key);
        buf.append("(");
        for (SourceSinkInfo loc : sortedLocSet) {
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(loc.getLocation().toCompactString());
        }
        buf.append(")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        VALID,
        TOP,
        BOTTOM;

    }
}

