/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.WarningComparator;
import edu.umd.cs.findbugs.model.ClassNameRewriter;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FuzzyBugComparator
implements WarningComparator {
    private static final boolean DEBUG = false;
    private static final boolean USE_HASHES = false;
    private static final long serialVersionUID = 1L;
    private IdentityHashMap<BugInstance, BugCollection> bugCollectionMap = new IdentityHashMap();
    private ClassNameRewriter classNameRewriter;
    private static final int NUM_CONTEXT_OPCODES = 2;
    private static final HashSet<String> significantDescriptionSet = new HashSet();

    public void registerBugCollection(BugCollection bugCollection) {
    }

    public void setClassNameRewriter(ClassNameRewriter classNameRewriter) {
        this.classNameRewriter = classNameRewriter;
    }

    public int compare(BugInstance lhs, BugInstance rhs) {
        String rhsCode;
        String lhsCode;
        int cmp;
        BugPattern lhsPattern = lhs.getBugPattern();
        BugPattern rhsPattern = rhs.getBugPattern();
        if (lhsPattern == null || rhsPattern == null ? (cmp = (lhsCode = this.getCode(lhs.getType())).compareTo(rhsCode = this.getCode(rhs.getType()))) != 0 : (cmp = lhsPattern.getAbbrev().compareTo(rhsPattern.getAbbrev())) != 0) {
            return cmp;
        }
        BugCollection lhsCollection = this.bugCollectionMap.get(lhs);
        BugCollection rhsCollection = this.bugCollectionMap.get(rhs);
        FilteringBugAnnotationIterator lhsIter = new FilteringBugAnnotationIterator(lhs.annotationIterator());
        FilteringBugAnnotationIterator rhsIter = new FilteringBugAnnotationIterator(rhs.annotationIterator());
        while (lhsIter.hasNext() && rhsIter.hasNext()) {
            BugAnnotation lhsAnnotation = (BugAnnotation)lhsIter.next();
            BugAnnotation rhsAnnotation = (BugAnnotation)rhsIter.next();
            cmp = lhsAnnotation.getClass().getName().compareTo(rhsAnnotation.getClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = lhsAnnotation.getClass() == ClassAnnotation.class ? this.compareClasses(lhsCollection, rhsCollection, (ClassAnnotation)lhsAnnotation, (ClassAnnotation)rhsAnnotation) : (lhsAnnotation.getClass() == MethodAnnotation.class ? this.compareMethods(lhsCollection, rhsCollection, (MethodAnnotation)lhsAnnotation, (MethodAnnotation)rhsAnnotation) : (lhsAnnotation.getClass() == SourceLineAnnotation.class ? this.compareSourceLines(lhsCollection, rhsCollection, (SourceLineAnnotation)lhsAnnotation, (SourceLineAnnotation)rhsAnnotation) : lhsAnnotation.compareTo(rhsAnnotation)));
            if (cmp == 0) continue;
            return cmp;
        }
        if (!lhsIter.hasNext() && !rhsIter.hasNext()) {
            return 0;
        }
        return lhsIter.hasNext() ? 1 : -1;
    }

    private String getCode(String type) {
        int bar = type.indexOf(95);
        if (bar < 0) {
            return "";
        }
        return type.substring(0, bar);
    }

    private static int compareNullElements(Object a, Object b) {
        if (a != null) {
            return 1;
        }
        if (b != null) {
            return -1;
        }
        return 0;
    }

    public int compareClasses(BugCollection lhsCollection, BugCollection rhsCollection, ClassAnnotation lhsClass, ClassAnnotation rhsClass) {
        if (lhsClass == null || rhsClass == null) {
            return FuzzyBugComparator.compareNullElements(lhsClass, rhsClass);
        }
        return this.compareClassesByName(lhsCollection, rhsCollection, lhsClass.getClassName(), rhsClass.getClassName());
    }

    public int compareClassesByName(BugCollection lhsCollection, BugCollection rhsCollection, String lhsClassName, String rhsClassName) {
        lhsClassName = this.rewriteClassName(lhsClassName);
        rhsClassName = this.rewriteClassName(rhsClassName);
        return lhsClassName.compareTo(rhsClassName);
    }

    private String rewriteClassName(String className) {
        if (this.classNameRewriter != null) {
            className = this.classNameRewriter.rewriteClassName(className);
        }
        return className;
    }

    public int compareMethods(BugCollection lhsCollection, BugCollection rhsCollection, MethodAnnotation lhsMethod, MethodAnnotation rhsMethod) {
        if (lhsMethod == null || rhsMethod == null) {
            return FuzzyBugComparator.compareNullElements(lhsMethod, rhsMethod);
        }
        int cmp = lhsMethod.compareTo(rhsMethod);
        return cmp;
    }

    public int compareSourceLines(BugCollection lhsCollection, BugCollection rhsCollection, SourceLineAnnotation lhs, SourceLineAnnotation rhs) {
        if (lhs == null || rhs == null) {
            return FuzzyBugComparator.compareNullElements(lhs, rhs);
        }
        int cmp = this.compareClassesByName(lhsCollection, rhsCollection, lhs.getClassName(), rhs.getClassName());
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    public static boolean ignore(BugAnnotation annotation) {
        return !significantDescriptionSet.contains(annotation.getDescription());
    }

    static {
        significantDescriptionSet.add("CLASS_DEFAULT");
        significantDescriptionSet.add("CLASS_EXCEPTION");
        significantDescriptionSet.add("CLASS_REFTYPE");
        significantDescriptionSet.add("INTERFACE_TYPE");
        significantDescriptionSet.add("METHOD_DEFAULT");
        significantDescriptionSet.add("METHOD_CALLED");
        significantDescriptionSet.add("METHOD_DANGEROUS_TARGET");
        significantDescriptionSet.add("METHOD_DECLARED_NONNULL");
        significantDescriptionSet.add("FIELD_DEFAULT");
        significantDescriptionSet.add("FIELD_ON");
        significantDescriptionSet.add("FIELD_SUPER");
        significantDescriptionSet.add("FIELD_MASKED");
        significantDescriptionSet.add("FIELD_MASKING");
        significantDescriptionSet.add("FIELD_STORED");
        significantDescriptionSet.add("TYPE_DEFAULT");
        significantDescriptionSet.add("TYPE_EXPECTED");
        significantDescriptionSet.add("TYPE_FOUND");
        significantDescriptionSet.add("LOCAL_VARIABLE_NAMED");
        significantDescriptionSet.add("INT_NULL_ARG");
        significantDescriptionSet.add("INT_MAYBE_NULL_ARG");
        significantDescriptionSet.add("INT_NONNULL_PARAM");
        significantDescriptionSet.add("SOURCE_LINE_DEFAULT");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteringBugAnnotationIterator
    implements Iterator<BugAnnotation> {
        Iterator<BugAnnotation> iter;
        BugAnnotation next;

        public FilteringBugAnnotationIterator(Iterator<BugAnnotation> iter) {
            this.iter = iter;
        }

        private void findNext() {
            if (this.next == null) {
                while (this.iter.hasNext()) {
                    BugAnnotation candidate = this.iter.next();
                    if (FuzzyBugComparator.ignore(candidate)) continue;
                    this.next = candidate;
                    break;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.next != null;
        }

        @Override
        public BugAnnotation next() {
            this.findNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            BugAnnotation result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

