/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.ssl;

import java.io.IOException;
import java.security.KeyStore;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.tomcat.util.net.jsse.JSSESocketFactory;
import org.jboss.security.SecurityDomain;

public class JBossSocketFactory
extends JSSESocketFactory {
    private SecurityDomain securityDomain;

    public void setAttribute(String name, Object value) {
        if (name.equalsIgnoreCase("securityDomain")) {
            try {
                this.setSecurityDomainName((String)value);
            }
            catch (Exception e) {
                IllegalArgumentException ex = new IllegalArgumentException("Failed to set security domain");
                ex.initCause(e);
                throw ex;
            }
        }
        super.setAttribute(name, value);
    }

    public void setSecurityDomainName(String jndiName) throws NamingException, IOException {
        InitialContext iniCtx = new InitialContext();
        this.securityDomain = (SecurityDomain)iniCtx.lookup(jndiName);
    }

    protected KeyStore getKeystore(String type, String pass) throws IOException {
        this.verifySecurityDomain();
        return this.securityDomain.getKeyStore();
    }

    protected KeyStore getTrustStore(String type) throws IOException {
        this.verifySecurityDomain();
        return this.securityDomain.getTrustStore();
    }

    protected TrustManager[] getTrustManagers(String keystoreType, String algorithm) throws Exception {
        this.verifySecurityDomain();
        TrustManagerFactory tmf = this.securityDomain.getTrustManagerFactory();
        TrustManager[] trustMgrs = null;
        if (tmf != null) {
            trustMgrs = tmf.getTrustManagers();
        }
        return trustMgrs;
    }

    protected KeyManager[] getKeyManagers(String keystoreType, String algorithm, String keyAlias) throws Exception {
        this.verifySecurityDomain();
        KeyManagerFactory kmf = this.securityDomain.getKeyManagerFactory();
        KeyManager[] keyMgrs = null;
        if (kmf != null) {
            keyMgrs = kmf.getKeyManagers();
        }
        return keyMgrs;
    }

    private void verifySecurityDomain() {
        String str = "securityDomain is null.Set it as an attribute in the connector setting";
        if (this.securityDomain == null) {
            throw new IllegalStateException(str);
        }
    }
}

