/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.log4j.Logger;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.Name;

public class XRegistration {
    private Logger log = Logger.getLogger(this.getClass());
    private UDDIClerk toClerk;
    private UDDIClerk fromClerk;
    private String entityKey;

    public XRegistration() {
    }

    public XRegistration(String entityKey, UDDIClerk fromClerk, UDDIClerk toClerk) {
        this.fromClerk = fromClerk;
        this.toClerk = toClerk;
        this.entityKey = entityKey;
    }

    public UDDIClerk getToClerk() {
        return this.toClerk;
    }

    public void setToClerk(UDDIClerk toClerk) {
        this.toClerk = toClerk;
    }

    public UDDIClerk getFromClerk() {
        return this.fromClerk;
    }

    public void setFromClerk(UDDIClerk fromClerk) {
        this.fromClerk = fromClerk;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    public void xRegisterBusiness() {
        try {
            BusinessEntity businessEntity = this.fromClerk.findBusiness(this.entityKey, this.fromClerk.getUDDINode().getApiNode());
            this.log.info((Object)("xregister business " + ((Name)businessEntity.getName().get(0)).getValue() + " + from " + this.fromClerk.getName() + " to " + this.toClerk.getName()));
            businessEntity.setBusinessServices(null);
            this.toClerk.register(businessEntity, this.toClerk.getUDDINode().getApiNode());
        }
        catch (Exception e) {
            this.log.error((Object)("Could not " + this.toString() + ". " + e.getMessage() + " " + e.getCause()), (Throwable)e);
        }
    }

    public void xRegisterService() {
        try {
            BusinessService businessService = this.fromClerk.findService(this.entityKey, this.fromClerk.getUDDINode().getApiNode());
            this.log.info((Object)("xregister service " + ((Name)businessService.getName().get(0)).getValue() + " + from " + this.fromClerk.getName() + " to " + this.toClerk.getName()));
            this.toClerk.register(businessService, this.toClerk.getUDDINode().getApiNode());
        }
        catch (Exception e) {
            this.log.error((Object)("Could not " + this.toString() + ". " + e.getMessage() + " " + e.getCause()), (Throwable)e);
        }
    }

    public void xRegisterServiceBinding() {
        try {
            BindingTemplate bindingTemplate = this.fromClerk.findServiceBinding(this.entityKey, this.fromClerk.getUDDINode().getApiNode());
            BusinessService businessService = this.fromClerk.findService(bindingTemplate.getServiceKey(), this.fromClerk.getUDDINode().getApiNode());
            businessService.getBindingTemplates().getBindingTemplate().clear();
            businessService.getBindingTemplates().getBindingTemplate().add(bindingTemplate);
            this.log.info((Object)("xregister service " + ((Name)businessService.getName().get(0)).getValue() + " + from " + this.fromClerk.getName() + " to " + this.toClerk.getName()));
            this.toClerk.register(businessService, this.toClerk.getUDDINode().getApiNode());
        }
        catch (Exception e) {
            this.log.error((Object)("Could not " + this.toString() + ". " + e.getMessage() + " " + e.getCause()), (Throwable)e);
        }
    }

    public String toString() {
        return " xregister entityKey: " + this.entityKey + " + from " + this.fromClerk.getName() + " to " + this.toClerk.getName();
    }
}

